/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CheckPropertyDescriptor
extends PropertyDescriptor {
    protected Button button;
    private List selectList = new ArrayList();

    public CheckPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void load() {
        boolean stateFlag;
        String value = this.getDescriptorProvider().load().toString();
        boolean bl = stateFlag = value == null == this.button.getEnabled();
        if (stateFlag) {
            this.button.setEnabled(value != null);
        }
        boolean boolValue = "true".equalsIgnoreCase(value);
        if (this.button.getSelection() != boolValue) {
            this.button.setSelection(boolValue);
        }
    }

    public Control getControl() {
        return this.button;
    }

    public Control createControl(Composite parent) {
        this.button = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton(parent, 32, true) : new Button(parent, 32);
        this.button.setText(this.getDescriptorProvider().getDisplayName());
        if (!this.selectList.isEmpty()) {
            this.button.addSelectionListener((SelectionListener)this.selectList.get(0));
        } else {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CheckPropertyDescriptor.this.onClickButton();
                }
            };
            this.selectList.add(listener);
        }
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckPropertyDescriptor.this.onClickButton();
            }
        });
        return this.button;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.selectList.contains(listener)) {
            if (!this.selectList.isEmpty()) {
                this.removeSelectionListener((SelectionListener)this.selectList.get(0));
            }
            this.selectList.add(listener);
            if (this.button != null) {
                this.button.addSelectionListener(listener);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectList.contains(listener)) {
            this.selectList.remove(listener);
            if (this.button != null) {
                this.button.removeSelectionListener(listener);
            }
        }
    }

    private void onClickButton() {
        String value = this.button.getSelection() ? "true" : "false";
        try {
            this.save(value);
        }
        catch (SemanticException e1) {
            WidgetUtil.processError(this.button.getShell(), (Exception)((Object)e1));
        }
    }

    public void save(Object obj) throws SemanticException {
        this.descriptorProvider.save(obj);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.button, isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.button.setVisible(isVisible);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }
}

