/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class NonGEFSynchronizerWithTreeView
implements IColleague {
    private AbstractTreeViewer viewer;
    private Object source;

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public ISelection getSelection() {
        if (this.getTreeViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.getTreeViewer().getSelection();
    }

    public void setSelection(ISelection selection) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSelection(selection, true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    protected void treeSelect(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    protected void fireSelectionChanged(ISelection selection) {
        ReportRequest request = new ReportRequest(this.getSource());
        List list = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            list = ((IStructuredSelection)selection).toList();
        }
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
    }

    public AbstractTreeViewer getTreeViewer() {
        return this.viewer;
    }

    public void setTreeViewer(AbstractTreeViewer viewer) {
        this.viewer = viewer;
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NonGEFSynchronizerWithTreeView.this.treeSelect(event);
            }
        });
    }

    public void dispose() {
        this.viewer = null;
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType())) {
            this.handleSelectionChange(request);
        } else if ("create element".equals(request.getType())) {
            this.handleCreateElement(request);
        }
    }

    protected void handleCreateElement(ReportRequest request) {
        final List list = request.getSelectionObject();
        if (list.size() == 1) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (NonGEFSynchronizerWithTreeView.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    NonGEFSynchronizerWithTreeView.this.viewer.refresh();
                    StructuredSelection selection = new StructuredSelection(list);
                    NonGEFSynchronizerWithTreeView.this.viewer.setSelection((ISelection)selection);
                }
            });
        }
    }

    protected void handleSelectionChange(ReportRequest request) {
        if (request.getSource() == this.getSource()) {
            return;
        }
        List list = request.getSelectionModelList();
        boolean canSetSelection = false;
        for (Object element : list) {
            if (!UIUtil.containElement((AbstractTreeViewer)this.getTreeViewer(), element)) continue;
            canSetSelection = true;
            break;
        }
        if (canSetSelection) {
            this.setSelection((ISelection)new StructuredSelection(list));
        }
    }
}

