/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.views.provider;

import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.extensions.ReportItemViewAdapter;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ChartReportItemViewProvider
extends ReportItemViewAdapter {
    protected static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem.ui");

    public DesignElementHandle createView(DesignElementHandle host) throws BirtException {
        ChartWithAxes cm = ChartWithAxesImpl.createDefault();
        cm.setType("Bar Chart");
        cm.setSubType("Side-by-side");
        SeriesDefinition sdBase = SeriesDefinitionImpl.createDefault();
        Series series = SeriesImpl.createDefault();
        sdBase.getSeries().add((Object)series);
        cm.getBaseAxes()[0].getSeriesDefinitions().add((Object)sdBase);
        SeriesDefinition sdOrth = SeriesDefinitionImpl.createDefault();
        series = BarSeriesImpl.createDefault();
        sdOrth.getSeries().add((Object)series);
        cm.getOrthogonalAxes(cm.getBaseAxes()[0], true)[0].getSeriesDefinitions().add((Object)sdOrth);
        ChartUIUtil.setSeriesName((Chart)cm);
        SampleData sampleData = DataFactory.eINSTANCE.createSampleData();
        sampleData.getBaseSampleData().clear();
        sampleData.getOrthogonalSampleData().clear();
        BaseSampleData sampleDataBase = DataFactory.eINSTANCE.createBaseSampleData();
        sampleDataBase.setDataSetRepresentation("A, B, C");
        sampleData.getBaseSampleData().add((Object)sampleDataBase);
        OrthogonalSampleData sampleDataOrth = DataFactory.eINSTANCE.createOrthogonalSampleData();
        sampleDataOrth.setDataSetRepresentation("5,4,12");
        sampleDataOrth.setSeriesDefinitionIndex(0);
        sampleData.getOrthogonalSampleData().add((Object)sampleDataOrth);
        cm.setSampleData(sampleData);
        String name = ReportPlugin.getDefault().getCustomName("Chart");
        ExtendedItemHandle itemHandle = host.getElementFactory().newExtendedItem(name, "Chart");
        itemHandle.getReportItem().setProperty("chart.instance", (Object)cm);
        return itemHandle;
    }

    public String getViewName() {
        return Messages.getString("ChartReportItemViewProvider.ChartViewName");
    }
}

