/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class StylePropertyMapping {
    protected static final HashMap nameMapping = new HashMap();
    protected static IElementDefn styleDefn;

    static {
        nameMapping.put("fontFamily", 55);
        nameMapping.put("fontStyle", 45);
        nameMapping.put("fontVariant", 34);
        nameMapping.put("fontWeight", 33);
        nameMapping.put("fontSize", 44);
        nameMapping.put("color", 26);
        nameMapping.put("backgroundColor", 25);
        nameMapping.put("backgroundImage", 49);
        nameMapping.put("backgroundRepeat", 15);
        nameMapping.put("backgroundAttachment", 52);
        nameMapping.put("backgroundPositionX", 39);
        nameMapping.put("backgroundPositionY", 50);
        nameMapping.put("wordSpacing", 51);
        nameMapping.put("letterSpacing", 56);
        nameMapping.put("textUnderline", 53);
        nameMapping.put("textOverline", 37);
        nameMapping.put("textLineThrough", 28);
        nameMapping.put("verticalAlign", 38);
        nameMapping.put("textTransform", 35);
        nameMapping.put("textAlign", 24);
        nameMapping.put("textIndent", 21);
        nameMapping.put("lineHeight", 22);
        nameMapping.put("whiteSpace", 36);
        nameMapping.put("marginTop", 2);
        nameMapping.put("marginBottom", 16);
        nameMapping.put("marginLeft", 0);
        nameMapping.put("marginRight", 1);
        nameMapping.put("paddingTop", 10);
        nameMapping.put("paddingBottom", 9);
        nameMapping.put("paddingLeft", 7);
        nameMapping.put("paddingRight", 12);
        nameMapping.put("borderTopWidth", 6);
        nameMapping.put("borderBottomWidth", 23);
        nameMapping.put("borderLeftWidth", 31);
        nameMapping.put("borderRightWidth", 8);
        nameMapping.put("borderTopColor", 14);
        nameMapping.put("borderBottomColor", 20);
        nameMapping.put("borderLeftColor", 29);
        nameMapping.put("borderRightColor", 4);
        nameMapping.put("borderTopStyle", 46);
        nameMapping.put("borderBottomStyle", 32);
        nameMapping.put("borderLeftStyle", 40);
        nameMapping.put("borderRightStyle", 19);
        nameMapping.put("display", 54);
        nameMapping.put("orphans", 43);
        nameMapping.put("widows", 30);
        nameMapping.put("pageBreakAfter", 58);
        nameMapping.put("pageBreakBefore", 47);
        nameMapping.put("pageBreakInside", 57);
        nameMapping.put("masterPage", 42);
        nameMapping.put("showIfBlank", 48);
        nameMapping.put("canShrink", 13);
        nameMapping.put("numberAlign", 11);
        nameMapping.put("bidiTextDirection", 5);
        nameMapping.put("data-format", 3);
    }

    protected static IElementDefn getStyleDefn() {
        if (styleDefn != null) {
            return styleDefn;
        }
        styleDefn = MetaDataDictionary.getInstance().getElement("Style");
        assert (styleDefn != null);
        return styleDefn;
    }

    public static boolean canInherit(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.canInherit();
        }
        return false;
    }

    public static Object getDefaultValue(String name) {
        IElementPropertyDefn defn = StylePropertyMapping.getStyleDefn().getProperty(name);
        if (defn != null) {
            return defn.getDefault();
        }
        return null;
    }

    public static Object getDefaultValue(String name, ReportDesignHandle handle) {
        Object value = StylePropertyMapping.getDefaultValue(name);
        if (value == null && handle != null && handle.isDirectionRTL() && "bidiTextDirection".equals(name)) {
            return "rtl";
        }
        return value;
    }

    public static Object getDefaultValue(int index) {
        return StylePropertyMapping.getDefaultValue(nameMapping.get(index).toString());
    }

    public static int getPropertyID(String name) {
        int id = -1;
        Object obj = nameMapping.get(name);
        if (obj instanceof Integer) {
            id = (Integer)obj;
        }
        return id;
    }

    public static Set getPropertyMapping() {
        return nameMapping.entrySet();
    }
}

