/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.ibm.icu.text.Bidi;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineStackingArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LocalProperties;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.w3c.dom.css.CSSValue;

public class LineArea
extends InlineStackingArea {
    protected byte baseLevel = 0;
    protected boolean setIndent = false;
    private TextArea lastTextAreaForJustify = null;

    public LineArea(ContainerArea parent, LayoutContext context) {
        super(parent, context, null);
        assert (parent != null);
        this.isInInlineStacking = parent.isInInlineStacking;
    }

    public LineArea(LineArea area) {
        super(area);
        this.baseLevel = area.baseLevel;
        this.isInlineStacking = true;
    }

    public void setBaseLevel(byte baseLevel) {
        this.baseLevel = baseLevel;
    }

    public void addChild(IArea area) {
        int childHorizontalSpan = area.getX() + area.getWidth();
        int childVerticalSpan = area.getY() + area.getHeight();
        if (childHorizontalSpan > this.width) {
            this.setWidth(childHorizontalSpan);
        }
        if (childVerticalSpan > this.height) {
            this.setHeight(childVerticalSpan);
        }
        this.children.add(area);
    }

    public void setTextIndent(ITextContent content) {
        if (this.currentIP == 0 && !this.setIndent && content != null) {
            IStyle contentStyle = content.getComputedStyle();
            this.currentIP = PropertyUtil.getDimensionValue(contentStyle.getProperty(21), this.maxAvaWidth);
            this.setIndent = true;
        }
    }

    public void align(boolean endParagraph, LayoutContext context) {
        assert (this.parent instanceof BlockContainerArea);
        CSSValue align = ((BlockContainerArea)this.parent).getTextAlign();
        boolean isRightAligned = BidiAlignmentResolver.isRightAligned(this.parent.content, align, endParagraph);
        if (isRightAligned || IStyle.CENTER_VALUE.equals(align)) {
            int spacing = this.width - this.currentIP;
            Iterator<IArea> iter = this.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                if (isRightAligned) {
                    if (this.parent.content.isDirectionRTL()) {
                        area.setPosition(spacing + area.getX(), area.getY());
                        continue;
                    }
                    area.setPosition(spacing + area.getX() + this.ignoreRightMostWhiteSpace(), area.getY());
                    continue;
                }
                if (!IStyle.CENTER_VALUE.equals(align)) continue;
                area.setPosition(spacing / 2 + area.getX(), area.getY());
            }
        } else if (IStyle.JUSTIFY_VALUE.equals(align) && !endParagraph) {
            this.justify();
        }
        if (context.getBidiProcessing()) {
            this.reorderVisually(this);
        }
        this.verticalAlign();
    }

    private int ignoreRightMostWhiteSpace() {
        AbstractArea area = this;
        while (area instanceof ContainerArea) {
            String text;
            ArrayList<IArea> children = ((ContainerArea)area).children;
            if (children == null || children.size() <= 0) {
                return 0;
            }
            area = (AbstractArea)children.get(children.size() - 1);
            if (!(area instanceof TextArea) || (text = ((TextArea)area).getText()) == null) continue;
            char[] charArray = text.toCharArray();
            int len = charArray.length;
            while (len > 0 && charArray[len - 1] <= ' ') {
                --len;
            }
            if (len == charArray.length) continue;
            return ((TextArea)area).getTextWidth(text.substring(len));
        }
        return 0;
    }

    private int adjustWordSpacing(int wordSpacing, ContainerArea area) {
        if (wordSpacing == 0) {
            return 0;
        }
        Iterator<IArea> iter = area.getChildren();
        int delta = 0;
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            if (child instanceof TextArea) {
                TextArea textArea = (TextArea)child;
                int whiteSpaceNumber = textArea.getWhiteSpaceNumber();
                if (whiteSpaceNumber <= 0) continue;
                TextStyle style = new TextStyle(textArea.getStyle());
                int original = style.getWordSpacing();
                style.setWordSpacing(original + wordSpacing);
                textArea.setStyle(style);
                int spacing = wordSpacing * whiteSpaceNumber;
                child.setWidth(child.getWidth() + spacing);
                child.setPosition(child.getX() + delta, child.getY());
                delta += spacing;
                continue;
            }
            if (child instanceof ContainerArea) {
                child.setPosition(child.getX() + delta, child.getY());
                int spacing = this.adjustWordSpacing(wordSpacing, (ContainerArea)child);
                child.setWidth(child.getWidth() + spacing);
                delta += spacing;
                continue;
            }
            child.setPosition(child.getX() + delta, child.getY());
        }
        return delta;
    }

    private int adjustLetterSpacing(int letterSpacing, ContainerArea area) {
        Iterator<IArea> iter = area.getChildren();
        int delta = 0;
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            if (child instanceof TextArea) {
                TextArea textArea = (TextArea)child;
                String text = textArea.getText();
                int letterSpacingNumber = text.length() > 1 ? text.length() - 1 : 0;
                TextStyle style = new TextStyle(textArea.getStyle());
                int original = style.getLetterSpacing();
                style.setLetterSpacing(original + letterSpacing);
                textArea.setStyle(style);
                int spacing = letterSpacing * letterSpacingNumber;
                child.setWidth(child.getWidth() + spacing);
                child.setPosition(child.getX() + delta, child.getY());
                delta += spacing;
                continue;
            }
            if (child instanceof ContainerArea) {
                child.setPosition(child.getX() + delta, child.getY());
                int spacing = this.adjustLetterSpacing(letterSpacing, (ContainerArea)child);
                child.setWidth(child.getWidth() + spacing);
                delta += spacing;
                continue;
            }
            child.setPosition(child.getX() + delta, child.getY());
        }
        return delta;
    }

    private int getWhiteSpaceNumber(LineArea line) {
        String text;
        int count = this.getWhiteSpaceRawNumber(line);
        if (this.lastTextAreaForJustify != null && (text = this.lastTextAreaForJustify.getText()) != null) {
            char[] charArray = text.toCharArray();
            int len = charArray.length;
            while (len > 0 && charArray[len - 1] <= ' ') {
                --len;
            }
            if (len != charArray.length) {
                count -= charArray.length - len;
                this.lastTextAreaForJustify.setWhiteSpaceNumber(this.lastTextAreaForJustify.getWhiteSpaceNumber() - (charArray.length - len));
                this.lastTextAreaForJustify.setText(text.substring(0, len));
                this.lastTextAreaForJustify = null;
            }
        }
        return count;
    }

    private int getWhiteSpaceRawNumber(ContainerArea area) {
        int count = 0;
        Iterator<IArea> iter = area.getChildren();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            if (child instanceof TextArea) {
                int innerCount = 0;
                String text = ((TextArea)child).getText();
                int i = 0;
                while (i < text.length()) {
                    if (text.charAt(i) <= ' ') {
                        ++innerCount;
                    }
                    ++i;
                }
                count += innerCount;
                ((TextArea)child).setWhiteSpaceNumber(innerCount);
                this.lastTextAreaForJustify = (TextArea)child;
                continue;
            }
            if (!(child instanceof ContainerArea)) continue;
            count += this.getWhiteSpaceRawNumber((ContainerArea)child);
        }
        return count;
    }

    private int getLetterNumber(ContainerArea area) {
        int count = 0;
        Iterator<IArea> iter = area.getChildren();
        while (iter.hasNext()) {
            AbstractArea child = (AbstractArea)iter.next();
            if (child instanceof TextArea) {
                String text = ((TextArea)child).getText();
                count = text.length();
                continue;
            }
            if (!(child instanceof ContainerArea)) continue;
            count += this.getLetterNumber((ContainerArea)child);
        }
        return count;
    }

    protected void justify() {
        int spacing = this.width - this.currentIP;
        int whiteSpaceNumber = this.getWhiteSpaceNumber(this);
        if (whiteSpaceNumber > 0) {
            int wordSpacing = spacing / whiteSpaceNumber;
            this.adjustWordSpacing(wordSpacing, this);
        } else {
            int letterNumber = this.getLetterNumber(this);
            if (letterNumber > 1) {
                int letterSpacing = spacing / (letterNumber - 1);
                this.adjustLetterSpacing(letterSpacing, this);
            }
        }
    }

    private void reorderVisually(ContainerArea parent) {
        int n = parent.getChildrenCount();
        if (n == 0) {
            return;
        }
        int i = 0;
        Object[] areas = new AbstractArea[n];
        byte[] levels = new byte[n];
        Iterator<IArea> iter = parent.getChildren();
        while (i < n && iter.hasNext()) {
            AbstractArea area;
            areas[i] = area = (AbstractArea)iter.next();
            if (area instanceof TextArea) {
                levels[i] = (byte)((TextArea)area).getRunLevel();
            } else {
                levels[i] = this.baseLevel;
                if (area instanceof InlineStackingArea) {
                    this.reorderVisually((ContainerArea)area);
                }
            }
            ++i;
        }
        if (n > 1) {
            int x = areas[0].getAllocatedX();
            Bidi.reorderVisually((byte[])levels, (int)0, (Object[])areas, (int)0, (int)n);
            i = 0;
            while (i < n - 1) {
                if (!((AbstractArea)areas[i]).isIgnoreReordering()) {
                    ((AbstractArea)areas[i]).setAllocatedPosition(x, ((AbstractArea)areas[i]).getAllocatedY());
                    x += ((AbstractArea)areas[i]).getAllocatedWidth();
                }
                ++i;
            }
            if (!((AbstractArea)areas[i]).isIgnoreReordering()) {
                ((AbstractArea)areas[i]).setAllocatedPosition(x, ((AbstractArea)areas[i]).getAllocatedY());
            }
        }
    }

    public void endLine(boolean endParagraph) throws BirtException {
        this.close(false, endParagraph);
        this.currentIP = 0;
        if (endParagraph) {
            this.setIndent = false;
        }
    }

    public int getMaxLineWidth() {
        return this.maxAvaWidth;
    }

    public boolean isEmptyLine() {
        return this.getChildrenCount() == 0;
    }

    public void update(AbstractArea area) throws BirtException {
        int aWidth = area.getAllocatedWidth();
        if (aWidth + this.currentIP > this.maxAvaWidth) {
            this.removeChild(area);
            this.endLine(false);
            this.children.add(area);
        }
        area.setAllocatedPosition(this.currentIP, this.currentBP);
        this.currentIP += aWidth;
        int height = area.getAllocatedHeight();
        if (height > this.getHeight()) {
            this.height = height;
        }
    }

    protected void close(boolean isLastLine, boolean endParagraph) throws BirtException {
        if (this.children.size() == 0) {
            return;
        }
        int lineHeight = ((BlockContainerArea)this.parent).getLineHeight();
        this.height = Math.max(this.height, lineHeight);
        this.width = Math.max(this.currentIP, this.maxAvaWidth);
        this.align(endParagraph, this.context);
        this.checkDisplayNone();
        if (isLastLine) {
            this.parent.add(this);
            this.checkPageBreak();
            this.parent.update(this);
            this.finished = true;
        } else {
            LineArea area = this.cloneArea();
            area.children = this.children;
            area.context = this.context;
            area.setParent(this.parent);
            Iterator<IArea> iter = area.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                child.setParent(area);
            }
            this.children = new ArrayList();
            this.parent.add(area);
            this.checkPageBreak();
            this.parent.update(area);
            area.finished = true;
            this.height = 0;
            this.baseLine = 0;
        }
    }

    public void close() throws BirtException {
        this.close(true, true);
        this.finished = true;
    }

    public void initialize() throws BirtException {
        this.hasStyle = false;
        this.boxStyle = BoxStyle.DEFAULT;
        this.localProperties = LocalProperties.DEFAULT;
        this.width = this.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        if (this.parent.content != null && this.parent.content.isDirectionRTL()) {
            this.baseLevel = 1;
        }
    }

    public ContainerArea.SplitResult split(int height, boolean force) throws BirtException {
        ContainerArea child;
        assert (height < this.height);
        ContainerArea result = null;
        Iterator<Object> iter = this.children.iterator();
        while (iter.hasNext()) {
            ContainerArea child2 = (ContainerArea)iter.next();
            if (child2.getMinYPosition() <= height) {
                iter.remove();
                if (result == null) {
                    result = this.cloneArea();
                }
                ((LineArea)result).addChild(child2);
                child2.setParent(result);
                continue;
            }
            ContainerArea.SplitResult splitChild = child2.split(height - child2.getY(), force);
            ContainerArea splitChildArea = splitChild.getResult();
            if (splitChildArea == null) continue;
            if (result == null) {
                result = this.cloneArea();
            }
            ((LineArea)result).addChild(splitChildArea);
            splitChildArea.setParent(result);
        }
        if (result != null) {
            int h = 0;
            iter = result.getChildren();
            while (iter.hasNext()) {
                child = (ContainerArea)iter.next();
                h = Math.max(h, child.getAllocatedHeight());
            }
            result.setHeight(h);
        }
        if (this.children.size() > 0) {
            int h = 0;
            iter = this.getChildren();
            while (iter.hasNext()) {
                child = (ContainerArea)iter.next();
                h = Math.max(h, child.getAllocatedHeight());
            }
            this.setHeight(h);
        }
        if (result != null) {
            return new ContainerArea.SplitResult(result, 0);
        }
        return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
    }

    public LineArea cloneArea() {
        return new LineArea(this);
    }

    public ContainerArea.SplitResult splitLines(int lineCount) throws BirtException {
        return ContainerArea.SplitResult.SUCCEED_WITH_NULL;
    }

    public boolean isPageBreakAfterAvoid() {
        return false;
    }

    public boolean isPageBreakBeforeAvoid() {
        return false;
    }

    public boolean isPageBreakInsideAvoid() {
        return false;
    }
}

