import hiro.yoshioka.job.AbsBasicPoiWriter;

import java.io.File;
import java.util.HashMap;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.HSSFColor;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;

public class MsgWriter extends AbsBasicPoiWriter {
	private int fOffset = 3;

	private int fClassCnt = 0;

	private HSSFCellStyle fHSSFCellStyle;

	private HSSFCellStyle fHSSFCellWhiteStyle;

	private HashMap nameMap = new HashMap();

	public MsgWriter() {
		super(new File("template/template1.xls"));
		init();
		createFont8();
	}

	private void createFont8() {
		HSSFFont font = fHSSFWorkbook.createFont();

		font.setFontHeightInPoints((short) 8);

		font.setFontName("Verdana");

		fHSSFCellStyle = fHSSFWorkbook.createCellStyle();

		fHSSFCellStyle.setFont(font);

		setBorderThin(fHSSFCellStyle, HSSFCellStyle.BORDER_THIN);

		HSSFFont font2 = fHSSFWorkbook.createFont();

		font2.setFontHeightInPoints((short) 8);
		font2.setColor(HSSFColor.WHITE.index);

		font2.setFontName("Verdana");
		fHSSFCellWhiteStyle = fHSSFWorkbook.createCellStyle();

		fHSSFCellWhiteStyle.setFont(font2);
		setBorderThin(fHSSFCellWhiteStyle, HSSFCellStyle.BORDER_THIN);
	}

	public HSSFCell createHSSFCell(HSSFSheet sheet, String colno, int row) {
		HSSFCell cell = super.createHSSFCell(sheet, colno, row);
		cell.setCellStyle(fHSSFCellStyle);
		return cell;
	}

	public HSSFCell createHSSFCell(HSSFSheet sheet, short colno, int row) {
		HSSFCell cell = super.createHSSFCell(sheet, colno, row);
		cell.setCellStyle(fHSSFCellStyle);
		return cell;
	}

	public void doWork(ClassDoc clazz) {
		HSSFSheet sheet = null;

		sheet = fHSSFWorkbook.getSheet("Sheet1");

		MethodDoc[] methodDocs = clazz.methods();

		fClassCnt++;

		String pack = "";
		if (clazz.qualifiedName().indexOf('.') >= 0) {
			pack = clazz.qualifiedName().replaceAll("(.*)[.].*", "$1");
		}
		for (int i = 0; i < methodDocs.length; i++) {
			HSSFCell cell = createHSSFCell(sheet, "B", fOffset); // NO
			cell.setCellValue(fClassCnt);
			if (i > 0) {
				cell.setCellStyle(fHSSFCellWhiteStyle);
			}

			cell = createHSSFCell(sheet, "C", fOffset);
			cell.setCellValue(pack);
			if (i > 0) {
				cell.setCellStyle(fHSSFCellWhiteStyle);
			}

			cell = createHSSFCell(sheet, "D", fOffset);
			cell.setCellValue(clazz.modifiers());
			if (i > 0) {
				cell.setCellStyle(fHSSFCellWhiteStyle);
			}
			cell = createHSSFCell(sheet, "E", fOffset);
			cell.setCellValue(clazz.name());
			if (i > 0) {
				cell.setCellStyle(fHSSFCellWhiteStyle);
			}
			cell = createHSSFCell(sheet, "F", fOffset);
			cell.setCellValue(clazz.commentText());
			if (i > 0) {
				cell.setCellStyle(fHSSFCellWhiteStyle);
			}

			cell = createHSSFCell(sheet, "G", fOffset);
			cell.setCellValue(methodDocs[i].modifiers());

			cell = createHSSFCell(sheet, "H", fOffset);
			cell.setCellValue(methodDocs[i].name());

			cell = createHSSFCell(sheet, "I", fOffset);
			cell.setCellValue(methodDocs[i].commentText());

			cell = createHSSFCell(sheet, "J", fOffset);
			cell.setCellValue(methodDocs[i].position().line());

			fOffset++;
		}

	}
}
