/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.javadoc2excel.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class Main
extends JFrame
implements MouseListener {
    public static JDialog dialog;
    JTextField RootDirPathTextField;
    JTextField executeCommand;
    JPanel sourceSelectPanel;
    protected JList list;
    protected DefaultListModel model;
    private String selectedVisiblity = "-protected";
    JButton selectAllButton;
    private String[] commandArgs = new String[0];

    public static void main(String[] args) {
        Main obj = new Main();
        obj.doWork();
    }

    public static void resetProgresDialog() {
    }

    private void doWork() {
        this.setDefaultCloseOperation(3);
        this.setSize(540, 420);
        this.setTitle("JavaDoc2Excel ver1.0");
        this.createPane(this.getContentPane());
        this.setVisible(true);
        this.refreshCommand();
    }

    private JPanel createVisiblity() {
        TitledBorder tb = new TitledBorder("Visiblity");
        JPanel panel = new JPanel(new GridLayout(1, 4));
        panel.setBorder(tb);
        JRadioButton radio1 = new JRadioButton("public");
        JRadioButton radio2 = new JRadioButton("protected");
        radio2.setSelected(true);
        JRadioButton radio3 = new JRadioButton("package");
        JRadioButton radio4 = new JRadioButton("private");
        ButtonGroup group = new ButtonGroup();
        MyActionListner lis = new MyActionListner();
        radio1.addActionListener(lis);
        radio2.addActionListener(lis);
        radio3.addActionListener(lis);
        radio4.addActionListener(lis);
        group.add(radio1);
        group.add(radio2);
        group.add(radio3);
        group.add(radio4);
        panel.add(radio1);
        panel.add(radio2);
        panel.add(radio3);
        panel.add(radio4);
        return panel;
    }

    private void refreshCommand() {
        ArrayList<String> comList = new ArrayList<String>();
        comList.add("-doclet");
        comList.add("YonDoc");
        comList.add(this.selectedVisiblity);
        comList.add("-sourcepath");
        comList.add(this.RootDirPathTextField.getText());
        int i = 0;
        while (i < this.model.size()) {
            JCheckBox ch = (JCheckBox)this.model.get(i);
            if (ch.isSelected()) {
                comList.add(ch.getText());
            }
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < comList.size()) {
            buf.append(" ").append((String)comList.get(i2));
            ++i2;
        }
        this.commandArgs = comList.toArray(new String[comList.size()]);
        if (this.executeCommand != null) {
            this.executeCommand.setText(buf.toString());
        }
    }

    private void createPane(Container contentPane) {
        contentPane.add((Component)this.createVisiblity(), "North");
        contentPane.add(this.crateRootFolder());
        contentPane.add(this.createExecutor(), "South");
    }

    private Component createExecutor() {
        TitledBorder tb = new TitledBorder("javadoc Command");
        JPanel panel = new JPanel();
        panel.setBorder(tb);
        this.executeCommand = new JTextField("javadoc.exe ");
        Dimension d = this.executeCommand.getPreferredSize();
        d.width += 330;
        this.executeCommand.setPreferredSize(d);
        panel.add(this.executeCommand);
        final JButton bt = new JButton("Execute");
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    bt.setEnabled(false);
                    int i = 0;
                    while (i < Main.this.commandArgs.length) {
                        System.out.println("param[" + (i + 1) + "]\u3010" + Main.this.commandArgs[i] + "\u3011");
                        ++i;
                    }
                    dialog = new JDialog(Main.this, "Forget-me-Not", true);
                    com.sun.tools.javadoc.Main.execute((String[])Main.this.commandArgs);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        panel.add((Component)bt, "East");
        return panel;
    }

    private JPanel crateRootFolder() {
        TitledBorder tb = new TitledBorder("SourcePath");
        this.sourceSelectPanel = new JPanel();
        this.sourceSelectPanel.setBorder(tb);
        FlowLayout fl = new FlowLayout(0, 1, 1);
        JPanel topPanel = new JPanel(fl);
        JButton bt = new JButton("RootDir...");
        topPanel.add(bt);
        this.RootDirPathTextField = new JTextField(".");
        this.RootDirPathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Main.this.resetFileList();
            }
        });
        Dimension d = this.RootDirPathTextField.getPreferredSize();
        d.width += 360;
        this.RootDirPathTextField.setPreferredSize(d);
        topPanel.add(this.RootDirPathTextField);
        bt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = new File(Main.this.RootDirPathTextField.getText());
                JFileChooser ch = null;
                ch = f.exists() ? new JFileChooser(f) : new JFileChooser(".");
                ch.setFileSelectionMode(1);
                ch.showOpenDialog(Main.this.getContentPane());
                Main.this.RootDirPathTextField.setText(ch.getSelectedFile().getAbsolutePath());
                Main.this.resetFileList();
            }
        });
        this.sourceSelectPanel.add((Component)topPanel, "North");
        JPanel leftPanel = new JPanel(new GridLayout(2, 1));
        this.selectAllButton = new JButton("SelectAll");
        this.selectAllButton.addActionListener(new MySelection(true));
        JButton radio2 = new JButton("clearAll");
        radio2.addActionListener(new MySelection(false));
        this.selectAllButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.selectAllButton);
        group.add(radio2);
        leftPanel.add(this.selectAllButton);
        leftPanel.add(radio2);
        this.sourceSelectPanel.add((Component)leftPanel, "West");
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.resetFileList();
        this.list.addMouseListener(this);
        MyCellRenderer renderer = new MyCellRenderer();
        this.list.setCellRenderer(renderer);
        JScrollPane sp = new JScrollPane();
        sp.getViewport().setView(this.list);
        this.sourceSelectPanel.add(sp);
        return this.sourceSelectPanel;
    }

    private void resetFileList() {
        this.model.removeAllElements();
        this.list.removeAll();
        String[] initData = this.getFileList(new File(this.RootDirPathTextField.getText()));
        int i = 0;
        while (i < initData.length) {
            JCheckBox jc = new JCheckBox(initData[i]);
            jc.setSelected(true);
            this.model.addElement(jc);
            ++i;
        }
        this.list.repaint();
        this.refreshCommand();
    }

    String[] getFileList(File f) {
        ArrayList<String> retList = new ArrayList<String>();
        if (f != null) {
            this.fl(f, retList);
        }
        return retList.toArray(new String[retList.size()]);
    }

    private void fl(File f, ArrayList<String> retList) {
        boolean hasJava = false;
        File[] children = f.listFiles();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                this.fl(children[i], retList);
            } else if (children[i].isFile() && children[i].getName().endsWith(".java")) {
                hasJava = true;
            }
            ++i;
        }
        if (hasJava) {
            File rd = new File(this.RootDirPathTextField.getText());
            int len = rd.getAbsolutePath().length();
            String path = f.getAbsolutePath().substring(len);
            if (path.startsWith("\\") || path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((path = path.replace(File.separator, ".")).trim().length() > 0) {
                retList.add(path);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        int index = this.list.locationToIndex(p);
        JCheckBox checkBox = (JCheckBox)this.model.getElementAt(index);
        if (checkBox.isSelected()) {
            checkBox.setSelected(false);
        } else {
            checkBox.setSelected(true);
        }
        this.list.repaint();
        this.refreshCommand();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    class MyActionListner
    implements ActionListener {
        MyActionListner() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String str = ((JRadioButton)e.getSource()).getText();
            Main.this.selectedVisiblity = "-" + str;
            Main.this.refreshCommand();
        }
    }

    class MyCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JCheckBox checkBox = (JCheckBox)value;
            this.setText(checkBox.getText());
            this.setSelected(checkBox.isSelected());
            return this;
        }
    }

    class MySelection
    implements ActionListener {
        boolean state;

        public MySelection(boolean state) {
            this.state = state;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = 0;
            while (i < Main.this.model.size()) {
                ((JCheckBox)Main.this.model.elementAt(i)).setSelected(this.state);
                ++i;
            }
            Main.this.list.repaint();
            Main.this.refreshCommand();
        }
    }
}

