package hiro.yoshioka.sql.view;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.ResourceSorter;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBResource;
import hiro.yoshioka.sql.resource.DBResourceTransfer;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.util.ui.IPressEnterListener;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class DBResourceTreeViewer extends TreeViewer implements
		IRequestListener, IPressEnterListener {
	List<IDBResourceTreeViewerListener> listenerList;
	ConnectionProperties latestSelectedConnectionProperties;
	public static final String[] HEADER_NAME = { "Resource", "TYPE" };
	public static final int[] HEADER_WIDTH = { 200, 110 };

	public DBResourceTreeViewer(Composite parent) {
		super(parent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);

		try {
			int idx = 0;
			for (String name : HEADER_NAME) {
				TreeViewerColumn col = new TreeViewerColumn(this, SWT.NONE);
				col.getColumn().setText(name);
				col.getColumn().setWidth(HEADER_WIDTH[idx++]);
				col.setLabelProvider(new DBTreeLabelProvider(name));
			}
			getTree().setHeaderVisible(true);
			getTree().setLinesVisible(true);
			setUseHashlookup(true);

			// setTitleImage(Util.getImage(IImageFileConst.OUTLINE_CO_GIF));
			setContentProvider(new DBTreeContentProvider());
			// setLabelProvider(new DBTreeLabelProvider());
			setSorter(fResourceSorter);
			addFilter(fFilter);
			if (latestSelectedConnectionProperties != null
					&& latestSelectedConnectionProperties.size() <= 1) {
				setAutoExpandLevel(3);
			} else {
				setAutoExpandLevel(2);
			}
			setInput(null);

			int dragOption = DND.DROP_COPY | DND.DROP_MOVE;
			Transfer[] transfers = new Transfer[] { TextTransfer.getInstance(),
					DBResourceTransfer.getInstance() };
			// DragSourceListener̐ݒ
			addDragSupport(dragOption, transfers, new DragSourceAdapterImpl(
					this));

			// showDBResouces();

		} catch (Throwable e) {
			e.printStackTrace();
		}

	}

	public Object getFirstSelection() {
		IStructuredSelection sel = (IStructuredSelection) getSelection();
		if (sel != null) {
			return sel.getFirstElement();
		}
		return null;
	}

	@Override
	protected void fireSelectionChanged(SelectionChangedEvent event) {
		if (getTree().getSelectionCount() > 0) {
			latestSelectedConnectionProperties = getConnectionPropRecurse(getTree()
					.getSelection()[0]);
		} else {
			latestSelectedConnectionProperties = null;
		}
		Object o = ((IStructuredSelection) event.getSelection())
				.getFirstElement();
		super.fireSelectionChanged(event);
		if (listenerList != null) {
			for (IDBResourceTreeViewerListener li : listenerList) {
				li.fireSelectionChanged(
						getLatestSelectedConnectionProperties(), o);
			}
		}
	}

	@Override
	protected void fireDoubleClick(DoubleClickEvent event) {
		super.fireDoubleClick(event);
		Object o = ((IStructuredSelection) event.getSelection())
				.getFirstElement();
		if (listenerList != null) {
			for (IDBResourceTreeViewerListener li : listenerList) {
				li.fireDoubleClick(getLatestSelectedConnectionProperties(), o);
			}
		}
	}

	public ConnectionProperties getLatestSelectedConnectionProperties() {
		return latestSelectedConnectionProperties;
	}

	private ConnectionProperties getConnectionPropRecurse(TreeItem item) {
		Object o = item.getData();
		if (o instanceof ConnectionProperties) {
			return (ConnectionProperties) o;
		}
		TreeItem parent = item.getParentItem();
		if (parent != null) {
			return getConnectionPropRecurse(parent);
		}
		return null;
	}

	protected transient Log fLogger = LogFactory.getLog(getClass());

	private boolean fSelectionResourceMulti;
	private int fSelectionResourceType;
	private boolean fTextExtension;

	ResourceSorter fResourceSorter = new ResourceSorter();

	DBTreeFilter fFilter = new DBTreeFilter();

	static final GridLayout RootGridLayout = new GridLayout();

	public void addDBResourceTreeViewerListener(
			IDBResourceTreeViewerListener listener) {
		if (this.listenerList == null) {
			this.listenerList = new ArrayList<IDBResourceTreeViewerListener>();
		}
		this.listenerList.add(listener);
	}

	public DBTreeFilter getFilter() {
		return fFilter;
	}

	public void setFilterPattern(String pattern) {
		fFilter.setPattern(pattern);
	}

	public void setSortMode(int mode) {
		fResourceSorter.setMode(mode);
		refresh();
	}

	// -------------------------------------------------------------
	private class DragSourceAdapterImpl extends DragSourceAdapter {
		private TreeViewer viewer;

		public DragSourceAdapterImpl(TreeViewer viewer) {
			this.viewer = viewer;
		}

		/**
		 * hbOf[^eventɒlZbg邽߂̃\bh Method declared on DragSourceListener
		 */
		public void dragSetData(DragSourceEvent event) {
			fLogger.warn("dragSetData(DragSourceEvent) - start");

			TreeItem[] items = getTree().getSelection();

			DBResource[] sels = new DBResource[items.length];
			for (int i = 0; i < sels.length; i++) {
				sels[i] = (DBResource) items[i].getData();
			}

			// ŃCxgĂH
			if (DBResourceTransfer.getInstance()
					.isSupportedType(event.dataType)) {
				fLogger.warn("DBResourceTransfer event.dataType");
				event.data = sels;
				// ł̃t@CRs[B
			} else if (TextTransfer.getInstance().isSupportedType(
					event.dataType)) {
				// TextTransferAʂ̃TCg̃^CgeventɃZbg
				fLogger.warn("TextTransfer event.dataType");
				event.data = sels[0].getNameWithComment();
			}
			fLogger.warn(event.toString());
			fLogger.warn("dragSetData(DragSourceEvent) - end");
		}
	}

	public void refreshResourceLazy(final Object o) {
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				refresh(o);
			}
		});
	}

	@Override
	public void called_pre(Request request, SQLOperationType operation) {
	}

	@Override
	public void begtinTask(String taskName, int row) {
	}

	@Override
	public void called_done(Request request, SQLOperationType operation,
			final ConnectionProperties properteis, final Object o) {
		switch (operation) {
		case CONNECT:
		case CLOSE:
		case RESOURCE_CAPTION:
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					refresh();
				}
			});
			break;
		case PREPARED_EXECUTE:
		case PREPARED_EXECUTE_QUERY:
		case EXECUTE:
			Display.getDefault().asyncExec(new Runnable() {
				@Override
				public void run() {
					System.out.println("refresh recently");
					refresh(properteis.getDBRoot().getRecentryUsedResource());
				}
			});
			break;
		}
	}

	@Override
	public void subTask(String subTaskName) {
	}

	@Override
	public void worked(int i) {
	}

	@Override
	public void pressEnter(String text) {
		System.out.println("pressEnter[" + text + "]");
		setFilterPattern(text);
		refresh();
	}

}
