package hiro.yoshioka.sql.util;

import hiro.yoshioka.ast.sql.DatabaseType;
import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.extract.ArchiveManager;
import hiro.yoshioka.sql.DataBaseFactory;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBResourceCapturingFilter;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.util.ColorNameEnum;
import hiro.yoshioka.util.ColorUtil;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class DBConfigDialog extends TitleAreaDialog implements KeyListener,
		SelectionListener {
	static String[] SYSOP = { StringUtil.EMPTY_STRING, "sysdba", "sysoper" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	Combo fCombo;
	Combo fSysCombo;

	int[] fJarFilesIndexes;
	String[] fJarFiles;
	Label fUrlOrHostLabel;
	// Filters
	Label fCategoriesPatternLabel;
	Label fFilePathPatternLabel;
	Label fDBObjectPattern1Label;
	Label fDBObjectPattern2Label;
	Text fCategoriesRegexText;
	Text fFilePathText;
	Text fDBObjectRegex1Text;
	Text fDBObjectRegex2Text;

	Text fUrlOrHostText;
	Text fDatabaseText;
	Text fUserText;
	Text fPasswordText;
	Text fDisplayNameText;
	Spinner fRecursiveSearchSpin;

	Button fCheckDBMSButton;
	Button fCaptureResourceAfterTheConnectProcessButton;
	Button fCaptureWithColumnInfoButton;
	Button fCaptureWithDDLButton;
	Button fCheckSerializeButton;
	Button fCaptureWithViewButton;
	boolean createdEditors;
	ConnectionProperties fConnectionProperties;
	CTabFolder tabFolder;
	Group baseGroup;
	// --------------------------
	Button nothingBtn, ignoreBtn, matchBtn;

	boolean clone;
	boolean initializing, checked;
	int max = Display.getCurrent().getBounds().width - 100;

	@Override
	protected boolean isResizable() {
		return true;
	}

	public DBConfigDialog(Shell shell, String[] jarfiles,
			ConnectionProperties selectedItem, boolean clone) {
		super(shell);
		fJarFiles = jarfiles;
		fConnectionProperties = selectedItem;
		this.clone = clone;
	}

	Text createText(Composite parent) {
		Text ret = new Text(parent, SWT.BORDER);
		// ret.setEditable(false);
		ret.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return ret;
	}

	private Label createLabel(Composite parent, String text) {
		Label lb = new Label(parent, SWT.NONE);
		lb.setText(text);
		return lb;
	}

	private void resetTab() {
		fFilePathText.setVisible(true);
		fFilePathPatternLabel.setVisible(true);
		DatabaseType dType = DatabaseType.parse(fCombo.getText());
		System.out.println("resetTab type= = " + dType + "]");

		String suggestUrl = DataBaseFactory.getSuggestURL(dType);
		System.out.println("resetTba [" + suggestUrl + "]");
		fUrlOrHostText.setMessage(suggestUrl);
		fCategoriesPatternLabel.setText("Catalog:");
		fDatabaseText.setEditable(false);
		fCategoriesRegexText.setEnabled(!nothingBtn.getSelection());
		fFilePathText.setEnabled(!nothingBtn.getSelection());
		fDBObjectRegex1Text.setEnabled(!nothingBtn.getSelection());
		fDBObjectRegex2Text.setEnabled(!nothingBtn.getSelection());
		Color color = nothingBtn.getSelection() ? ColorUtil
				.getColor(ColorNameEnum.GLAY) : ColorUtil
				.getColor(ColorNameEnum.BLACK);
		fCategoriesPatternLabel.setForeground(color);
		fFilePathPatternLabel.setForeground(color);
		fDBObjectPattern1Label.setForeground(color);
		fDBObjectPattern2Label.setForeground(color);
		if (dType == DatabaseType.MONGO) {
			fUrlOrHostLabel.setText("Host:");
			fDatabaseText.setEditable(true);
		} else if (dType == DatabaseType.ORACLE) {
			fCategoriesPatternLabel.setText("SCHEMA:");
			fCategoriesRegexText.setMessage(fConnectionProperties
					.getAuthenticate().user.toUpperCase());
			fFilePathText.setVisible(false);
			fFilePathPatternLabel.setVisible(false);
		} else if (dType == DatabaseType.DOMINO) {
			fUrlOrHostLabel.setText("Host:");
			fCategoriesPatternLabel.setText("Category:");
			fCategoriesRegexText.setMessage("NotesHelp");
			fDBObjectRegex1Text.setMessage("^(Lotus Notes|Domino).*");
		} else {
			fUrlOrHostLabel.setText("URL: "); //$NON-NLS-1$ 
		}
		validate();
	}

	private void validate() {
		Button bt = getButton(IDialogConstants.OK_ID);
		if (bt == null) {
			return;
		}
		if (fCombo.getSelectionIndex() < 0) {
			bt.setEnabled(false);
			setErrorMessage("Choose Driver Class !");
			return;
		}
		switch (DatabaseType.parse(fCombo.getText())) {
		case MONGO:
		case DOMINO:
			if (StringUtil.isEmpty(fUrlOrHostText.getText().trim())) {
				bt.setEnabled(false);
				setErrorMessage("Input Host !");
				return;
			}
			break;
		default:
			if (StringUtil.isEmpty(fUrlOrHostText.getText().trim())) {
				bt.setEnabled(false);
				setErrorMessage("Input URL !");
				return;
			}
		}
		String displayName = fDisplayNameText.getText().trim();
		if (StringUtil.isEmpty(displayName)) {
			bt.setEnabled(false);
			setErrorMessage("Input DISPLAY NAME !");
			return;
		}
		setErrorMessage(null);
		bt.setEnabled(true);
	}

	protected Control createDialogArea(Composite parent) {

		getShell().setText("Set ConnectionProperties");
		System.out.println("parent" + parent.getLayout());
		Composite inner = new Composite(parent, SWT.NONE);
		inner.setLayoutData(new GridData(GridData.FILL_BOTH));
		GridLayout layout = new GridLayout(1, false);
		inner.setLayout(layout);
		Group driverGroup = createGroup(inner, "[1] JDBC Driver Class", 1);
		fCombo = new Combo(driverGroup, SWT.DROP_DOWN | SWT.READ_ONLY
				| SWT.BORDER);
		fCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		// tabFolder = new CTabFolder(inner, SWT.NONE);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 2;
		// tabFolder.setLayoutData(gd);

		baseGroup = createGroup(inner, "[2] Basic Properties", 2);
		baseGroup.setLayoutData(gd);

		createLabel(baseGroup, "DATABASE: "); //$NON-NLS-1$ 
		fDatabaseText = new Text(baseGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fDatabaseText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		fUrlOrHostLabel = createLabel(baseGroup, "Host: "); //$NON-NLS-1$ 
		fUrlOrHostText = new Text(baseGroup, SWT.SINGLE | SWT.BORDER);
		fUrlOrHostText.setToolTipText("<INPUT>CTRL+SPACE");
		fUrlOrHostText.addKeyListener(new KeyAdapter() {
			@Override
			public void keyPressed(KeyEvent e) {
				if ((e.stateMask == SWT.COMMAND || e.stateMask == SWT.CTRL)
						&& e.keyCode == ' ') {
					if (fUrlOrHostText.getText().trim().length() == 0) {
						fUrlOrHostText.setText(DataBaseFactory
								.getSuggestURL(DatabaseType.parse(fCombo
										.getText())));
					}
					e.doit = false;
				}
			}
		});
		GridData gd3 = new GridData(GridData.FILL_HORIZONTAL);
		gd3.widthHint = 200;
		fUrlOrHostText.setLayoutData(gd3);

		createLabel(baseGroup, "USER: "); //$NON-NLS-1$ 
		fUserText = new Text(baseGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fUserText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		fUserText.addFocusListener(new FocusAdapter() {
			@Override
			public void focusLost(FocusEvent e) {
				checkAndSetOracleFilter();
			}
		});

		createLabel(baseGroup, "PASSWORD: "); //$NON-NLS-1$ 
		fPasswordText = new Text(baseGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fPasswordText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		createLabel(baseGroup, "DISPLAY NAME: "); //$NON-NLS-1$ 
		fDisplayNameText = new Text(baseGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fDisplayNameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		createLabel(baseGroup, "RECURSIVE SEARCH DEPTH: "); //$NON-NLS-1$ 
		fRecursiveSearchSpin = new Spinner(baseGroup, SWT.BORDER);
		fRecursiveSearchSpin.setValues(1, 0, 5, 0, 1, 1);
		fRecursiveSearchSpin.setLayoutData(new GridData(
				GridData.FILL_HORIZONTAL));
		createLabel(baseGroup, "SYSDBA か SYSOPER か　未指定: ");

		fSysCombo = new Combo(baseGroup, SWT.DROP_DOWN | SWT.READ_ONLY
				| SWT.BORDER);
		fSysCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		fSysCombo.setItems(SYSOP);
		fSysCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		createLabel(baseGroup, "DBMS OUTPUT: ");
		fCheckDBMSButton = new Button(baseGroup, SWT.CHECK);
		fCheckDBMSButton.setText("display in ErrorView");
		fCheckDBMSButton.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		fCombo.addSelectionListener(this);
		createdEditors = true;

		Group optionalGroup = createGroup(inner,
				"[3] DBResource Capturing Options", 2);
		gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 2;
		optionalGroup.setLayoutData(gd);
		createLabel(optionalGroup, "Capture With: ");
		Composite captureComposite = new Composite(optionalGroup, SWT.NONE);
		captureComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		captureComposite.setLayout(new FillLayout());
		fCaptureWithDDLButton = new Button(captureComposite, SWT.CHECK);
		fCaptureWithDDLButton.setText("DDL");
		fCaptureWithDDLButton.setSelection(false);
		fCaptureWithViewButton = new Button(captureComposite, SWT.CHECK);
		fCaptureWithViewButton.setText("View");
		fCaptureWithViewButton.setSelection(false);
		fCaptureWithColumnInfoButton = new Button(captureComposite, SWT.CHECK);
		fCaptureWithColumnInfoButton.setText("Column/Field");
		fCaptureWithColumnInfoButton.setSelection(true);

		createLabel(optionalGroup, "Resource Filter: ");
		Composite radioComposite = new Composite(optionalGroup, SWT.NONE);
		radioComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		nothingBtn = new Button(radioComposite, SWT.RADIO);
		nothingBtn.setText(DBResourceCapturingFilter.NOTHING.name());
		nothingBtn.addSelectionListener(this);
		ignoreBtn = new Button(radioComposite, SWT.RADIO);
		ignoreBtn.setText(DBResourceCapturingFilter.IGNORE.name());
		ignoreBtn.addSelectionListener(this);
		matchBtn = new Button(radioComposite, SWT.RADIO);
		matchBtn.setText(DBResourceCapturingFilter.MATCHES.name());
		matchBtn.addSelectionListener(this);
		radioComposite.setLayout(new FillLayout());

		fCategoriesPatternLabel = createLabel(optionalGroup,
				"Catalog Pattern: "); //$NON-NLS-1$ 
		fCategoriesRegexText = new Text(optionalGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fCategoriesRegexText.setLayoutData(new GridData(
				GridData.FILL_HORIZONTAL));

		fFilePathPatternLabel = createLabel(optionalGroup, "FilePath Pattern: "); //$NON-NLS-1$ 
		fFilePathText = new Text(optionalGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fFilePathText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		fDBObjectPattern1Label = createLabel(optionalGroup,
				"DBObject Pattern: "); //$NON-NLS-1$ 
		fDBObjectRegex1Text = new Text(optionalGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fDBObjectRegex1Text
				.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		fDBObjectPattern2Label = createLabel(optionalGroup,
				"DBObject Pattern: "); //$NON-NLS-1$ 
		fDBObjectRegex2Text = new Text(optionalGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fDBObjectRegex2Text
				.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Group theOtherOptionalGroup = createGroup(inner,
				"[4] The Other Options", 2);
		createLabel(theOtherOptionalGroup, "After the Connecte Process: ");
		fCaptureResourceAfterTheConnectProcessButton = new Button(
				theOtherOptionalGroup, SWT.CHECK | SWT.BORDER);
		fCaptureResourceAfterTheConnectProcessButton
				.setText("DBResource automatic re-capture");
		fCaptureResourceAfterTheConnectProcessButton
				.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		fCaptureResourceAfterTheConnectProcessButton.setSelection(true);

		createLabel(theOtherOptionalGroup, "Serialize: ");
		fCheckSerializeButton = new Button(theOtherOptionalGroup, SWT.CHECK
				| SWT.BORDER);
		fCheckSerializeButton.setText("Save DBResource Objects");
		fCheckSerializeButton.setLayoutData(new GridData(
				GridData.FILL_HORIZONTAL));
		fUrlOrHostText.addKeyListener(this);
		fDisplayNameText.addKeyListener(this);

		resetCombo();
		init();

		return parent;
	}

	private Group createGroup(Composite parent, String title, int columns) {
		Group group = new Group(parent, SWT.NONE);
		group.setText(title);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.grabExcessHorizontalSpace = true;
		gd.grabExcessVerticalSpace = true;
		group.setLayoutData(gd);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = columns;
		group.setLayout(gridLayout);
		return group;
	}

	@Override
	protected Control createButtonBar(Composite parent) {
		Control ret = super.createButtonBar(parent);
		validate();
		return ret;
	}

	@Override
	protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
		Rectangle rect = super.getConstrainedShellBounds(preferredSize);
		if (rect.width > max) {
			rect.width = max;
		}
		return rect;
	}

	protected void okPressed() {
		try {
			if (fCombo.getSelectionIndex() == -1) {
				super.okPressed();
				return;
			}
			String dbName = StringUtil.EMPTY_STRING;
			String user = fUserText.getText();
			String pass = fPasswordText.getText();

			switch (DatabaseType.parse(fCombo.getText())) {
			case MONGO:
				dbName = fDatabaseText.getText();
				fConnectionProperties.setHost(fUrlOrHostText.getText());
				fConnectionProperties
						.setRecursiveSearchDepth(fRecursiveSearchSpin
								.getSelection());
				break;
			case DOMINO:
				fConnectionProperties.setHost(fUrlOrHostText.getText());
				for (int i = 0; i < fJarFiles.length; i++) {
					File f = new File(fJarFiles[i]);
					if (f.exists()
							&& f.getName().toLowerCase().indexOf("NCSO.jar") >= 0) {
						fConnectionProperties.setDriverFilePath(f
								.getAbsolutePath());
						break;
					}
				}
				break;
			case HSQL:
				fConnectionProperties.setURLString(fUrlOrHostText.getText());
				break;
			default:
				fConnectionProperties.setURLString(fUrlOrHostText.getText());
				fConnectionProperties
						.setDriverFilePath(fJarFiles[fJarFilesIndexes[fCombo
								.getSelectionIndex()]]);
			}

			fConnectionProperties
					.setCapturingFilter(DBResourceCapturingFilter.NOTHING);
			if (!nothingBtn.getSelection()) {
				if (ignoreBtn.getSelection()) {
					fConnectionProperties
							.setCapturingFilter(DBResourceCapturingFilter.IGNORE);
				} else {
					fConnectionProperties
							.setCapturingFilter(DBResourceCapturingFilter.MATCHES);
				}
				fConnectionProperties.addCalalogRegrex(fCategoriesRegexText
						.getText());
				fConnectionProperties
						.addFilePathRegrex(fFilePathText.getText());
				fConnectionProperties.addTitleRegrex(fDBObjectRegex1Text
						.getText());
				fConnectionProperties.addTitleRegrex(fDBObjectRegex2Text
						.getText());
			}
			fConnectionProperties.setCaptureWithViewInfo(fCaptureWithViewButton
					.getSelection());
			fConnectionProperties.setDriverName(fCombo.getText());
			fConnectionProperties.setDisplayString(fDisplayNameText.getText());
			fConnectionProperties.setAuthenticate(dbName, user, pass);
			fConnectionProperties.setSerializableDBRoot(fCheckSerializeButton
					.getSelection());
			fConnectionProperties
					.setCaptureResourceAfterTheConnectProcess(fCaptureResourceAfterTheConnectProcessButton
							.getSelection());
			fConnectionProperties
					.setCaptureWithColumnInfo(fCaptureWithColumnInfoButton
							.getSelection());
			fConnectionProperties.setCaptureWithDDL(fCaptureWithDDLButton
					.getSelection());

			System.out.println("saved::" + fConnectionProperties);

			super.okPressed();
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
	}

	public ConnectionProperties getConnectionProperties() {
		return fConnectionProperties;
	}

	void init() {
		initializing = true;
		System.out.println("load::" + fConnectionProperties);
		for (int j = 0; j < fCombo.getItemCount(); j++) {
			if (fCombo.getItem(j).equals(fConnectionProperties.getDriverName())) {
				fCombo.select(j);
				break;
			}
		}
		DBUserPass dup = fConnectionProperties.getAuthenticate();
		if (dup == null) {
			dup = new DBUserPass();
			fConnectionProperties.setAuthenticate(dup);
		}
		comboChange();
		if (fDatabaseText != null) {
			fDatabaseText.setText(dup.db);
		}
		fUserText.setText(dup.user);
		fPasswordText.setText(dup.pass);
		fDisplayNameText.setText(fConnectionProperties.getDisplayString());
		switch (DatabaseType.parse(fCombo.getText())) {
		case MONGO:
			fRecursiveSearchSpin.setSelection(fConnectionProperties
					.getRecursiveSearchDepth());
		case DOMINO:
			fUrlOrHostText.setText(fConnectionProperties.getHost());
			break;
		default:
			fUrlOrHostText.setText(fConnectionProperties.getURLString());
		}
		fCaptureWithColumnInfoButton.setSelection(fConnectionProperties
				.isCaptureWithViewInfo());
		fCaptureResourceAfterTheConnectProcessButton
				.setSelection(fConnectionProperties
						.isCaptureResourceAfterTheConnectProcess());
		fCaptureWithDDLButton.setSelection(fConnectionProperties
				.isCaptureWithDDL());
		fCaptureWithViewButton.setSelection(fConnectionProperties
				.isCaptureWithViewInfo());
		fCheckSerializeButton.setSelection(fConnectionProperties
				.isSerializableDBRoot());
		if (fConnectionProperties.getCalalogRegrex().size() > 0) {
			fCategoriesRegexText.setText((String) fConnectionProperties
					.getCalalogRegrex().toArray()[0]);
		}
		if (fConnectionProperties.getFilePathRegrex().size() > 0) {
			fFilePathText.setText((String) fConnectionProperties
					.getFilePathRegrex().toArray()[0]);
		}
		String[] titleRegex = fConnectionProperties.getTitleRegres().toArray(
				new String[0]);
		if (titleRegex.length > 0) {
			fDBObjectRegex1Text.setText(titleRegex[0]);
			if (titleRegex.length > 1) {
				fDBObjectRegex2Text.setText(titleRegex[1]);
			}
		}
		switch (fConnectionProperties.getCapturingFilter()) {
		case NOTHING:
			nothingBtn.setSelection(true);
			break;
		case IGNORE:
			ignoreBtn.setSelection(true);
			break;
		case MATCHES:
			matchBtn.setSelection(true);
			break;
		}
		if (!nothingBtn.getSelection() && !ignoreBtn.getSelection()
				&& !matchBtn.getSelection()) {
			nothingBtn.setSelection(true);
		}
		initializing = false;
		// fSysCombo.setText(fConnectionProperties.fInternalLogon);
		// fCheckDBMSButton.setSelection(fConnectionProperties.fDBMS);
	}

	private void resetCombo() {
		ClassManager clazz = new ClassManager();
		ArrayList list = new ArrayList();
		ArrayList list2 = new ArrayList();

		try {
			for (int i = 0; i < fJarFiles.length; i++) {
				File f = new File(fJarFiles[i]);
				if (f.exists()) {
					ArchiveManager arc = new ArchiveManager();
					String[] targets = arc.lookup2Strings(f, ".*[.]class"); //$NON-NLS-1$
					String[] targets2 = new String[targets.length];
					for (int j = 0; j < targets.length; j++) {
						targets2[j] = targets[j].replaceAll("[/¥¥¥¥]", ".")
								.replaceFirst("[.]class",
										StringUtil.EMPTY_STRING);
					}
					clazz.add_lib(f);
					List lis = clazz.getClassInstanceOf(Driver.class, targets2);
					list.addAll(lis);
					for (int jj = 0; jj < lis.size(); jj++) {
						list2.add(new Integer(i));
					}
				}
			}
			list.add(DatabaseType.HSQL.getDriverName());
			list.add(DatabaseType.ODBC.getDriverName());
			list.add(DatabaseType.MONGO.getDriverName());
			for (int i = 0; i < fJarFiles.length; i++) {
				File f = new File(fJarFiles[i]);
				if (f.exists()
						&& f.getName().toLowerCase().indexOf("ncso.jar") >= 0) {
					list.add(DatabaseType.DOMINO.getDriverName());
					break;
				}
			}

			list2.add(new Integer(0));

			fCombo.setItems((String[]) list.toArray(new String[list.size()]));
			comboChange();
			fJarFilesIndexes = new int[list2.size()];
			for (int i = 0; i < fJarFilesIndexes.length; i++) {
				fJarFilesIndexes[i] = ((Integer) list2.get(i)).intValue();
			}
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	private void comboChange() {

		resetSysCombo();
		resetTab();
		// if (fDisplayNameText.getText().trim().length() == 0) {
		// fDisplayNameText.setText("CON"
		// + PreferenceUtil.getDBInitialItems().length);
		// }
		fUrlOrHostText.traverse(SWT.TRAVERSE_TAB_PREVIOUS);
		fCombo.forceFocus();

	}

	private void checkAndSetOracleFilter() {
		if (DatabaseType.parse(fCombo.getText()) == DatabaseType.ORACLE) {
			if (!checked && !initializing && fUserText.getText().length() > 0) {
				if (MessageDialog.openQuestion(getShell(), "Question",
						"Just get self-schema?")) {
					matchBtn.setSelection(true);
					ignoreBtn.setSelection(false);
					nothingBtn.setSelection(false);
					fCategoriesRegexText.setText(fUserText.getText());
				}
				checked = true;
			}
		}
	}

	private void resetSysCombo() {
		if (DatabaseType.parse(fCombo.getText()) == DatabaseType.ORACLE) {
			if (fSysCombo != null) {
				fSysCombo.setEnabled(true);
			}
			if (fCheckDBMSButton != null) {
				fCheckDBMSButton.setVisible(true);
				fCheckDBMSButton.setSelection(true);
			}
			checkAndSetOracleFilter();
		} else {
			if (fSysCombo != null) {
				fSysCombo.setEnabled(false);
				fSysCombo.setText(StringUtil.EMPTY_STRING); //$NON-NLS-1$
			}
			if (fCheckDBMSButton != null) {
				fCheckDBMSButton.setVisible(false);
				fCheckDBMSButton.setSelection(false);
			}
		}

	}

	public String[] listFiles() {
		return null;
	}

	@Override
	public void keyPressed(KeyEvent arg0) {
		// TODO Auto-generated method stub

	}

	@Override
	public void keyReleased(KeyEvent arg0) {
		validate();
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
		// TODO Auto-generated method stub

	}

	@Override
	public void widgetSelected(SelectionEvent arg0) {
		if (arg0.widget == fCombo) {
			comboChange();
		} else {
			resetTab();
		}
	}
}