package hiro.yoshioka.sql.resource.xml;

import hiro.yoshioka.sql.resource.IDBResource;

import java.util.LinkedHashMap;
import java.util.Map;

public class DBResouceValue {
	DBResouceValue parent;

	String name;

	String comment;

	protected Map<String, DBResouceValue> children = new LinkedHashMap<String, DBResouceValue>();

	public DBResouceValue() {
	}

	public DBResouceValue(IDBResource resource) {
		name = resource.getName();
		comment = resource.getComment();
	}

	public Map<String, DBResouceValue> getChildren() {
		return children;
	}

	public void setChildren(Map<String, DBResouceValue> children) {
		this.children = children;
	}

	public String getComment() {
		return comment == null ? "" : comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getName() {
		return name == null ? "" : name;
	}

	public String getNameWithComment(int size) {
		String retVal;
		if (getComment().length() > 0) {
			retVal = getName() + " \"" + getComment() + "\"";
		} else {
			retVal = getName();
		}
		if (size <= 0) {
			return retVal;
		}
		if (retVal.length() > size) {
			return retVal.substring(0, size) + "..\"";
		}
		return retVal;
	}

	public String getNameWithComment() {
		if (getComment().length() > 0) {
			return getName() + " \"" + getComment() + "\"";
		}
		return getName();
	}

	public String getNameWithAsComment() {
		if (getComment().length() > 0) {
			return getName() + " As \"" + getComment() + "\"";
		}
		return getName();
	}

	public String getUName() {
		return getName().toUpperCase();
	}

	public void setName(String name) {
		this.name = name;
	}

	public DBResouceValue getParent() {
		return parent;
	}

	public void setParent(DBResouceValue parent) {
		this.parent = parent;
	}

}
