package hiro.yoshioka.sql.resource;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public interface IDBResource {
	int IDB_COLUMN = 0;

	int IDB_TABLE = 1;

	int IDB_VIEW = 2;

	int IDB_SYNONYM = 3;

	int IDB_PROCEDURE = 4;

	int IDB_SCHEMA = 5;

	IDBResource[] EMPTY_DBRESOURCE_ARRAY = new IDBResource[0];

	// ----------------------------------------------------------------------------
	// METHODS
	// ----------------------------------------------------------------------------
	public void setName(String name);

	public DBRoot getRoot();

	public void slimUp();

	public String getName();

	public String getNameWithComment();

	public String getNameWithComment(Charset charset, int maxColumnNameLen);

	public String getNameWithAsComment();

	public String getNameWithAsComment(Charset charset, int maxColumnNameLen);

	public String getUName();

	public boolean startsNameWith(String string);

	public List<IDBResource> startsWithResourceLists(String pattern);

	public boolean startsCommentWith(String string);

	public void setPropertyValue(String key, String value);

	public String getPropertyValue(String key);

	public Properties getProperties();

	public void setProperties(Properties p);

	public boolean isValid();

	public void setValid(boolean valid);

	public Object getImage();

	public String getComment();

	public String getUComment();

	public String getImageString();

	public void setComment(String comment);

	public IDBResource[] listArrayResources();

	public void setResources(Map<String, IDBResource> map);

	public IDBResource getResource(String key);

	public void putResource(String key, IDBResource child);

	public IDBResource getParent();

	public int childrenNum();

	public boolean contain(String pattern);

}