package hiro.yoshioka.sql.params;

import hiro.yoshioka.ast.sql.DatabaseType;
import hiro.yoshioka.sql.HSQL;
import hiro.yoshioka.sql.resource.DBRoot;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionSettingBean implements Serializable {
	private static final long serialVersionUID = 5792695663300493365L;
	private Set<String> jdbcDriverFilePathSet = new LinkedHashSet<String>();
	private Map<Long, ConnectionProperties> connectionMap = new LinkedHashMap<Long, ConnectionProperties>();

	protected Log log = LogFactory.getLog(getClass());

	public ConnectionSettingBean() {
		if (connectionMap.size() == 0) {
			ConnectionProperties hsql = new ConnectionProperties();
			hsql.setURLString(HSQL.getSuggestURL());
			hsql.setAuthenticate(null, "sa", null);
			hsql.setDisplayString("LocalHsqlServer");
			hsql.setSerializableDBRoot(true);
			hsql.setDriverName(DatabaseType.HSQL.getDriverName());
			connectionMap.put(hsql.getCreated(), hsql);
		}
	}

	public ConnectionProperties getConnectionPropertiesByDisplay(
			String displayString) {
		for (ConnectionProperties p : connectionMap.values()) {
			if (p.getDisplayString().equals(displayString)) {
				return p;
			}
		}
		log.warn(String.format("mapSize[%d] DisplayString[%s] return null",
				connectionMap.size(), displayString));
		return null;
	}

	public void addConnectionProperties(ConnectionProperties properties) {
		connectionMap.put(properties.getCreated(), properties);
	}

	public boolean changeConnectionProperties(
			Collection<ConnectionProperties> newProperties) throws IOException {
		boolean ret = false;
		connectionMap.clear();

		for (ConnectionProperties target : newProperties) {
			addConnectionProperties(target);
		}
		return ret;
	}

	public Collection<ConnectionProperties> getConnectionSet() {
		return connectionMap.values();
	}

	public String[] getDisplayStrings() {
		List<String> retList = new ArrayList<String>();
		for (ConnectionProperties p : getConnectionSet()) {
			retList.add(p.getDisplayString());
		}
		return retList.toArray(new String[retList.size()]);
	}

	public Set<String> getJdbcDriverFilePathSet() {
		return jdbcDriverFilePathSet;
	}

	@Override
	public String toString() {
		return "JAR_FILE[" + jdbcDriverFilePathSet + "] CON [" + connectionMap
				+ "]";
	}

	public Set<ConnectionProperties> getCloneConnectionSet() {
		System.out.println("conMap=" + connectionMap);
		Set<ConnectionProperties> ret = new LinkedHashSet<ConnectionProperties>();
		for (ConnectionProperties set : connectionMap.values()) {
			ConnectionProperties clone = (ConnectionProperties) set.clone();
			System.out.println("add:" + clone);
			ret.add(clone);
		}
		System.out.println("ret size=" + ret.size());
		return ret;
	}

	// --------------------------------------------------------------
	// DeSerialize
	// --------------------------------------------------------------
	private void readObject(ObjectInputStream in) throws IOException,
			ClassNotFoundException {
		in.defaultReadObject();
		log = LogFactory.getLog(getClass());
	}
}
