package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfSession extends AbsWolfDominoReflection {
	Method getPlatform;
	Method getNotesVersion;
	Method getDbDirectory;
	Method createDxlExporter;

	public WolfSession(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);
		System.out.println(getDominoClassName() + "constactor targetInstance="
				+ targetInstance);

		getNotesVersion = dominoClass.getMethod("getNotesVersion");
		getPlatform = dominoClass.getMethod("getPlatform");
		getDbDirectory = dominoClass.getMethod("getDbDirectory", String.class);
		createDxlExporter = dominoClass.getMethod("createDxlExporter");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.Session";
	}

	public String getNotesVersion() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getNotesVersion.invoke(targetInstance);
	}

	public String getPlatform() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getPlatform.invoke(targetInstance);
	}

	public WolfDBDirectory getDbDirectory(String path)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException {
		Object instance = getDbDirectory.invoke(targetInstance, path);
		if (instance == null) {
			return null;
		}
		return new WolfDBDirectory(classManager, instance);
	}

	public WolfDxlExporter createDxlExporter() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = createDxlExporter.invoke(targetInstance);
		if (instance == null) {
			return null;
		}
		return new WolfDxlExporter(classManager, instance);
	}

	@Override
	public String toString() {
		try {
			return String.format("WolfSession %s %s  ", getNotesVersion(),
					getPlatform());

		} catch (Exception e) {
			e.printStackTrace();
		}
		return "WolfSession";
	}
}
