package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sql.resource.notes.ItemType;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Vector;

public class WolfForm extends AbsWolfDominoReflection {
	Method getName;
	Method getReaders;
	Method getAliases;
	Method getFields;
	Method getFieldType;
	Method recycle;

	public WolfForm(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);

		getName = dominoClass.getMethod("getName");
		getReaders = dominoClass.getMethod("getReaders");
		getAliases = dominoClass.getMethod("getAliases");
		getFields = dominoClass.getMethod("getFields");
		getFieldType = dominoClass.getMethod("getFieldType", String.class);

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.Form";
	}

	public String getName() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getName.invoke(targetInstance);
	}

	public Vector<String> getReaders() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Vector<String>) getReaders.invoke(targetInstance);
	}

	public Vector<String> getAliases() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Vector<String>) getAliases.invoke(targetInstance);
	}

	public Vector<String> getFields() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Vector<String>) getFields.invoke(targetInstance);
	}

	public ItemType getFieldType(String fieldName)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		return ItemType.parse((Integer) getFieldType.invoke(targetInstance,
				fieldName));
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		try {
			buf.append(String.format("WolfForm %s%n", getName()));

		} catch (Exception e) {
			e.printStackTrace();
		}
		return buf.toString();
	}
}
