package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.sun.xml.internal.messaging.saaj.packaging.mime.MessagingException;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.MimeUtility;

public class Picture extends PardefElement implements Serializable {
	private static final long serialVersionUID = 8396435261631891923L;
	String height, width, scaledheight, scaledwidth, format;

	public Picture(Node atts) {
		NamedNodeMap names = atts.getAttributes();
		height = Form.getAttrValueString(names, "height");
		width = Form.getAttrValueString(names, "width");
		scaledheight = Form.getAttrValueString(names, "scaledheight");
		scaledwidth = Form.getAttrValueString(names, "scaledwidth");

		
		Node f = atts.getFirstChild();
		if (f != null) {
			setFormat(f.getNodeName());
			setCharactor(f.getTextContent());
//			try {
//				decode();
//			} catch (Exception e) {
//				// TODO Auto-generated catch block
//				e.printStackTrace();
//			}
		}
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public String getFormat() {
		return format;
	}

	private void decode() throws Exception {
		if (this.charactors.length() == 0) {
			return;
		}
		System.out.println(this.charactors);
		FileOutputStream fo = new FileOutputStream(new File("c:/tmp/p/"
				+ UUID.randomUUID().toString() + "." + format));
		InputStream in = MimeUtility.decode(new ByteArrayInputStream(
				this.charactors.getBytes("UTF-8")), "base64");

		int len;
		byte[] buf = new byte[1024];

		while ((len = in.read(buf)) != -1) {
			fo.write(buf, 0, len);
		}

		in.close();
		fo.flush();
		fo.close();

	}

	public String toHtmlString(ResultSetDataHolder rdh, int row) {
		return "pircureeeeeeeeeeeee";
	}

	@Override
	public void setCharactor(String charctors) {
		super.setCharactor(charctors);
		try {
			// decode();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
