package hiro.yoshioka.sql.notes;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.notes.reflect.WolfDBDirectory;
import hiro.yoshioka.sql.notes.reflect.WolfDatabase;
import hiro.yoshioka.sql.notes.reflect.WolfSession;
import hiro.yoshioka.sql.notes.reflect.WolfView;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;

import java.lang.reflect.Method;

public abstract class AbsNotesRunner {
	public static String UniversalID = "UniversalID";
	String server;
	String userid;
	String password;
	boolean isFullAccess;
	private DBRoot root;
	SQLOperationType operation;

	/* Notes Class Definitions */

	// lotus.domino.Session
	WolfSession wolf_session;

	// lotus.domino.NotesThread
	Class notesThreadClass;
	Method notesThread_sinitThreadMethod;
	// lotus.domino.NotesFactory
	Class notesFactory;
	Method notesFactory_createSessionWithFullAccessMethod;
	Method notesFactory_createSessionMethod;

	// lotus.domino.RichTextItem
	Class richTextItemClass;

	ClassManager classManager;
	private boolean initializedFlg;

	public AbsNotesRunner(ClassManager manager, String server, String userid,
			String password) {
		this.classManager = manager;
		this.server = server;
		this.userid = userid;
		this.password = password;
		this.isFullAccess = false;
	}

	public AbsNotesRunner() {
		this.isFullAccess = true;
	}

	public void initClass() throws Exception {

		//
		notesThreadClass = classManager
				.getClassForName("lotus.domino.NotesThread");
		notesThread_sinitThreadMethod = notesThreadClass
				.getMethod("sinitThread");
		notesFactory = classManager
				.getClassForName("lotus.domino.NotesFactory");
		notesFactory_createSessionWithFullAccessMethod = notesFactory
				.getMethod("createSessionWithFullAccess");
		notesFactory_createSessionMethod = notesFactory.getMethod(
				"createSession", String.class, String.class, String.class);

		initializedFlg = true;
	}

	public AbsNotesRunner(ClassManager manager, ConnectionProperties properties) {
		this(manager, properties.getHost(), properties.getAuthenticate().user,
				properties.getAuthenticate().pass);
	}

	public static void main(java.lang.String[] args) {
		// NotesRunner sjd = new NotesRunner("localhost", "Hirotaka Yoshioka",
		// "password");
		// Thread nt = new Thread((Runnable) sjd);
		// nt.start();
	}

	public DBRoot getRoot() {
		return root;
	}

	public String getServer() {
		if (StringUtil.isEmpty(server)) {
			return "localhost";
		}
		return server;
	}

	public Object createSession() throws Exception {
		Object sessionInstance = null;
		if (isFullAccess) {
			System.out.println("FullAccess Administration mode");
			notesThread_sinitThreadMethod.invoke(null);
			sessionInstance = notesFactory_createSessionWithFullAccessMethod
					.invoke(null);
		} else {
			System.out.println("innnn notesFactory_createSessionMethod="
					+ notesFactory_createSessionMethod);
			sessionInstance = notesFactory_createSessionMethod.invoke(null,
					getServer(), userid, password);
		}
		wolf_session = new WolfSession(classManager, sessionInstance);
		return this.wolf_session;
	}

	protected void test() throws Exception {
		if (!initializedFlg) {
			initClass();
		}
	}

	public void setOperation(SQLOperationType operation) {
		this.operation = operation;
	}

	protected WolfDatabase getDatabaseByTable(IDBTable table) throws Exception {
		WolfDBDirectory dir = wolf_session.getDbDirectory(null);
		WolfDatabase database = dir
				.getFirstDatabase(WolfDBDirectory.dbDirectory_database_type);

		while (database != null) {
			if (table.getParent().getName().equals(database.getTitle())) {
				return database;
			}
			database = dir.getNextDatabase();
		}
		return null;
	}

	protected WolfView getView(IDBTable table) throws Exception {

		WolfDBDirectory dir = wolf_session.getDbDirectory(null);
		WolfDatabase database = dir
				.getFirstDatabase(WolfDBDirectory.dbDirectory_database_type);

		String tableName = table.getProperties().getProperty("database");
		while (database != null) {
			if (tableName.equals(database.getTitle())) {
				if (!database.isOpen()) {
					database.open();
				}
				return database.getView(table.getName());
			}
			database = dir.getNextDatabase();
		}

		return null;
	}
}
