package hiro.yoshioka.sql.mongo;

import hiro.yoshioka.ast.sql.DatabaseType;
import hiro.yoshioka.ast.sql.mongo.util.WolfMongoParserUtil;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh.ResultSetMetaCopy;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh2.ReflectionPreparedStatement;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.LineListener;
import hiro.yoshioka.sql.SqlBasicListener;
import hiro.yoshioka.sql.SqlTransactionListener;
import hiro.yoshioka.sql.engine.MongoTransactionRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.ResourceCaptionRequest;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBSequence;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.handlers.ResultSetHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;

public class MongoSQL implements ITransactionSQL {
	protected Log fLogger = LogFactory.getLog(getClass());
	boolean needsAuth;
	Mongo mongo;
	String host;
	MongoOptions options;
	Map<String, DBUserPass> dbPassWordMap = new LinkedHashMap<String, DBUserPass>();
	Map<String, DB> dbMap = new LinkedHashMap<String, DB>();
	DB currentDB;
	private ConnectionProperties _info;
	private static int SAMPLING_COUNT = 10;

	@SuppressWarnings("unused")
	private static final List<String> IMMUTABLE_LIST = Collections
			.unmodifiableList(new ArrayList<String>());
	private static final String ADMIN = "admin";
	private boolean capturing;
	DBRoot _root;
	Version version;

	static class Version {
		static final Pattern p = Pattern.compile("(\\d+)\\.(\\d+)(\\.(\\d+))?");
		int majarVersion;
		int minorVersion;
		int minorVersion2;

		public Version(String versionString) {
			Matcher m = p.matcher(versionString);
			if (m.find()) {
				majarVersion = Integer.parseInt(m.group(1));
				minorVersion = Integer.parseInt(m.group(2));
				if (m.group(4) != null) {
					minorVersion2 = Integer.parseInt(m.group(4));
				}
				System.err.println("  pattern [" + m.group(0) + "]");
			} else {
				System.err.println("whats pattern?[" + versionString + "]");
			}
		}

		public boolean isHigherEqualVersion(int majarVersion, int minorVersion,
				int minorVersion2) {
			if (this.majarVersion < majarVersion) {
				return false;
			}
			if (this.minorVersion < minorVersion) {
				return false;
			}
			if (this.minorVersion2 < minorVersion2) {
				return false;
			}
			return true;
		}

	}

	public MongoSQL() {
	}

	public DatabaseType getDatabaseType() {
		return DatabaseType.MONGO;
	}

	protected DBRoot getMetaData(ResourceCaptionRequest request) {
		IDBSchema schema = null;
		try {
			capturing = true;

			if (request.canceld()) {
				return null;
			}
			if (!request.grabOnlyTableResource) {
				_root = new DBRoot("Mongo");
				_root.setPropertyValue("DatabaseProductName", "Mongo");
				fLogger.info("new DBRoot");

				List<String> list = getDatabaseNames();
				String currentName = ADMIN;
				if (currentDB != null) {
					currentName = currentDB.getName();
				}
				if (list.size() == 0) {
					schema = new DBSchema(_root);
					schema.setName(currentDB.getName());
					_root.putResource(schema.getName(), schema);
					_root.setDefaultSchema(schema);
					_root.setCurrentSchema(schema);
					System.out
							.println("dumpAllCollectionNames => No collection.");
				} else {
					for (String name : list) {
						schema = new DBSchema(_root);
						schema.setName(name);
						_root.putResource(schema.getName(), schema);
						if (currentName.equalsIgnoreCase(name)) {
							_root.setDefaultSchema(schema);
							_root.setCurrentSchema(schema);
						}

						DB db = getDBWithAuth(name);

						if (ADMIN.equals(name)) {
							System.out
									.println("2222222222222:::::hasAdminAuthenticate()="
											+ hasAdminAuthenticate());
							if (!hasAdminAuthenticate()) {
								continue;
							}
						}
						Set<String> colls = db.getCollectionNames();
						for (String s : colls) {
							DBTable table = new DBTable(schema);
							table.setName(s);
							table.setTableType("TABLE");
							schema.putTable(table);
							if (request.getConnectionProperties()
									.isCaptureWithColumnInfo()) {

								createColumnDefs(table, request
										.getConnectionProperties()
										.getRecursiveSearchDepth());

							}
							for (DBObject dobj : db.getCollection(s)
									.getIndexInfo()) {
								System.out.println("index???" + dobj);

							}
						}
					}
				}
			} else {
				IDBTable table = (IDBTable) request.selectionResource;
				table.removeAllColumns();
				createColumnDefs(table, request.getConnectionProperties()
						.getRecursiveSearchDepth());
			}
			System.out.println("doneeeeeeeeeeeeeeee");
		} catch (Throwable e) {
			e.printStackTrace();
			fLogger.error(e);
			return null;
		} finally {
			capturing = false;
		}
		return _root;
	}

	private void createColumnDefs(IDBTable table, int recursiveSearchDepth) {

		DB db = getDBWithAuth(table.getParent().getName());
		DBCollection collection = db.getCollection(table.getName());
		DBCursor cur = collection.find();
		cur.limit(SAMPLING_COUNT);
		Map<IDBColumn, TmpType> typeMap = new java.util.HashMap<IDBColumn, MongoSQL.TmpType>();
		while (cur.hasNext()) {
			DBObject dobj = cur.next();
			recurseCreateDBColumn(table, dobj, 0, recursiveSearchDepth, typeMap);
		}
		for (IDBColumn col : typeMap.keySet()) {
			DBColumn column = (DBColumn) col;
			TmpType tmp = typeMap.get(column);
			column.setDataTypeString(tmp.getDataTypeString());
			column.setDataType(tmp.getDataType());
			column.setSize(tmp.getSize());
		}
		typeMap.clear();
		typeMap = null;
	}

	private void recurseCreateDBColumn(IDBResource res, DBObject dobj,
			int depth, int maxDepth, Map<IDBColumn, TmpType> typeMap) {
		for (String ss : dobj.keySet()) {
			DBColumn column = null;

			IDBResource child = res.getResource(ss);
			System.out.println("ss=" + ss + "//" + child);
			if (child == null || !(child instanceof IDBColumn)) {
				if (res instanceof IDBTable) {
					column = new DBColumn((IDBTable) res);
				} else if (res instanceof IDBColumn) {
					column = new DBColumn((IDBColumn) res);
				}
				column.setName(ss);

				if ("_id".equals(ss) && depth == 0) {
					column.setPKey(true);
					column.setDataType(Types.CHAR);
					column.setDataTypeString("ObjectId");
					column.setSize(24);
				} else {
					Object o = dobj.get(ss);
					TmpType t = typeMap.get(column);
					if (t == null) {
						t = new TmpType(column.getName());
						typeMap.put(column, t);
					}
					t.add(o);
					if (o != null && o instanceof BasicDBObject) {
						BasicDBObject bobj = (BasicDBObject) o;
						column.setDataType(Types.STRUCT);
						if (depth < maxDepth) {
							recurseCreateDBColumn(column, bobj, depth + 1,
									maxDepth, typeMap);
						}
					}
				}
				res.putResource(ss, column);
			} else {
				if ("_id".equals(ss) && depth == 0) {
					continue;
				}
				column = (DBColumn) child;
				Object o = dobj.get(ss);

				TmpType t = typeMap.get(column);
				if (t == null) {
					t = new TmpType(column.getName());
					typeMap.put(column, t);
				}
				t.add(o);

				if (o != null && o instanceof BasicDBObject) {
					BasicDBObject bobj = (BasicDBObject) o;
					column.setDataType(Types.STRUCT);
					if (depth < maxDepth) {
						recurseCreateDBColumn(column, bobj, depth + 1,
								maxDepth, typeMap);
					}
				}
			}
		}
	}

	class TmpType {
		String name;
		int maxLength;
		Map<Integer, Integer> lengthCountMap = new TreeMap<Integer, Integer>();
		Map<Class, Integer> classCountMap = new java.util.HashMap<Class, Integer>();

		public TmpType(String name) {
			this.name = name;
		}

		public int getSize() {
			return maxLength;
		}

		public String getDataTypeString() {
			String ret = StringUtil.EMPTY_STRING;
			for (Class clazz : classCountMap.keySet()) {
				if (clazz.equals(BasicDBObject.class)) {
					return clazz.getSimpleName();

				} else {
					ret = clazz.getSimpleName();
				}
			}
			return ret;
		}

		public int getDataType() {
			int beforeType = Types.NULL;
			int type = Types.NULL;
			int maxCount = 0;

			for (Class clazz : classCountMap.keySet()) {

				if (clazz.equals(BasicDBObject.class)) {
					type = Types.STRUCT;
				} else if (clazz.equals(Date.class)
						|| Date.class.isAssignableFrom(clazz)) {
					type = Types.DATE;
				} else if (clazz.equals(Number.class)
						|| Number.class.isAssignableFrom(clazz)) {
					if (clazz.equals(Integer.class)) {
						type = Types.INTEGER;
					} else if (clazz.equals(Double.class)) {
						type = Types.DOUBLE;
					} else if (clazz.equals(Float.class)) {
						type = Types.FLOAT;
					} else if (clazz.equals(BigInteger.class)) {
						type = Types.BIGINT;
					} else if (clazz.equals(Short.class)) {
						type = Types.SMALLINT;
					} else if (clazz.equals(Byte.class)) {
						type = Types.TINYINT;
					} else {
						type = Types.NUMERIC;
					}
				} else {
					type = Types.VARCHAR;
					if (maxLength > 0 && lengthCountMap.size() == 1) {
						type = Types.CHAR;
					}
				}
			}
			return type;
		}

		public void add(Object o) {
			if (o == null) {
				Integer c = classCountMap.get(null);
				if (c == null) {
					c = new Integer(1);
					classCountMap.put(null, c);
				} else {
					classCountMap.put(null, c + 1);
				}
			} else {
				Integer c = classCountMap.get(o.getClass());
				if (c == null) {
					c = new Integer(1);
					classCountMap.put(o.getClass(), c);
				} else {
					classCountMap.put(o.getClass(), c + 1);
				}
				int len = o.toString().length();
				if (maxLength < len) {
					maxLength = len;
				}
			}
		}
	}

	public void addAuthenticate(String dbName, String user, String pass) {
		addAuthenticate(new DBUserPass(dbName, user, pass));
	}

	public void addAuthenticate(DBUserPass dup) {
		if (dup == null) {
			fLogger.warn("Nothing authenticate informain...");
		} else {
			dbPassWordMap.put(dup.db, dup);
			DB db = dbMap.get(dup.db);
			if (db != null) {
				db.authenticate(dup.user, dup.pass.toCharArray());
			}

		}
	}

	public List<String> getDatabaseNames() {
		try {
			return mongo.getDatabaseNames();
		} catch (MongoException e) {
			System.out.println("code=" + e.getCode());
			System.out.println("mes=" + e.getLocalizedMessage());
			if (e.getCode() == -3) {
				List<String> retList = new ArrayList<String>();
				for (String dbname : dbPassWordMap.keySet()) {
					DB ret = mongo.getDB(dbname);
					if (ret != null) {
						retList.add(dbname);
					}
				}
				return retList;
			} else {
				e.printStackTrace();
			}
		}
		return IMMUTABLE_LIST;
	}

	private boolean hasAdminAuthenticate() {
		System.out.println(dbPassWordMap);
		return dbPassWordMap.containsKey(ADMIN);
	}

	public void dumpAllCollectionNames() {
		List<String> list = getDatabaseNames();
		if (list.size() == 0) {
			System.out.println("dumpAllCollectionNames => No collection.");
		} else {
			for (String name : list) {
				System.out.println("name=" + name);
				if (ADMIN.equals(name)) {
					System.out.println("hasAdminAuthenticate()="
							+ hasAdminAuthenticate());
					if (!hasAdminAuthenticate()) {
						continue;
					}
				}
				DB db = mongo.getDB(name);

				System.out.println(db);
				Set<String> colls = db.getCollectionNames();

				for (String s : colls) {
					System.out.println("  " + s);
				}
			}
		}
	}

	public void addUser(String dbname, String username, String passwd) {
		mongo.getDB(dbname).addUser(username, passwd.toCharArray());
	}

	public ResultSetDataHolder2 curso2Rdh(DBCursor cur) {

		Set<String> allKeySets = new LinkedHashSet<String>();
		List<DBObject> curList = new ArrayList<DBObject>();
		while (cur.hasNext()) {
			DBObject obj = cur.next();
			curList.add(obj);
			allKeySets.addAll(obj.keySet());
		}
		ResultSetDataHolder2 rdh = new ResultSetDataHolder2(
				allKeySets.toArray(new String[allKeySets.size()]), null);
		for (DBObject obj : curList) {
			StringRecordData[] record = new StringRecordData[allKeySets.size()];
			int iCol = 0;
			for (String key : allKeySets) {
				Object o = obj.get(key);
				if (o != null) {
					System.out.println(o.getClass());
				}
				if (obj.containsField(key)) {
					record[iCol] = new StringRecordData(StringUtil.nvl(obj
							.get(key)));
				} else {
					record[iCol] = new StringRecordData(null);
				}
				iCol++;
			}
			rdh.addRow(record);
		}
		return rdh;
	}

	private void nullClear() {
		if (mongo != null) {
			mongo.close();
		}
		mongo = null;
		currentDB = null;
		dbMap.clear();
	}

	public void init(ConnectionProperties connectionProperties)
			throws SQLException {
		fLogger.info("host:" + host + " options:" + options);
		nullClear();
		this.host = connectionProperties.getHost();
		this.options = connectionProperties.getMongoOptions();
		try {
			if (StringUtil.isEmpty(host)) {
				mongo = new Mongo();
			} else {
				if (options == null) {
					mongo = new Mongo(host);
				} else {
					mongo = new Mongo(host, options);
				}
			}
			if (mongo != null) {
				getDBWithAuth(ADMIN);
				this.version = new Version(mongo.getVersion());
			}
			connectionProperties.setConnected(true);
		} catch (UnknownHostException e) {
			throw new SQLException(e.getMessage(), e);
		} catch (MongoInternalException e) {
			throw new SQLException(e.getMessage(), e);
		} catch (MongoException e) {
			throw new SQLException(e.getMessage(), e);
		}
	}

	private DB getDBWithAuth(String name) {
		DB db = dbMap.get(name);
		if (db == null) {
			db = mongo.getDB(name);
			dbMap.put(name, db);
			DBUserPass auth = dbPassWordMap.get(name);
			if (auth != null) {
				db.authenticate(auth.user, auth.pass.toCharArray());
			}
		}
		return db;
	}

	public DB setCurrentDB(String currentDBName) {
		currentDB = getDBWithAuth(currentDBName);
		System.out.println("========================");
		return currentDB;
	}

	@Override
	public void addConnectionListner(SqlBasicListener listner) {
		// TODO Auto-generated method stub

	}

	@Override
	public void addTracsactionListner(SqlTransactionListener listener) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean canDoOperation(SQLOperationType operation) {

		switch (operation) {
		case RENAME_FIELD:
			return this.version.isHigherEqualVersion(1, 7, 2);
		case CONNECT:
			return (mongo == null);
		case CLOSE:
		case RESOURCE_CAPTION:
		case PREPARED_EXECUTE:
		case PREPARED_EXECUTE_QUERY:
		case SELECT_ALL:
			return (mongo != null);
		default:
			System.out.println("what's this operation ? " + operation);
			break;
		}

		return false;

	}

	@Override
	public DBRoot getCopyRoot() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ResultSetDataHolder getProcedures(String name) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public DBRoot getRoot() {
		return _root;
	}

	@Override
	public ResultSetDataHolder getSchemas() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ResultSetDataHolder getTables(String text) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isCapturing() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean load(File f) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void removeConnetionListener(SqlBasicListener listner) {
		// TODO Auto-generated method stub

	}

	@Override
	public void removeTracsactionListner(SqlTransactionListener listener) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean save(File f) throws IOException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setBuildDate(String format) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setBuildTimeStamp(String format) {
		// TODO Auto-generated method stub

	}

	@Override
	public void setRoot(DBRoot root) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean doOperation(SQLOperationType operation, Request request)
			throws SQLException {

		TransactionRequest treq = null;
		if (request instanceof TransactionRequest) {
			treq = (TransactionRequest) request;
		}
		MongoTransactionRequest mreq = null;
		if (request instanceof MongoTransactionRequest) {
			mreq = (MongoTransactionRequest) request;
		}
		boolean retCode = true;
		switch (operation) {
		case CONNECT:
			connect(request.getConnectionProperties());
			break;
		case CLOSE:
			close();
			break;
		case COUNT:
			treq.setResultCount(count(treq.getIDBTable()));
			break;
		case COUNTS:
			treq.setRDH(counts(treq.getIDBTables()));
			break;
		case RESOURCE_CAPTION:
			getMetaData((ResourceCaptionRequest) request);
			break;
		case EXPLAIN_PLAN:
			break;
		case SELECT_SESSION:
			break;
		case SELECT_LOCK:
			break;
		case SELECT_ALL:
			treq.setRDH(getAllData2(treq.getIDBTable()));
			break;
		case PREPARED_EXECUTE_QUERY:
			treq.setRDH(find(treq.getIDBTable(), mreq.getQueryUsesedToSearch(),
					mreq.getReturnFields(), mreq.getOrderBy(), 0,
					(int) treq.getMaxRownum()));
			break;
		case CREATE_TRIG_FNC_PROC:
			break;
		case WORST_SQL:
			break;
		case CHECK_VALIDATION:
			break;
		case PREPARED_EXECUTE:
			WriteResult result = null;
			result = preparedExecute(mreq);
			System.out.println("executed preparedExecute");
			retCode = StringUtil.isEmpty(result.getError());
			break;
		default:
			System.out.println("what's this operation ? " + operation);
			break;
		}

		return retCode;

	}

	@Override
	public boolean cansel() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean commit() {
		// TODO Auto-generated method stub
		return false;
	}

	public long count(IDBTable table) throws SQLException {
		DB targetDB = getDBByIDBTable(table);
		if (!targetDB.collectionExists(table.getName())) {
			System.err.println("no collection!!!!!!!!!!!");
		}

		return targetDB.getCollection(table.getName()).count();
	}

	@Override
	public int count(String sqlStatement) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	public ResultSetDataHolder2 counts(IDBTable[] tables) throws SQLException {
		ResultSetDataHolder2 rdh = new ResultSetDataHolder2(
				new String[] { "CNT" }, null);
		for (IDBTable table : tables) {
			rdh.addRow(new String[] { String.valueOf(count(table)) });
		}

		return rdh;
	}

	@Override
	public ResultSetDataHolder2 counts(String[] sqlStatements)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean execute(String sqlStatement) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean execute(String sqlStatement, String[] args)
			throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public ResultSetDataHolder2 executePrepare(String sqlStatement,
			Object[] arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ResultSetDataHolder2 executePrepareQuery(String sql_statement,
			String[] binds) throws SQLException {
		WolfMongoParserUtil util = new WolfMongoParserUtil(sql_statement);
		if (util.parse()) {
			return find(util.getFirstTable(), util.getQueryUsesedToSearch(),
					util.getReturnFields(), util.getOrderBy(), 0, 100);
		}
		return null;
	}

	public ResultSetDataHolder2 renameField(IDBColumn before, String afterName)
			throws SQLException {
		IDBTable table = (IDBTable) before.getParent();
		DB targetDB = getDBByIDBTable(table);
		if (!targetDB.collectionExists(table.getName())) {
			fLogger.fatal("no collection!!!!!!!!!!!");
		}
		DBCollection collection = targetDB.getCollection(table.getName());

		System.out.println("can?"
				+ canDoOperation(SQLOperationType.RENAME_FIELD));
		BasicDBObject updObj0 = (BasicDBObject) JSON.parse(String.format(
				"{ \"$rename\":{\"%s\" : \"%s\"} }", before.getName(),
				afterName));

		System.out.println("updObj0:" + updObj0);
		long time = System.currentTimeMillis();
		WriteResult result = collection.update(new BasicDBObject(), updObj0,
				false, true);

		return WriteResult2RSH(System.currentTimeMillis() - time, result);

		// DBCursor cur = collection.find();
		// boolean ret = false;
		//
		// while (cur.hasNext()) {
		// DBObject o = cur.next();
		// if (o.containsField(before.getName())) {
		// System.out.println("contain " + before.getName());
		// o.put(afterName, o.get(before.getName()));
		// o.removeField(before.getName());
		// System.out.println("removed ");
		// ret = true;
		// } else {
		// System.out.println("no contain");
		// }
		// targetDB.
		// }

	}

	public ResultSetDataHolder2 find(IDBTable table,
			DBObject queryUsesedToSearch, DBObject returnFields,
			DBObject orderBy, int numToSkip, int batchSize) throws SQLException {
		DB targetDB = getDBByIDBTable(table);
		if (!targetDB.collectionExists(table.getName())) {
			System.err.println("no collection!!!!!!!!!!!");
		}
		DBCollection collection = targetDB.getCollection(table.getName());
		DBCursor cur = null;
		if (orderBy == null || orderBy.keySet().size() == 0) {
			cur = collection.find(queryUsesedToSearch, returnFields, numToSkip,
					batchSize);
		} else {
			cur = collection.find(queryUsesedToSearch, returnFields, numToSkip,
					batchSize).sort(orderBy);
		}

		return curso2Rdh(cur);
	}

	@Override
	public ResultSet getAllData(IDBTable table) throws SQLException {
		return null;
	}

	public ResultSetDataHolder2 getAllData2(IDBTable table) throws SQLException {
		DB targetDB = getDBByIDBTable(table);
		if (!targetDB.collectionExists(table.getName())) {
			System.err.println("no collection!!!!!!!!!!!");
		}
		DBCollection collection = currentDB.getCollection(table.getName());
		return curso2Rdh(collection.find());
	}

	private DB getDBByIDBTable(IDBTable table) {
		IDBResource schema = table.getParent();
		DB targetDB = currentDB;
		if (schema != null) {
			if (targetDB == null
					|| !schema.getName().equalsIgnoreCase(targetDB.getName())) {
				targetDB = getDBWithAuth(schema.getName());
			}
		}

		return targetDB;
	}

	@Override
	public ResultSetMetaCopy getTableMetaCopy(String name) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ResultSetMetaCopy getTableMetaCopy(String name, String[] strings) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean rollback() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean saveCsv(String sqlStatement, ResultSetHandler handler,
			CsvWriter writer) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setMaxRowNum(int max) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean trunsactionTime() {
		// TODO Auto-generated method stub
		return false;
	}

	private ResultSetDataHolder2 WriteResult2RSH(long time, WriteResult result) {
		if (StringUtil.isEmpty(result.getError())) {
			ResultSetDataHolder2 rdh = new ResultSetDataHolder2(new String[] {
					"result", "N", "lazy" }, null);
			rdh.addRow(new String[] { "success", String.valueOf(result.getN()),
					String.valueOf(result.isLazy()) });
			rdh.setWrapTime(time);
			return rdh;
		} else {
			ResultSetDataHolder2 rdh = new ResultSetDataHolder2(new String[] {
					"result", "Error", "N", "lazy" }, null);
			rdh.addRow(new String[] { "failure", result.getError(),
					String.valueOf(result.getN()),
					String.valueOf(result.isLazy()) });
			rdh.setWrapTime(time);
			return rdh;
		}
	}

	public WriteResult preparedExecute(MongoTransactionRequest mreq) {
		DB targetDB = getDBByIDBTable(mreq.getIDBTable());
		if (!targetDB.collectionExists(mreq.getIDBTable().getName())) {
			System.err.println("no collection!!!!!!!!!!!");
		}
		DBCollection collection = targetDB.getCollection(mreq.getIDBTable()
				.getName());
		WriteResult result = null;
		long time = System.currentTimeMillis();
		switch (mreq.getSqlType()) {
		case Insert:
			result = collection.insert(mreq.getInsertObject());
			break;
		case Delete:
			result = collection.remove(mreq.getRemoveMustMatch());
			break;
		case Update:
			if (mreq.isUpsert() == null) {
				result = collection.update(mreq.getQueryUsesedToSearch(),
						mreq.getUpdateObject());
			} else {
				result = collection
						.update(mreq.getQueryUsesedToSearch(),
								mreq.getUpdateObject(), mreq.isUpsert(),
								mreq.isMulti());
			}
			break;
		}
		mreq.setRDH(WriteResult2RSH((System.currentTimeMillis() - time), result));

		return result;
	}

	@Override
	public boolean execute(ReflectionPreparedStatement ref) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void executePrepareQueryByLine(String sql_statement,
			LineListener listner) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean connect(ConnectionProperties properties) throws SQLException {
		_info = properties;
		addAuthenticate(properties.getAdminAuthenticate());
		init(properties);
		return true;
	}

	@Override
	public boolean close() throws SQLException {
		_info.setConnected(false);
		_info = null;
		nullClear();
		return true;
	}

	@Override
	public boolean migration(ITransactionSQL osql, IDBSchema original,
			boolean drop, boolean cascade) throws SQLException {
		System.out.println("maigrationnnnnnnn");
		return false;
	}

	@Override
	public boolean migration(ITransactionSQL osql, DBCrossRefference original,
			boolean drop, boolean cascade) throws SQLException {
		System.out.println("maigrationnnnnnnn");
		return false;
	}

	@Override
	public boolean migration(ITransactionSQL osql, IDBTable original,
			boolean drop, boolean cascade, boolean noSchema)
			throws SQLException {
		System.out.println("maigrationnnnnnnn");
		return false;
	}

	@Override
	public boolean migration(ITransactionSQL osql, IDBSequence original,
			boolean drop, boolean cascade, boolean noSchema)
			throws SQLException {
		System.out.println("maigrationnnnnnnn");
		return false;
	}

}
