package hiro.yoshioka.sql.engine;

import hiro.yoshioka.ast.sql.mongo.MongoSqlType;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBTable;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;

public class MongoTransactionRequest extends TransactionRequest {
	public MongoTransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, IDBTable table) {
		super(operation, properties, table);
	}

	public MongoTransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, String sql_statemente,
			Object[] binds, IDBTable table) {
		super(operation, properties, sql_statemente, binds, table);
	}

	private MongoSqlType sqlType;
	private Boolean upsert, multi;
	private BasicDBObject insertObject;
	private BasicDBObject updateObject;
	private BasicDBObject removeMustMatch;
	DBObject returnFields;
	DBObject queryUsesedToSearch;
	DBObject orderBy;

	public Boolean isUpsert() {
		return upsert;
	}

	public void setUpsert(Boolean upsert) {
		this.upsert = upsert;
	}

	public Boolean isMulti() {
		return multi;
	}

	public void setMulti(Boolean multi) {
		this.multi = multi;
	}

	public BasicDBObject getInsertObject() {
		return insertObject;
	}

	public void setInsertObject(BasicDBObject insertObject) {
		this.insertObject = insertObject;
	}

	public BasicDBObject getUpdateObject() {
		return updateObject;
	}

	public void setUpdateObject(BasicDBObject updateObject) {
		this.updateObject = updateObject;
	}

	public BasicDBObject getRemoveMustMatch() {
		return removeMustMatch;
	}

	public void setRemoveMustMatch(BasicDBObject removeMustMatch) {
		this.removeMustMatch = removeMustMatch;
	}

	public DBObject getReturnFields() {
		return returnFields;
	}

	public void setReturnFields(DBObject returnFields) {
		this.returnFields = returnFields;
	}

	public DBObject getQueryUsesedToSearch() {
		return queryUsesedToSearch;
	}

	public void setQueryUsesedToSearch(DBObject queryUsesedToSearch) {
		this.queryUsesedToSearch = queryUsesedToSearch;
	}

	public DBObject getOrderBy() {
		return orderBy;
	}

	public void setOrderBy(DBObject orderBy) {
		this.orderBy = orderBy;
	}

	public MongoSqlType getSqlType() {
		return sqlType;
	}

	public void setMongoSqlType(MongoSqlType sqlType) {
		this.sqlType = sqlType;
	}
}
