package hiro.yoshioka.sql;

import hiro.yoshioka.ast.sql.DatabaseType;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.ResourceCaptionRequest;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.DBResource;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.util.FileExtUtil;
import hiro.yoshioka.util.StringUtil;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hslf.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;

public abstract class AbsBasicSQL implements IAbsBasicSQL, IConnectSQL {
	public String clientInfo;
	public static final String BINARY = "<BINARY>";
	public static final String[] EMPTY = StringUtil.EMPTY_STRING_ARRAY;
	protected Log fLogger = LogFactory.getLog(getClass());

	protected Connection _con;

	protected Connection _extra_con;

	public boolean doGet;

	DatabaseMetaData _meta;

	public static final String FORMAT_ALL = "%tF %<tT.%<tL";

	public static final String FORMAT_TIME = "%tF %<tT";

	public static final String FORMAT_DAY = "%tF";

	private String formatBuildTimeStamp = FORMAT_TIME;

	private String formatBuildDate = FORMAT_DAY;

	protected Driver _driver;

	protected String _url;

	protected ConnectionProperties _info;

	protected DBRoot _root;

	protected boolean connectiong;

	public boolean makeBlobData = false;

	protected boolean capturing;

	protected List<SqlTransactionListener> fTransactionListenerList = new ArrayList<SqlTransactionListener>();

	protected List<SqlBasicListener> fConnectionListenerList = new ArrayList<SqlBasicListener>();

	protected AbsBasicSQL(Driver ds) {
		_driver = ds;
	}

	public DatabaseType getDatabaseType() {
		return DatabaseType.parse(_driver.getClass().getName());
	}

	public boolean load(File f) {
		_root = loadDBRoot(f);
		return _root != null;
	}

	public boolean hasDriverClass() {
		return _driver != null;
	}

	public static DBRoot loadDBRoot(File f) {
		ObjectInputStream in = null;
		try {
			in = new ObjectInputStream(new FileInputStream(f));
			return (DBRoot) in.readObject();
		} catch (Exception e) {
			return null;
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e1) {
					return null;
				}
			}
		}
	}

	private void write(IDBResource res, File ff) throws IOException {
		ObjectOutputStream out2 = null;
		try {
			out2 = new ObjectOutputStream(new FileOutputStream(ff));
			out2.writeObject(res);
		} catch (Exception e) {
			fLogger.error(StringUtil.EMPTY_STRING, e);
		} finally {
			if (out2 != null) {
				out2.close();
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#save(java.io.File)
	 */
	public boolean save(File f) throws IOException {
		ObjectOutputStream out = null;
		try {
			out = new ObjectOutputStream(new FileOutputStream(f));
			out.writeObject(getRoot());
		} catch (Exception e) {
			fLogger.error(StringUtil.EMPTY_STRING, e);
		} finally {
			if (out != null) {
				out.close();
			}
		}

		return true;
	}

	public boolean connect(ConnectionProperties properties) throws SQLException {
		try {
			if (_con == null) {
				_info = properties;

				_url = properties.getProperty("url");
				connectiong = true;
				fLogger.info("Driver=" + _driver + " THIS[" + this + "]");
				fLogger.info("URL ACCEPT=" + (_driver.acceptsURL(_url))
						+ "ConnectionInfo:" + _info);

				_con = _driver.connect(_url,
						properties.getRelationalDBConnectionProperties());

				_con.setAutoCommit(false);

				_extra_con = _driver.connect(_url,
						properties.getRelationalDBConnectionProperties());
				_extra_con.setAutoCommit(false);

				for (int i = 0; i < fConnectionListenerList.size(); i++) {
					fConnectionListenerList.get(i).connected();
				}
			}
			properties.setConnected(true);
			return true;
		} finally {
			connectiong = false;
		}
	}

	public boolean doOperation(SQLOperationType OperationCode, Request request)
			throws SQLException {
		fLogger.info("doOperation:" + OperationCode);
		switch (OperationCode) {
		case CLOSE:
			return close();
		case CONNECT:
			return connect(request.getConnectionProperties());
		case RESOURCE_CAPTION:
			return getMetaData((ResourceCaptionRequest) request) != null;
		default:
			fLogger.warn("through default..." + OperationCode);
			break;
		}
		return false;
	}

	public boolean close() throws SQLException {
		boolean status = true;
		try {
			if (_con != null) {
				if (!_con.isClosed()) {
					_con.rollback();
					_con.close();
					fLogger.info("Closed connection");
				}
				// fTrunsactionTime = false;
			}
			if (_extra_con != null) {
				if (!_extra_con.isClosed()) {
					_extra_con.rollback();
					_extra_con.close();
					fLogger.info("Closed background connection");
				}
				// fTrunsactionTime = false;
			}
		} finally {
			_con = null;
			_extra_con = null;
			for (int i = 0; i < fConnectionListenerList.size(); i++) {
				fConnectionListenerList.get(i).disconnected();
			}
			_info.setConnected(false);
		}
		return status;
	}

	protected void notifyExecute(Connection connection,
			SQLExecutionStatus status, String... params) {
		switch (status) {
		case AFTER_EXECUTE:
			if (params.length != 2) {
				System.err.println("Argments count is must be 2!");
			}
			break;

		default:
			break;
		}
		for (int i = 0; i < fTransactionListenerList.size(); i++) {
			try {
				fTransactionListenerList.get(i).executionStatus(status,
						(_extra_con == connection), params);
			} catch (Exception e) {
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * hiro.yoshioka.sql.IAbsBasicSQL#addConnectionListner(hiro.yoshioka.sql
	 * .SqlBasicListener)
	 */
	public void addConnectionListner(SqlBasicListener listner) {
		fConnectionListenerList.add(listner);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * hiro.yoshioka.sql.IAbsBasicSQL#removeConnetionListener(hiro.yoshioka.
	 * sql.SqlBasicListener)
	 */
	public void removeConnetionListener(SqlBasicListener listner) {
		fConnectionListenerList.remove(listner);
	}

	@Override
	public ResultSetDataHolder renameField(IDBColumn before, String afterName)
			throws SQLException {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * hiro.yoshioka.sql.IAbsBasicSQL#addTracsactionListner(hiro.yoshioka.sql
	 * .SqlTransactionListener)
	 */
	public void addTracsactionListner(SqlTransactionListener listener) {
		fTransactionListenerList.add(listener);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * hiro.yoshioka.sql.IAbsBasicSQL#removeTracsactionListner(hiro.yoshioka
	 * .sql.SqlTransactionListener)
	 */
	public void removeTracsactionListner(SqlTransactionListener listener) {
		fTransactionListenerList.remove(listener);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#getRoot()
	 */
	public DBRoot getRoot() {
		return _root;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * hiro.yoshioka.sql.IAbsBasicSQL#setRoot(hiro.yoshioka.sql.resource.DBRoot)
	 */
	public void setRoot(DBRoot root) {
		_root = root;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#getCopyRoot()
	 */
	public DBRoot getCopyRoot() {
		ObjectOutputStream out = null;
		ObjectInputStream in = null;
		DBRoot newObject = null;
		try {
			ByteArrayOutputStream bout = new ByteArrayOutputStream();
			out = new ObjectOutputStream(bout);
			out.writeObject(_root);
			out.close();
			byte[] bytes = bout.toByteArray();
			in = new ObjectInputStream(new ByteArrayInputStream(bytes));
			newObject = (DBRoot) in.readObject();
			in.close();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (in != null) {
					in.close();
				}
				if (out != null) {
					out.close();
				}
			} catch (Exception ee) {
				ee.printStackTrace();
			}
		}
		return newObject;
	}

	private void setProp(Method method, Object invokeObject, Properties p) {
		try {
			method.setAccessible(true);
			Class retC = method.getReturnType();
			if (method.getParameterTypes().length == 0
					&& (retC.equals(String.class) || retC.equals(int.class) || retC
							.equals(boolean.class))) {
				if (method.getName().startsWith("get")) {
					Object o = method.invoke(invokeObject);
					p.put(method.getName().substring(3), String.valueOf(o));
				} else if (method.getName().startsWith("supports")) {
					Object o = method.invoke(invokeObject);
					p.put(method.getName().substring(8), String.valueOf(o));
				}
			}
		} catch (Throwable e) {
			fLogger.trace(method + "::" + e.getMessage());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#getSchemas()
	 */
	public ResultSetDataHolder getSchemas() {
		try {
			fLogger.info("start");
			capturing = true;
			_meta = _extra_con.getMetaData();
			notifyExecute(_extra_con, SQLExecutionStatus.GET_META_SCHEMA);
			ResultSetDataHolder rdh = RS2RDH(_meta.getSchemas(), true);
			return rdh;
		} catch (Exception e) {
			fLogger.error(StringUtil.EMPTY_STRING, e);
			return null;
		} finally {
			fLogger.info("end");
			capturing = false;
			_meta = null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#getTables(java.lang.String)
	 */
	public ResultSetDataHolder getTables(String text) {
		fLogger.info("start");
		try {
			capturing = true;
			_meta = _extra_con.getMetaData();
			notifyExecute(_extra_con, SQLExecutionStatus.GET_META_TABLE);
			return RS2RDH(_meta.getTables(null, text, "%", null), true);
		} catch (Exception e) {
			fLogger.error(StringUtil.EMPTY_STRING, e);
			return null;
		} finally {
			fLogger.info("end");
			capturing = false;
			_meta = null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#getProcedures(java.lang.String)
	 */
	public ResultSetDataHolder getProcedures(String name) {
		fLogger.info("start");
		try {
			capturing = true;
			_meta = _extra_con.getMetaData();
			notifyExecute(_extra_con, SQLExecutionStatus.GET_META_PROCEDURE);
			return RS2RDH(_meta.getProcedures(null, name, "%"), true);
		} catch (Exception e) {
			fLogger.error(StringUtil.EMPTY_STRING, e);
			return null;
		} finally {
			fLogger.info("end");
			capturing = false;
			_meta = null;
		}
	}

	/**
	 * �?��スキーマ�?�??ブルのコメントを取�? *
	 * 
	 * @return HashMap
	 * @throws SQLException
	 *             例外情報
	 */
	protected DBRoot getMetaData(ResourceCaptionRequest request) {
		try {
			capturing = true;
			_meta = _extra_con.getMetaData();

			if (request.canceld()) {
				return null;
			}
			if (request.grabOnlyTableResource) {
				IDBTable tbl = (IDBTable) request.selectionResource;
				tbl.removeAllColumns();
				setTableColumns(tbl.getParent().getName(), tbl);
			} else {
				_root = new DBRoot(_meta.getUserName());
				_root.setProperties(getDBMetaProperties());
				fLogger.info("re-generate DBRoot");
				createSchemaDef(request);
				String clazzName = this.getClass().toString().toLowerCase();
				if (clazzName.indexOf(".mysql") >= 0
						|| clazzName.indexOf("org.sqlite") >= 0) {
					_root.setDefaultSchema((IDBSchema) _root
							.getResource(StringUtil.EMPTY_STRING));
					_root.setCurrentSchema((IDBSchema) _root
							.getResource(StringUtil.EMPTY_STRING));
				} else if (clazzName.indexOf(".hsql") >= 0) {
					_root.setDefaultSchema((IDBSchema) _root
							.getResource("PUBLIC"));
					_root.setCurrentSchema((IDBSchema) _root
							.getResource("PUBLIC"));
				} else {
					IDBSchema[] schemas = _root.getSchemas();
					for (int i = 0; i < schemas.length; i++) {
						fLogger.info(schemas[i].getName() + "= comp ="
								+ _info.getProperty("user"));
						if (schemas[i].getName().equalsIgnoreCase(
								_info.getProperty("user"))) {
							_root.setDefaultSchema(schemas[i]);
							_root.setCurrentSchema(schemas[i]);
						}
					}
				}
				if (_root.getCurrentSchema() == null) {
					IDBSchema mschema = new DBSchema(_root);
					mschema.setName(_info.getProperty("user"));
					_root.putResource(mschema.getName(), mschema);
					_root.setDefaultSchema(mschema);
					_root.setCurrentSchema(mschema);
				}
				if (request.canceld()) {
					return null;
				}

				ResultSetDataHolder rdh = createDBTableDef(request);
				if (request.canceld()) {
					return null;
				}
				if (request.fCaptionForignKey) {
					createCrossReferenceDef(request);
				}

				createDBProcedureDef(request);
				if (request.canceld()) {
					return null;
				}
				if (request.doGetIndex()) {

				}
				// createDictionary();
				getTrigger();
				if (request.getConnectionProperties().isCaptureWithDDL()) {
					setTableText(request);
				}
				if (request.canceld()) {
					return null;
				}
				getSequence();
				if (request.doGetComment()) {
					setComments(request);
				}
				DBRoot oldRoot = _info.getDBRoot();
				if (oldRoot != null) {
					_root.getRecentryUsedResource().addAll(
							oldRoot.getRecentryUsedResource());
				}
			}

			return _root;
		} catch (Exception e) {
			fLogger.error(StringUtil.EMPTY_STRING, e);
			return null;
		} finally {
			capturing = false;
			_meta = null;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#isCapturing()
	 */
	public boolean isCapturing() {
		return capturing;
	}

	protected Properties getDBMetaProperties() {
		Properties p = new Properties();

		p.put("This DB Resources updated at ", String.format("%tF %tT",
				new java.util.Date(), new java.util.Date()));
		try {
			Method[] methods = DatabaseMetaData.class.getDeclaredMethods();
			for (int i = 0; i < methods.length; i++) {
				setProp(methods[i], _meta, p);
			}
			p.put("supportTokens", getSupportToken());
		} catch (RuntimeException e1) {
			fLogger.info(e1);
		}

		try {
			switch (_meta.getDefaultTransactionIsolation()) {
			case Connection.TRANSACTION_NONE:
				p.put("DefaultTransactionIsolation", "TRANSACTION_NONE");
				break;
			case Connection.TRANSACTION_READ_COMMITTED:
				p.put("DefaultTransactionIsolation",
						"TRANSACTION_READ_COMMITTED");
				break;
			case Connection.TRANSACTION_READ_UNCOMMITTED:
				p.put("DefaultTransactionIsolation",
						"TRANSACTION_READ_UNCOMMITTED");
				break;
			case Connection.TRANSACTION_REPEATABLE_READ:
				p.put("DefaultTransactionIsolation",
						"TRANSACTION_REPEATABLE_READ");
				break;
			case Connection.TRANSACTION_SERIALIZABLE:
				p.put("DefaultTransactionIsolation", "TRANSACTION_SERIALIZABLE");
				break;
			default:
				p.put("DefaultTransactionIsolation", "UNKNOWN");
			}
		} catch (Exception e1) {
			fLogger.info(e1);
		}
		return p;
	}

	/**
	 * 
	 */
	protected void createDictionary() throws SQLException {
	}

	protected String getSupportToken() {
		return StringUtil.EMPTY_STRING;
	}

	protected int countResultSet(ResultSet rs) {
		int row = 0;
		try {
			while (rs.next()) {
				row++;
			}
			rs.close();
		} catch (SQLException e) {
		}
		fLogger.info("num of:" + row);
		return row;
	}

	private void createSchemaDef(ResourceCaptionRequest request)
			throws SQLException {
		ResultSet rs = _meta.getSchemas();
		while (rs.next()) {
			String sn = rs.getString("TABLE_SCHEM");
			_info.isCapturingTarget(sn);
			IDBSchema mschema = (IDBSchema) _root.getResource(sn);
			if (mschema == null) {
				mschema = new DBSchema(_root);
				mschema.setName(sn);
				_root.putResource(mschema.getName(), mschema);
			}

		}
		rs.close();
		System.out.println("createSchemaDef=" + _root);
	}

	/**
	 * �??ブル定義を作�?
	 * 
	 * @return HashMap
	 * @throws SQLException
	 *             例外情報
	 */
	protected ResultSetDataHolder createDBTableDef(
			ResourceCaptionRequest request) throws SQLException {
		try {
			fLogger.info("start");
			ResultSetDataHolder rdh = null;

			for (IDBSchema mschema : _root.getSchemas()) {
				String sn = mschema.getName();

				request.begtinTask(
						"DatabaseMetaData#getTables[" + mschema.getName() + "]",
						1);

				request.worked(1);

				rdh = RS2RDH(_meta.getTables(null, sn, "%", null), true);
				for (int i = 0; i < rdh.getRowCount(); i++) {
					String tableName = rdh.getStringData(i, "TABLE_NAME");
					String type = rdh.getStringData(i, "TABLE_TYPE")
							.toUpperCase();
					if (tableName.indexOf("/") >= 0
							|| tableName.indexOf("BIN$") >= 0) {

						continue;
					}
					DBTable dbTable = new DBTable(mschema);
					dbTable.setName(tableName);
					System.out.println(tableName + "/" + dbTable.getName());
					dbTable.setTableType(type);
					if (request.getConnectionProperties()
							.isCaptureWithColumnInfo()) {
						setTableColumns(mschema.getName(), dbTable);
					}
					mschema.putTable(dbTable);

					request.subTask(dbTable.toString());

					setResourceProperties(dbTable, i, rdh);
				}
				if (request.canceld()) {
					return null;
				}
			}

			fLogger.info("end rdh is null ?" + (rdh == null));
			return rdh;
		} catch (RuntimeException e) {
			fLogger.info(e);
			return null;
		}
	}

	protected abstract void setTableText(ResourceCaptionRequest request)
			throws SQLException;

	protected abstract void getTrigger() throws SQLException;

	protected abstract void getSequence() throws SQLException;

	protected void createCrossReferenceDef(ResourceCaptionRequest request)
			throws SQLException {
		ResultSetDataHolder rdh = null;

		try {
			fLogger.info("start");
			IDBSchema[] schemas = _root.getSchemas();
			fLogger.info("schemas.length[" + schemas.length + "]");
			request.begtinTask("DatabaseMetaData#getCrossReference",
					schemas.length);
			for (int is = 0; is < schemas.length; is++) {

				fLogger.info("getCrossReference[" + schemas[is].getName() + "]");
				request.subTask("getCrossReference[" + schemas[is].getName()
						+ "]");

				rdh = RS2RDH(_meta.getCrossReference(StringUtil.EMPTY_STRING,
						schemas[is].getName(), null, StringUtil.EMPTY_STRING,
						StringUtil.EMPTY_STRING, null), true);

				DBCrossRefference index = null;

				fLogger.info("rdh.getRowCount()[" + rdh.getRowCount() + "]");

				for (int i = 0; i < rdh.getRowCount(); i++) {
					index = _root.getDBIndexRoot().getIndex(
							rdh.getStringData(i, "FK_NAME"));
					if (index == null) {
						index = new DBCrossRefference(_root.getDBIndexRoot());
						index.setName(rdh.getStringData(i, "FK_NAME"));
						_root.getDBIndexRoot().putIndex(index);
					}
					request.subTask("getCrossReference[" + index.getName()
							+ "]");

					IDBTable t = schemas[is].getTable(rdh.getStringData(i,
							"PKTABLE_NAME"));
					if (t == null) {
						continue;
					}
					IDBColumn c = (IDBColumn) t.getResource(rdh.getStringData(
							i, "PKCOLUMN_NAME"));
					if (c == null) {
						continue;
					}
					index.putPkColumn(c);
					String fkSchema = rdh.getStringData(i, "FKTABLE_SCHEM");
					String fkTable = rdh.getStringData(i, "FKTABLE_NAME");
					String fkColumn = rdh.getStringData(i, "FKCOLUMN_NAME");
					c = _root.getColumn(fkSchema, fkTable, fkColumn);
					if (c == null) {
						continue;
					}
					index.putFkColumn(c);

					index.setUpdateRule(rdh.getIntData(i, "UPDATE_RULE"));
					index.setDeleteRule(rdh.getIntData(i, "DELETE_RULE"));
				}
				request.worked(1);
			}
			fLogger.info("end root.getDBIndexRoot=" + _root.getDBIndexRoot());
		} catch (RuntimeException e) {
			fLogger.info(e);
		}
	}

	/**
	 * プロシジャ-定義を作�?
	 * 
	 * @return HashMap
	 * @throws SQLException
	 *             例外情報
	 */
	protected ResultSetDataHolder createDBProcedureDef(
			ResourceCaptionRequest request) throws SQLException {
		ResultSetDataHolder rdh = null;
		int row = 0;

		for (IDBSchema mschema : _root.getSchemas()) {
			String sn = mschema.getName();

			request.begtinTask(
					"DatabaseMetaData#getProcedures[" + mschema.getName() + "]",
					1);

			request.worked(1);
			if (request.canceld()) {
				return null;
			}

			rdh = RS2RDH(_meta.getProcedures(null, sn, "%"), true);
			for (int i = 0; i < rdh.getRowCount(); i++) {

				String tableSchem = rdh.getStringData(i, "PROCEDURE_SCHEM");
				String tableName = rdh.getStringData(i, "PROCEDURE_NAME");

				if (tableName.indexOf("/") > -1) {
					fLogger.info("Ignore Scehma/Procedure ["
							+ mschema.getName() + "/" + tableName + "]");
					continue;
				}
				DBTable dbProcudure = new DBTable(mschema);
				dbProcudure.setName(tableName);
				// dbProcudure.setComment(rs.getString("REMARKS").toUpperCase
				// ());
				dbProcudure.setProcedureType(Short.parseShort(rdh
						.getStringData(i, "PROCEDURE_TYPE")));
				dbProcudure.setResources(getProcedureColumns(sn, dbProcudure));
				mschema.putProcedure(dbProcudure);

				setResourceProperties(dbProcudure, i, rdh);

				request.subTask(dbProcudure.toString());
			}
		}

		return rdh;
	}

	/**
	 * アクセス権に関する記述を取得しま�? *
	 * 
	 * @param schema
	 *            スキーマ名
	 * @param table
	 *            �??ブル�??
	 * @return TreeMap カラ�?��報
	 * @throws SQLException
	 *             例外情報
	 */
	Map getTablePrivileges(String schema, String table) throws SQLException {
		ResultSetDataHolder rdh = null;
		TreeMap map = new TreeMap();

		DatabaseMetaData dbMetaData = _con.getMetaData();

		DBColumn columnObject;
		rdh = RS2RDH(dbMetaData.getTablePrivileges(null, null, "%SESSION%"),
				true);
		for (int i = 0; i < rdh.getRowCount(); i++) {
			String grantor = rdh.getStringData(i, "GRANTOR").toUpperCase();
			String grantee = rdh.getStringData(i, "GRANTEE").toUpperCase();
			String privilege = rdh.getStringData(i, "PRIVILEGE").toUpperCase();
			String is_grantable = rdh.getStringData(i, "IS_GRANTABLE")
					.toUpperCase();
		}

		return map;
	}

	/**
	 * カラ�?��取�? *
	 * 
	 * @param schema
	 *            スキーマ名
	 * @param table
	 *            �??ブル�??
	 * @return TreeMap カラ�?��報
	 * @throws SQLException
	 *             例外情報
	 */
	protected void setTableColumns(String schema, IDBTable table)
			throws SQLException {
		ArrayList<String> pkey = null;
		if (table.isSynonym()) {
			if (!StringUtil.isEmpty(table.getComment())) {
				String[] spl = table.getComment().split("[.]");
				if (spl.length == 2) {
					pkey = getTablePrimaryKeys(StringUtil.EMPTY_STRING, spl[0],
							spl[1]);
				}
			}
		} else {
			pkey = getTablePrimaryKeys(StringUtil.EMPTY_STRING, schema,
					table.getName());
		}

		ResultSet rs = null;
		Statement st = null;
		StringBuffer sql = new StringBuffer();
		try {
			sql.append("SELECT * FROM ");
			if (schema.trim().length() > 0) {
				sql.append(schema + ".");
			}
			sql.append(table.getName());
			st = _extra_con.createStatement();
			st.setMaxRows(1);

			rs = st.executeQuery(sql.toString());
			ResultSetMetaData md = rs.getMetaData();
			for (int i = 1; i <= md.getColumnCount(); i++) {
				DBColumn col = new DBColumn(table);
				col.setName(md.getColumnName(i));
				col.setDataType((short) md.getColumnType(i));
				try {
					col.setSize(md.getPrecision(i));
				} catch (Exception e) {
					col.setSize(0);
				}
				try {
					col.setDecimalDigits(md.getScale(i));
				} catch (Exception e) {
					col.setDecimalDigits(0);
				}

				col.setNullable((short) md.isNullable(i));
				if (pkey != null) {
					col.setPKey(pkey);
				}
				col.setDataTypeString(md.getColumnTypeName(i));
				col.setMaxColumnNameLength(_extra_con.getMetaData()
						.getMaxColumnNameLength());

				table.putResource(col.getUName(), col);
			}
		} catch (Exception e) {
			fLogger.info("sql=" + sql);
			fLogger.info(e);
			return;
		} finally {
			if (rs != null) {
				rs.close();
			}
			if (st != null) {
				st.close();
			}
		}
	}

	protected void setResourceProperties(DBResource res, int idx,
			ResultSetDataHolder rdh) {
		Properties p = res.getProperties();
		if (p == null) {
			p = new Properties();
		}
		String[] keys = rdh.getKey();
		for (int j = 0; j < keys.length; j++) {
			p.put(keys[j], StringUtil.nvl(rdh.getStringData(idx, keys[j])));
		}
		res.setProperties(p);
	}

	/**
	 * プライマリキーを取�? *
	 * 
	 * @param schema
	 *            スキーマ名
	 * @param table
	 *            �??ブル�??
	 * @return ArrayList Stringでキー名がリストされてま�? * @throws SQLException 例外情報
	 */
	protected ArrayList<String> getTablePrimaryKeys(String catalog,
			String schema, String table) throws SQLException {

		ArrayList<String> items = new ArrayList<String>();

		DatabaseMetaData dbMetaData = _extra_con.getMetaData();
		String field;

		ResultSet rs = dbMetaData.getPrimaryKeys(catalog, schema, table);
		if (rs != null) {
			ResultSetDataHolder rdh = RS2RDH(rs, true);

			for (int i = 0; i < rdh.getRowCount(); i++, items.add(field)) {
				field = rdh.getStringData(i, "COLUMN_NAME");
			}
		}

		return items;
	}

	// protected void createExportedKeys(ResourceCaptionRequest request,
	// String schema, String table) throws SQLException {
	// ResultSetDataHolder rdh = null;
	//
	// rdh = RS2RDH(_meta.getExportedKeys(StringUtil.EMPTY_STRING, schema,
	// table), true);
	//
	// IDBTable pkTable = null;
	// IDBTable fkTable = null;
	// IDBSchema pkSchema = null;
	// IDBSchema fkSchema = null;
	//
	//
	// for (int i = 0; i < rdh.getRowCount(); i++) {
	// String fkName = rdh.getStringData(i, "FK_NAME");
	// DBExportedKeyIndex index = getRoot().getDBConstraintRoot()
	// .getExportedKey(fkName);
	// if (index == null) {
	// try {
	// pkSchema = (IDBSchema) _root.getResource(rdh.getStringData(
	// i, "PKTABLE_SCHEM").toUpperCase());
	// fkSchema = (IDBSchema) _root.getResource(rdh.getStringData(
	// i, "FKTABLE_SCHEM").toUpperCase());
	// pkTable = pkSchema.getTable(rdh.getStringData(i,
	// "PKTABLE_NAME").toUpperCase());
	// fkTable = fkSchema.getTable(rdh.getStringData(i,
	// "FKTABLE_NAME").toUpperCase());
	//
	// index = new DBExportedKeyIndex(getRoot()
	// .getDBConstraintRoot());
	// index.setTable(pkTable, fkTable);
	// index.setUpdateRule(rdh.getStringData(i, "UPDATE_RULE"));
	// index.setDeleteRule(rdh.getStringData(i, "DELETE_RULE"));
	// getRoot().getDBConstraintRoot().putExportedKey(index);
	//
	// } catch (NullPointerException e) {
	// index = null;
	// fLogger.trace("PK: " + rdh.getStringData(i, "PKTABLE_SCHEM")
	// + rdh.getStringData(i, "PKTABLE_NAME"));
	// fLogger.trace("FK: " + rdh.getStringData(i, "FKTABLE_SCHEM")
	// + rdh.getStringData(i, "FKTABLE_NAME"));
	// continue;
	// }
	// }
	// if (index != null) {
	// index.putColumn((IDBColumn) pkTable.getResource(rdh
	// .getStringData(i, "PKCOLUMN_NAME")),
	// (IDBColumn) fkTable.getResource(rdh.getStringData(i,
	// "FKCOLUMN_NAME")));
	// request.subTask(index.toString());
	// request.worked(1);
	// }
	// }
	//
	// }

	/**
	 * プロシジャのカラ�?��報取�? *
	 * 
	 * @param schema
	 *            スキーマ名
	 * @param iprocedure
	 *            プロシジャ�??
	 * @return TreeMap プロシジャ�?? プロシジャ名で並べ替えられてま�? * @throws SQLException 例外情報
	 */
	protected Map getProcedureColumns(String schema, DBTable iprocedure)
			throws SQLException {
		ResultSet rs = null;
		LinkedHashMap<String, DBColumn> map = new LinkedHashMap<String, DBColumn>();
		try {
			DBColumn value;
			DatabaseMetaData dbMetaData = _extra_con.getMetaData();
			for (rs = dbMetaData.getProcedureColumns(null, schema,
					iprocedure.getName(), "%"); rs.next();) {
				value = new DBColumn(iprocedure);
				value.setName(rs.getString("COLUMN_NAME"));
				value.setColumnType(rs.getShort("COLUMN_TYPE"));
				value.setDataType(rs.getShort("DATA_TYPE"));

				value.setDataTypeString(rs.getString("TYPE_NAME"));
				value.setNullable(rs.getShort("NULLABLE"));
				value.setComment(rs.getString("REMARKS"));
				if (value.getName() != null) {
					map.put(value.getName(), value);
				}

			}
		} catch (SQLException e) {
			fLogger.info(e);
		} finally {
			if (rs != null) {
				rs.close();
			}
		}
		return map;
	}

	public boolean canDoOperation(SQLOperationType operation) {
		switch (operation) {
		case CLOSE:
			return _con != null;
		case CONNECT:
			if (_con != null || connectiong) {
				return false;
			}
			return true;
		case CHECK_VALIDATION:
		case RESOURCE_CAPTION:
			if (_con == null || connectiong || capturing) {
				return false;
			}
			return true;
		default:
			break;
		}
		return false;
	}

	// --------------------------------------------------------------------------
	// --
	/**
	 * �??ブル、カラ�?���?コメントを設�? *
	 * 
	 * @throws SQLException
	 *             例外情報
	 */
	// --------------------------------------------------------------------------
	// --
	protected abstract void setComments(ResourceCaptionRequest request)
			throws SQLException;

	private ResultSetDataHolder2 RS2RDH(ResultSet rs, boolean closeResultset)
			throws SQLException {
		return RS2RDH(rs, closeResultset, null, null);
	}

	protected ResultSetDataHolder2 RS2RDH(ResultSet rs, boolean closeResultset,
			String statement, Object[] binds) throws SQLException {
		ResultSetMetaData meta = rs.getMetaData();
		ResultSetDataHolder2 sdh = null;
		int colsize = meta.getColumnCount();
		String[] columns = new String[colsize];
		int[] colSize = new int[colsize];
		for (int i = 0; i < colsize; i++) {
			columns[i] = meta.getColumnName(i + 1);
			colSize[i] = meta.getColumnDisplaySize(i + 1);
		}
		sdh = new ResultSetDataHolder2(columns, meta);
		while (rs.next()) {
			String[] row = new String[colsize];
			for (int i = 0; i < colsize; i++) {
				row[i] = getStringUsingType(meta, rs, i + 1);
			}
			sdh.addRow(row);
		}

		if (closeResultset) {
			rs.close();
		}
		sdh.setSqlStatement(statement);
		sdh.setBinds(binds);
		return sdh;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#setBuildTimeStamp(java.lang.String)
	 */
	public void setBuildTimeStamp(String format) {
		formatBuildTimeStamp = format;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.sql.IAbsBasicSQL#setBuildDate(java.lang.String)
	 */
	public void setBuildDate(String format) {
		formatBuildDate = format;
	}

	private String getStringUsingType(ResultSetMetaData meta, ResultSet rs,
			int index) throws SQLException {

		try {
			switch (meta.getColumnType(index)) {
			case Types.TIMESTAMP:
				Timestamp t = rs.getTimestamp(index);
				if (t == null) {
					return null;
				}
				java.util.Date dd = new java.util.Date(t.getTime());
				return String.format(formatBuildTimeStamp, dd);
			case Types.DATE:
				Timestamp tt = rs.getTimestamp(index);
				if (tt == null) {
					return null;
				}
				return String.format(formatBuildDate,
						new java.util.Date(tt.getTime()));

			case Types.CLOB:
				Clob clob = rs.getClob(index);
				Reader reader = clob.getCharacterStream();
				char[] cbuffer = new char[1024];
				int length = -1;
				StringBuilder buf = new StringBuilder();
				try {
					while ((length = reader.read(cbuffer)) != -1) {
						buf.append(new String(cbuffer, 0, length));
					}
				} catch (IOException e1) {
					e1.printStackTrace();
				}
				return buf.toString();
			case Types.BLOB:
				Blob blob = rs.getBlob(index);
				if (blob == null) {
					return null;
				}
				if (makeBlobData) {
					File folder = new File("blob", meta.getTableName(index));
					if (!folder.exists()) {
						folder.mkdirs();
						if (!folder.exists()) {
							return "fail make folder["
									+ folder.getAbsolutePath() + "]";
						}
					}
					return makeBinary(meta, rs, index, folder,
							new BufferedInputStream(blob.getBinaryStream()));

				} else {
					return BINARY;
				}
			case Types.BINARY:
			case Types.VARBINARY:
			case Types.LONGVARBINARY:
				InputStream is = null;
				try {
					is = rs.getBinaryStream(index);
					if (is == null) {
						return null;
					}
					if (!makeBlobData) {
						if (is.available() > 0) {
							return BINARY;
						} else {
							return null;
						}
					}
				} catch (IOException e) {
					e.printStackTrace();
				}
				if (makeBlobData) {
					File folder = new File("blob", meta.getTableName(index));
					if (!folder.exists()) {
						folder.mkdirs();
						if (!folder.exists()) {
							return "fail make folder["
									+ folder.getAbsolutePath() + "]";
						}
					}

					String str = makeBinary(meta, rs, index, folder,
							new BufferedInputStream(is));

					return str;
				}
			case Types.DECIMAL:
			case Types.NUMERIC:
				BigDecimal decimal = rs.getBigDecimal(index);
				if (decimal == null) {
					return null;
				}
				return decimal.toPlainString();
			default:
				return rs.getString(index);
			}
		} catch (SQLException e) {
			fLogger.info(e);
			return null;
		}
	}

	private String makeBinary(ResultSetMetaData meta, ResultSet rs, int index,
			File folder, BufferedInputStream in) throws SQLException {
		BufferedOutputStream out = null;
		boolean testPoi = false;
		File file = null;
		try {
			byte[] buff = new byte[256];
			int len = 0;
			String ext = null;
			String prefix = StringUtil.nvl(meta.getColumnName(index));
			while (prefix.length() < 3) {
				prefix += "_";
			}
			for (int ii = 0; (len = in.read(buff, 0, 256)) > 0; ii++) {
				if (ii == 0) {
					ext = FileExtUtil.getExt(new String(buff, 0, len));
					if (ext == null) {
						ext = StringUtil.EMPTY_STRING;
						testPoi = true;
					} else {
						ext = "." + ext;
					}
					file = File.createTempFile(prefix, ext, folder);
					out = new BufferedOutputStream(new FileOutputStream(file));
				}
				out.write(buff, 0, len);
			}
			if (file == null) {
				file = File.createTempFile(prefix, StringUtil.EMPTY_STRING,
						folder);
				testPoi = false;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (out != null) {
				try {
					out.flush();
					out.close();
				} catch (IOException e) {
				}
			}
		}
		try {
			if (testPoi) {
				try {
					File nf = new File(file.getAbsolutePath() + ".xls");
					new HSSFWorkbook(new FileInputStream(file));
					file.renameTo(nf);
					return nf.getAbsolutePath();
				} catch (Exception e) {
				}
				try {
					File nf = new File(file.getAbsolutePath() + ".doc");
					new HWPFDocument(new FileInputStream(file));
					file.renameTo(nf);
					return nf.getAbsolutePath();
				} catch (Exception e) {
				}
				try {
					File nf = new File(file.getAbsolutePath() + ".ppt");
					new HSLFSlideShow(new FileInputStream(file));
					file.renameTo(nf);
					return nf.getAbsolutePath();
				} catch (Exception e) {
				}
			}

			return file.getAbsolutePath();
		} catch (Exception e) {
			fLogger.warn(e);
			return rs.getString(index);
		} finally {
			if (in != null) {
				try {
					in.close();
				} catch (IOException e) {
				}
			}
		}
	}

	public boolean connected() {
		return canDoOperation(SQLOperationType.CLOSE);
	}

	class SchemaTableN {
		String fSchema;

		String fTable;

		public SchemaTableN(String name, String name2) {
			fSchema = name;
			fTable = name2;
		}

		@Override
		public String toString() {
			return fSchema + "." + fTable;
		}
	}
}