package hiro.yoshioka.sdh2;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh.pair.DifferenceStringData;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.xml.DBSchemaValue;
import hiro.yoshioka.sql.resource.xml.DBTableValue;
import hiro.yoshioka.util.StringUtil;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

public class ResultSetDataHolder2 extends ResultSetDataHolder {
	private static final long serialVersionUID = -971743343622454131L;
	String sqlStatement;
	Object[] binds;
	String tableNameE;
	String tableName;
	String schemaNameE;

	public ResultSetDataHolder2() {
	}

	public ResultSetDataHolder2(String[] argNames, ResultSetMetaData meta)
			throws NullPointerException {
		super(argNames, meta);
	}

	public String getTableNameE() {
		if (tableNameE == null) {
			if (hasResultSetMetaData()) {
				try {
					return meta.getTableName(1);
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
		return tableNameE;
	}

	public String getSqlStatement() {
		return sqlStatement;
	}

	public void setSqlStatement(String sqlStatement) {
		this.sqlStatement = sqlStatement;
	}

	public Object[] getBinds() {
		return binds;
	}

	public void setBinds(Object[] binds) {
		this.binds = binds;
	}

	public void setSchemaNameE(String schemaNameE) {
		this.schemaNameE = schemaNameE;
	}

	public String getSchemaNameE() {
		return schemaNameE;
	}

	public String generateUpdateScript(int row) {
		StringBuilder buf = new StringBuilder();
		buf.append("UPDATE ");
		if (!StringUtil.isEmpty(getSchemaNameE())) {
			buf.append(getSchemaNameE()).append(".");
		}
		buf.append(getTableNameE());
		buf.append(" SET ");
		for (int i = 1; i < key.length; i++) {
			DifferenceStringData diff = (DifferenceStringData) getPair(row, i);
			if (diff.fDifferenceKind == DifferenceStringData.CHANGE) {
				buf.append(key[i]);
				buf.append("=");
				if (StringUtil.isEmpty(getStringData(row, key[i]))) {
					buf.append("NULL");
				} else {
					if (needsQuote(i)) {
						buf.append("'");
						buf.append(getStringData(row, key[i]));
						buf.append("'");
					} else {
						buf.append(getStringData(row, key[i]));
					}
				}
				buf.append(",");
			}
		}
		buf.setLength(buf.length() - 1);
		buf.append(" WHERE ");
		for (int i = 0; i < pkPositions.length; i++) {
			if (i > 0) {
				buf.append(" AND ");
			}
			int pos = pkPositions[i] + 1;
			buf.append(key[pos]);
			DifferenceStringData diff = (DifferenceStringData) getPair(row, pos);
			if (diff.fDifferenceKind == DifferenceStringData.NO_CHANGE) {
				buf.append("=");
				if (needsQuote(pos)) {
					buf.append("'");
					buf.append(getStringData(row, key[pos]));
					buf.append("'");
				} else {
					buf.append(getStringData(row, key[pos]));
				}
			} else {
				buf.append("=");
				if (needsQuote(pos)) {
					buf.append("'");
					buf.append(diff.fDiffString);
					buf.append("'");
				} else {
					buf.append(diff.fDiffString);
				}
			}
		}
		buf.append(";");
		return buf.toString();
	}

	public String generateDeleteScript(int row) {
		StringBuilder buf = new StringBuilder();
		buf.append("DELETE FROM ");
		if (!StringUtil.isEmpty(getSchemaNameE())) {
			buf.append(getSchemaNameE()).append(".");
		}
		buf.append(getTableNameE());

		buf.append(" WHERE ");
		for (int i = 0; i < pkPositions.length; i++) {
			if (i > 0) {
				buf.append(" AND ");
			}
			int pos = pkPositions[i] + 1;
			buf.append(key[pos]);
			buf.append("=");
			if (needsQuote(pos)) {
				buf.append("'");
				buf.append(getStringData(row, key[pos]));
				buf.append("'");
			} else {
				buf.append(getStringData(row, key[pos]));
			}
		}
		buf.append(";");
		return buf.toString();
	}

	public String generateInsertScript(int row) {
		StringBuilder buf = new StringBuilder();
		buf.append("INSERT INTO ");
		if (!StringUtil.isEmpty(getSchemaNameE())) {
			buf.append(getSchemaNameE()).append(".");
		}
		buf.append(getTableNameE());
		buf.append(" (");
		for (int i = 1; i < key.length; i++) {
			buf.append(key[i]);
			buf.append(",");
		}
		buf.setLength(buf.length() - 1);
		buf.append(") ");
		buf.append(StringUtil.LINE_SEPARATOR);
		buf.append(" VALUES (");
		for (int i = 1; i < key.length; i++) {
			if (StringUtil.isEmpty(getStringData(row, key[i]))) {
				buf.append("NULL");
			} else {
				if (needsQuote(i)) {
					buf.append("'");
					buf.append(getStringData(row, key[i]));
					buf.append("'");
				} else {
					buf.append(getStringData(row, key[i]));
				}
			}
			buf.append(",");
		}
		buf.setLength(buf.length() - 1);
		buf.append(");");
		return buf.toString();
	}

	public void setTableNameE(String tableNameE) {
		this.tableNameE = tableNameE;
		if (hasResultSetMetaData()) {
			meta.resetTableName(tableNameE);
		}
	}

	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public ReflectionPreparedStatement[] reflect() throws SQLException {
		if (log.isInfoEnabled()) {
			log.info("reflect start");
		}
		StringRecordData[] newData;
		StringRecordData[] oldData;

		ArrayList<ReflectionPreparedStatement> retList = new ArrayList<ReflectionPreparedStatement>();
		StringBuffer buff = new StringBuffer();
		if (log.isDebugEnabled()) {
			log.debug("fBackUpMap:" + fBackUpMap);
		}

		for (Iterator ite = fBackUpMap.entrySet().iterator(); ite.hasNext();) {
			Map.Entry entry = (Entry) ite.next();
			int index = ((Integer) entry.getKey()).intValue();
			newData = getStringRecordRow(index);
			oldData = (StringRecordData[]) entry.getValue();
			retList.add(new ReflectionPreparedStatement(meta, newData, oldData,
					pkPositions, tableNameE, schemaNameE));
			System.out.println("nlen/olen=" + newData.length + "/"
					+ oldData.length);
		}
		for (int i = getRowCount() - 1; i >= 0; i--) {
			newData = getStringRecordRow(i);
			HeaderData header = (HeaderData) newData[0];
			if (header.delete()) {
				retList.add(new ReflectionPreparedStatement(meta, newData,
						null, pkPositions, tableNameE, schemaNameE));
			}
		}
		return retList.toArray(new ReflectionPreparedStatement[retList.size()]);
	}

	public ReflectionPreparedStatement[] makeBlob(int[] targetIndexes)
			throws SQLException {

		if (log.isInfoEnabled()) {
			log.info("make blob start");
		}
		StringRecordData[] oldData;

		ArrayList<ReflectionPreparedStatement> retList = new ArrayList<ReflectionPreparedStatement>();
		for (int i = 0; i < targetIndexes.length; i++) {
			oldData = getStringRecordRow(targetIndexes[i]);
			retList.add(new ReflectionPreparedStatement(meta, null, oldData,
					pkPositions, tableNameE, schemaNameE));
		}

		return retList.toArray(new ReflectionPreparedStatement[retList.size()]);
	}

	public void setNamedInformationFromIDBTable(IDBTable fIDBTable,
			String currentSchemaName) {
		setTableNameE(fIDBTable.getName());
		setTableName(fIDBTable.getComment());
		setPkPositions(fIDBTable.getPkPositions());
		IDBSchema schema = (IDBSchema) fIDBTable.getParent();
		if (schema != null) {
			if (!schema.getName().equalsIgnoreCase(currentSchemaName))
				setSchemaNameE(schema.getName());
		}
	}

	public void setNamedInformationFromIDBTable(DBTableValue dbTable,
			String currentSchemaName) {
		setTableNameE(dbTable.getName());
		setTableName(dbTable.getComment());
		setPkPositions(dbTable.getPkPositions());
		DBSchemaValue schema = (DBSchemaValue) dbTable.getParent();
		if (schema != null) {
			if (!schema.getName().equalsIgnoreCase(currentSchemaName))
				setSchemaNameE(schema.getName());
		}
	}
}
