package hiro.yoshioka.sdh2;

import hiro.yoshioka.sdh.HeaderType;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh.ResultSetMetaCopy;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh.CSVRecordDataHolder.HeaderData;
import hiro.yoshioka.sql.util.BindObject;
import hiro.yoshioka.sql.util.SQLUtil;
import hiro.yoshioka.util.StringUtil;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReflectionPreparedStatement {
	public static final String FORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
	ResultSetMetaCopy meta;
	StringRecordData[] newData, oldData;
	int[] primaryIdx;
	String tableName;
	String schemaName;
	ArrayList<BindObject> bindList = new ArrayList<BindObject>();

	protected transient Log fLogger = LogFactory.getLog(getClass());

	public ReflectionPreparedStatement(ResultSetMetaCopy meta,
			StringRecordData[] newData, StringRecordData[] oldData,
			int[] primaryIdx, String tableName, String schemaName) {
		this.meta = meta;
		this.newData = newData;
		this.oldData = oldData;
		this.primaryIdx = primaryIdx;
		this.tableName = tableName;
		this.schemaName = schemaName;
	}

	public ReflectionPreparedStatement(ResultSetMetaCopy meta, String[] datumn,
			String tableName, String schemaName) {
		this.meta = meta;
		this.tableName = tableName;
		this.schemaName = schemaName;
		newData = new StringRecordData[datumn.length + 1];
		newData[0] = new ResultSetDataHolder().new HeaderData(
				StringUtil.EMPTY_STRING, HeaderType.INSERT);
		for (int i = 1; i < newData.length; i++) {
			newData[i] = new StringRecordData(datumn[i - 1]);
		}
	}

	public void setBinds(PreparedStatement st) throws SQLException {
		for (int i = 0; i < bindList.size(); i++) {
			BindObject o = bindList.get(i);
			SQLUtil.setBinds(st, i + 1, o);
		}
	}

	public String getStatement() throws SQLException {
		bindList.clear();
		StringBuffer buff = new StringBuffer();
		if (newData == null) { // blobRef
			buff.append("SELECT ");
			buff.append(meta.getBlobOrBinary());
			buff.append(" FROM ");
			buff.append(getSchemaTableName(1));
			buff.append(createWhere(oldData));
			return buff.toString();
		}
		HeaderData header = (HeaderData) newData[0];
		if (header.update()) {
			for (int i = 1; i < newData.length; i++) {
				if (!newData[i].getString().equals(oldData[i].getString())) {
					if (buff.length() == 0) {
						buff.append("UPDATE ");
						buff.append(getSchemaTableName(i));
						buff.append(" SET ");
					}
					buff.append(meta.getColumnName(i) + " = ?,");
					updateByType(meta.getColumnType(i), newData[i].getString());
				}
			}
			buff.setLength(buff.length() - 1);
			buff.append(createWhere(oldData));
		} else if (header.insert()) {
			fLogger.warn("INSERT STATEMENT");
			StringBuffer valueBuff = new StringBuffer();
			for (int i = 1; i < newData.length; i++) {
				if (i == 1) {
					buff.append("INSERT INTO ");
					buff.append(getSchemaTableName(i));
					buff.append(" ( ");
				}
				buff.append(meta.getColumnName(i) + " ,");
				valueBuff.append("?,");
				updateByType(meta.getColumnType(i), newData[i].getString());
			}
			buff.setLength(buff.length() - 1);
			valueBuff.setLength(valueBuff.length() - 1);
			buff.append(") VALUES (").append(valueBuff).append(")");
		} else if (header.delete()) {
			fLogger.warn("DELETE STATEMENT");
			buff.append("DELETE FROM ");
			buff.append(getSchemaTableName(1));
			buff.append(" ");
			buff.append(createWhere(newData));
		}
		return buff.toString();
	}

	private void updateByType(int columnType, String value) {
		fLogger.trace("columnType[" + columnType + "]");
		if (value == null) {
			// bindList.add(null);
			bindList.add(new BindObject(null, columnType));
			return;
		}
		switch (columnType) {

		case Types.BIT:
		case Types.BOOLEAN:
			bindList.add(new BindObject(SQLUtil.getBoolean(value), columnType));
			return;

		case Types.TIME:
			bindList.add(new BindObject(SQLUtil.getTime(value), columnType));
			return;
		case Types.SMALLINT:
			bindList.add(new BindObject(SQLUtil.getShort(value), columnType));
			return;
		case Types.INTEGER:
			bindList.add(new BindObject(SQLUtil.getInteger(value), columnType));
			return;
		case Types.REAL:
		case Types.FLOAT:
		case Types.BIGINT:
		case Types.NUMERIC:
		case Types.DOUBLE:
		case Types.DECIMAL:
			bindList.add(new BindObject(SQLUtil.getBigDecimal(value),
					columnType));
			return;
		case Types.TIMESTAMP:
			bindList
					.add(new BindObject(SQLUtil.getTimeStamp(value), columnType));
			return;
		case Types.DATE:
			bindList.add(new BindObject(SQLUtil.getDate(value), columnType));
			return;
		default:
			if (value.length() == 0) {
				value = null;
			}
			bindList.add(new BindObject(value, columnType));
		}
	}

	public String getTableName() {
		return tableName;
	}

	private String getSchemaTableName(int column) throws SQLException {
		String schema = meta.getSchemaName(column);
		String table = meta.getTableName(column);
		if (!StringUtil.isEmpty(schemaName)) {
			schema = schemaName;
		}
		if (schema == null || schema.length() == 0) {
			if (table == null || table.length() == 0) {
				return tableName;
			}
			return meta.getTableName(column);
		}
		return schema + "." + meta.getTableName(column);
	}

	private String createWhere(StringRecordData[] sr) throws SQLException {
		StringBuffer buff = new StringBuffer();
		buff.append(" WHERE ");
		for (int i = 0; i < primaryIdx.length; i++) {
			if (i > 0) {
				buff.append(" AND ");
			}
			int idx = primaryIdx[i] + 1;
			buff.append(meta.getColumnName(idx)).append("=?");
			updateByType(meta.getColumnType(idx), sr[idx].getString());
		}
		return buff.toString();
	}

}
