package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;

import java.util.Iterator;
import java.util.regex.Pattern;

public interface IProposalableParserUtil extends IParserUtil {
	String[] ASSIST_TABLE_NAMES = { "FROM", "UPDATE", "DELETE", "INTO" };
	String ASSIST_TABLE_COMPLETION_UPDATE = ".*UpdateStatement.*ASTQueryTableExpressionClause ASTIdentifier.*";

	String ASSIST_TABLE_COMPLETION_SELECT = ".*ASTSelectBase.*ASTFrom.*ASTQueryTableExpressionClause.*ASTtableIdentifier.*";

	String ASSIST_TABLE_COMPLETION_DELETE = ".*DeleteStatement.*ASTQueryTableExpressionClause.*ASTtableIdentifier.*";

	String ASSIST_TABLE_COMPLETION = "(" + ASSIST_TABLE_COMPLETION_UPDATE + "|"
			+ ASSIST_TABLE_COMPLETION_SELECT + ")";

	String ASSIST_COLUMN_PATTERN_SELECT = ".*ASTSelectColumnsElement ASTExpr ASTExprComp ASTSimpleExpression ASTSchemaTableColumn ASTIdentifier";

	String ASSIST_COLUMN_PATTERN_ORDER = ".*ASTOrderByElement.*ASTIdentifier";

	String ASSIST_COLUMN_PATTERN_GROUP = ".*ASTGroupByClause.*ASTIdentifier";

	String[] tableCompletion = { "WHERE", "GROUP BY", "ORDER BY", "AND", "OR" };

	Pattern PATTERN_WHERE_SPACE = Pattern.compile(".*WHERE\\s+\\w*\\s*",
			Pattern.CASE_INSENSITIVE | Pattern.MULTILINE);

	String getFormattedString(ASTFormatingInfo info);

	String getSpecialTokenString();

	TransactionRequest createTransactionRequest(ConnectionProperties p);

	void clearAlias();

	boolean parse();

	DBRoot getDBRoot();

	ASTAssist getASTAssist();

	ASTProposalableAssist getASTProposalableAssist();

	abstract IToken[] getAllErrorTokens();


}