package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.IDML;
import hiro.yoshioka.ast.sql.RowColumn;
import hiro.yoshioka.sql.resource.IDBTable;

import java.util.Iterator;

public interface IParserUtil {
	boolean doQuery();

	AbsSimpleNode getRoot();

	AbsSimpleNode[] getNodesPaths(AbsSimpleNode node);

	AbsSimpleNode[] getErrorNodes(AbsSimpleNode node);

	void dumpNodes();

	IDML getDML();

	boolean parse();

	boolean wasParseSuccess();

	String getFormattedString(ASTFormatingInfo info);

	BindInfo[] binds();

	IDBTable getFirstTable();

	String getSQLStatement();

	void setRowColumn(RowColumn rowColumn);

	BackWord getBackWord();

	BackWord getBackWordAt(RowColumn rowColumn);

	void dump();

	void enable_tracing();

	Iterator getExpectedTokens();

}
