package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.sql.resource.IDBTable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ASTEditorTableListHolder {
	private boolean _hasBrace;

	List<IDBTable> list = new ArrayList<IDBTable>();

	boolean hasBrace() {
		return _hasBrace;
	}

	public void addTable(IDBTable table) {
		if (table == null) {
			return;
		}
		list.add(table);
	}

	public String toString() {
		StringBuffer buf = new StringBuffer("TABLE LISTS ");

		buf.append(list.toString());
		return buf.toString();
	}

	public boolean hasMultiTable() {
		if (list.size() > 1) {
			return true;
		}
		return false;
	}

	public int size() {
		return list.size();
	}

	// ----------------------------------------------------------------------------
	/**
	 * @return IDBTableのリストイテレータ
	 */
	// ----------------------------------------------------------------------------
	public Iterator<IDBTable> iterator() {
		return list.iterator();
	}

	/**
	 * @return
	 */
	public IDBTable getLastTable() {
		if (list.size() >= 1) {
			return (IDBTable) list.get(list.size() - 1);
		} else {
			return null;
		}

	}

	/**
	 * @param list2
	 */
	public void addTableList(List list2) {
		for (Iterator iter = list2.iterator(); iter.hasNext();) {
			Object table = iter.next();
			if (table instanceof IDBTable) {
				list.add((IDBTable) table);
			}

		}
	}

}