package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.mongo.util.Sql2MongoVisitor;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.oracle.WolfSQLParser;
import hiro.yoshioka.ast.sql.util.ASTFormatingInfo;
import hiro.yoshioka.ast.sql.util.BindInfo;
import hiro.yoshioka.ast.sql.util.ParserUtil;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WolfParserUtil extends ParserUtil {

	public WolfParserUtil(File file) throws FileNotFoundException {
		super(file);
	}

	public WolfParserUtil(String string) {
		super(string);
	}

	public AbsSQLParser createParser(StringReader reader) {
		return new WolfSQLParser(reader);
	}

	public AbsSQLParser createParser(FileInputStream stream) {
		return new WolfSQLParser(stream);
	}

	public String getWhereStatement() {
		return null;
	}

	public String getFormattedString(ASTFormatingInfo info) {
		try {
			if (!this.fParser.nodeCreated()) {
				return this.fSQL_Statement;
			}
			if (doneParse && flg) {
				CodeFormatingVisitor visitor = new CodeFormatingVisitor();
				return (String) ((SimpleNode) getRoot()).jjtAccept(visitor,
						info);
			}
			return breakKeyWord(this.fSQL_Statement);
		} catch (RuntimeException e) {
			e.printStackTrace();
			return this.fSQL_Statement;
		}
	}

	private String breakKeyWord(String statement) {
		Pattern P = Pattern
				.compile(
						"(SELECT|FROM|UPDATE|INSERT|WHERE|ORDER BY|GROUP BY|AND|OR)([ ,\n]+)",
						Pattern.CASE_INSENSITIVE);
		statement = statement.replaceAll("\r\n", "\n");
		statement = statement.replaceAll("\r", "\n");
		Matcher m = P.matcher(statement);
		StringBuffer buf = new StringBuffer();
		while (m.find()) {
			m.appendReplacement(buf, "$1$2\n  ");
		}
		m.appendTail(buf);
		statement = buf.toString().replaceAll(" +\n", "\n");
		statement = statement.replaceAll("[\n]+", StringUtil.LINE_SEPARATOR);

		return statement;
	}

	public static void main(String[] args) {
		String sql = "SELECT T0._id,T0.name,T0.type,T0.count,T0.info FROM mydb3.system.col1 T0 "
				+ "where info<5 or info>8 and type is null order by info desc,col1";
		WolfParserUtil util = new WolfParserUtil(sql);
		if (util.parse()) {
			System.out.println("table=" + util.getFirstTable());
			System.out.println("parent=" + util.getFirstTable().getParent());
			System.out.println("where=" + util.getDML());
			System.out.println("------------------------------");

			Sql2MongoVisitor visitor = new Sql2MongoVisitor(sql);
			visitor.visit((SimpleNode) util.getRoot(), null);
			System.out.println(visitor.getDatabase());
			System.out.println(visitor.getCollection());
			if (visitor.needsRetry()) {
				sql = sql.replaceAll(visitor.getCollection(), visitor
						.getCollection().replace('.', '_'));
				util = new WolfParserUtil(sql);
				util.parse();
				visitor = new Sql2MongoVisitor(sql);
				visitor.visit((SimpleNode) util.getRoot(), null);
			}
			System.out.println(visitor.getQueryUsedToSearch());
			System.out.println(visitor.getReturnFields());

			System.out.println("------------------------------");
			util.dumpNodes();
		}
	}

	public BindInfo[] binds() {
		if (!fParser.nodeCreated()) {
			return null;
		}

		BindCheckSQLNodeVisitor visitor = new BindCheckSQLNodeVisitor(
				getFirstTable());
		visitor.visit((SimpleNode) getRoot(), null);
		return (BindInfo[]) visitor.v.toArray(new BindInfo[0]);
	}

	@Override
	public AbsSimpleNode[] getFoldingNodes() {
		if (!fParser.nodeCreated()) {
			return null;
		}
		FoldingSQLNodeVisitor visitor = new FoldingSQLNodeVisitor();
		visitor.visit((SimpleNode) getRoot(), null);
		return (AbsSimpleNode[]) visitor.v.toArray(new AbsSimpleNode[0]);
	}

}
