package hiro.yoshioka.application.chihuahua;

import hiro.yoshioka.ast.sql.util.BindInfo;
import hiro.yoshioka.ast.sql.util.IProposalableParserUtil;
import hiro.yoshioka.ast.sql.util.ProposalParserFactory;
import hiro.yoshioka.ast.sql.util.WolfMongoProposalParserUtil;
import hiro.yoshioka.sdh.CDHTableViewer;
import hiro.yoshioka.sdh.CSVRecordDataHolder;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.ResourceCaptionRequest;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.notes.NotesDBTable;
import hiro.yoshioka.sql.util.SelectTableDialog;
import hiro.yoshioka.sql.view.DBResourceCompositeMaker;
import hiro.yoshioka.sql.view.DBResourceTreeViewer;
import hiro.yoshioka.sql.view.IDBResourceTreeViewerListener;
import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.util.ColorNameEnum;
import hiro.yoshioka.util.ColorUtil;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.util.StringUtil;

import java.io.File;

import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChihuahuaDBClient extends ApplicationWindow {
	StatusLineManager slm = new StatusLineManager();
	Display display;
	static SQLServerThread server;
	public DBResourceTreeViewer treeViewer;
	Text treeSearchText;
	Text sqlText;
	public CDHTableViewer v;
	ProgressMonitorDialog progressDialog;
	Button btConnect;
	Button btDisConnect;
	Button btExecuteQuery;

	public ChihuahuaDBClient(Shell shell) {
		super(shell);
		addStatusLine();
	}

	@Override
	public boolean close() {
		server.dispose();
		return super.close();
	}

	@Override
	protected StatusLineManager createStatusLineManager() {
		return slm;
	}

	public static void main(String[] args) {
		Shell shell = new Shell();
		ChihuahuaDBClient app = new ChihuahuaDBClient(shell);

		app.setBlockOnOpen(true);
		app.open();
		Display.getCurrent().dispose();
	}

	public void resetButtonStatus(
			final ConnectionProperties connectionProperties,
			final Object selection) {
		display.asyncExec(new Runnable() {
			@Override
			public void run() {
				if (selection instanceof ConnectionProperties) {
					btConnect.setEnabled(!connectionProperties.isConnected());
					btDisConnect.setEnabled(connectionProperties.isConnected());
				} else {
					btConnect.setEnabled(false);
					btDisConnect.setEnabled(false);
				}
			}
		});
	}

	private GridLayout createGridLayout(int num) {
		GridLayout layout = new GridLayout(num, false);
		layout.horizontalSpacing = 1;
		layout.verticalSpacing = 0;
		layout.marginBottom = 0;
		layout.marginHeight = 0;
		layout.marginLeft = 0;
		layout.marginRight = 0;
		layout.marginTop = 0;
		layout.marginWidth = 1;
		return layout;
	}

	@Override
	protected Control createContents(Composite parent) {
		server = SQLServerThread.getSQLServer();
		File configDir = new File("config");
		server.init(configDir);

		display = parent.getDisplay();
		getShell().setText("Chihuahua DB Client");
		final SashForm sashMain = new SashForm(parent, SWT.BORDER
				| SWT.VERTICAL);

		final SashForm sashTop = new SashForm(sashMain, SWT.BORDER
				| SWT.HORIZONTAL);
		Composite treeComposite = new Composite(sashTop, SWT.NONE);
		GridLayout gl = createGridLayout(1);
		treeComposite.setLayout(gl);

		DBResourceCompositeMaker maker = DBResourceCompositeMaker
				.getInstance(false);
		maker.createControl(treeComposite);
		maker.getMainComposite()
				.setLayoutData(new GridData(GridData.FILL_BOTH));
		sqlText = new Text(sashTop, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.BORDER);

		sqlText.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				if ((e.stateMask == SWT.COMMAND || e.stateMask == SWT.CTRL)
						&& (e.keyCode == 'a' || e.keyCode == 'A')) {
					sqlText.selectAll();
				}
			}
		});
		treeViewer = maker.getTreeViewer();
		treeViewer.setInput(server.getConnectionSet());
		treeSearchText = maker.getSearchText();
		Composite bottomComposite = new Composite(sashMain, SWT.NONE);
		bottomComposite.setLayout(createGridLayout(1));
		v = new CDHTableViewer(bottomComposite);
		v.getTable().setLayoutData(new GridData(GridData.FILL_BOTH));
		treeViewer
				.addDBResourceTreeViewerListener(new IDBResourceTreeViewerListener() {

					@Override
					public void fireSelectionChanged(
							ConnectionProperties connectionProperties,
							Object selection) {
						resetButtonStatus(connectionProperties, selection);
					}

					@Override
					public void fireDoubleClick(ConnectionProperties prop,
							Object selection) {
						if (selection instanceof ConnectionProperties) {
							if (!prop.isConnected()) {
								connect(prop);
							}
						} else if (selection instanceof IDBTable) {
							if (!prop.isConnected()) {
								MessageDialog.openError(getShell(),
										"Connection Error",
										"Now disconnected...");
								return;
							}
							IDBTable tbl = (IDBTable) selection;
							if (tbl.isTable() || tbl.isView()) {
								if (tbl.getColumns().length == 0) {
									tbl = refreshTableColumns(tbl);
								}
							}
							SelectTableDialog dialog = new SelectTableDialog(
									prop, display.getActiveShell(), tbl,
									new RequestAdaptor() {
										@Override
										public void called_done(
												Request request,
												SQLOperationType operation,
												ConnectionProperties properteis,
												final Object o) {
											System.out.println("done called !!!!!!!!!!  "
													+ request.hasException());

											ResultSetDataHolder rd = (ResultSetDataHolder) o;
											if (rd.getRowCount() > 0) {
												IDBTable tbl = ((TransactionRequest) request)
														.getIDBTable();
												if (tbl != null
														&& tbl instanceof NotesDBTable) {
													String html = ((NotesDBTable) tbl)
															.toHtmlString(rd, 0);
													FileUtil.writeFile(
															new File(
																	"C:/hogehoge.html"),
															html, "UTF-8");
												}
											}

											display.asyncExec(new Runnable() {
												@Override
												public void run() {
													System.out
															.println("async done called !!!!!!!!!!");
													v.setInputAdjustDatum((CSVRecordDataHolder) o);
												}
											});
											treeViewer
													.refreshResourceLazy(properteis
															.getDBRoot()
															.getRecentryUsedResource());
										}
									});
							dialog.setBlockOnOpen(true);
							int dialogResult = dialog.open();
							if (dialogResult == SelectTableDialog.OK) {
								sqlText.setText(dialog.getSqlStatementString());
								// TODO:
								// treeViewer.refresh();
							}
						}
					}
				});
		Composite tree_btnPanel = new Composite(treeComposite, SWT.BOTTOM);
		tree_btnPanel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		FillLayout fl = new FillLayout(SWT.HORIZONTAL);
		fl.marginHeight = 0;
		fl.spacing = 0;
		tree_btnPanel.setLayout(fl);
		btConnect = new Button(tree_btnPanel, SWT.BORDER);
		btConnect.setText("Connect");
		btConnect.setEnabled(false);
		btConnect.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ConnectionProperties prop = treeViewer
						.getLatestSelectedConnectionProperties();
				connect(prop);
			}
		});
		btDisConnect = new Button(tree_btnPanel, SWT.BORDER);
		btDisConnect.setText("DisConnect");
		btDisConnect.setEnabled(false);
		btDisConnect.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ConnectionProperties prop = treeViewer
						.getLatestSelectedConnectionProperties();
				disConnect(prop);
			}
		});

		Composite btnPanel = new Composite(bottomComposite, SWT.BOTTOM);
		btnPanel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		btnPanel.setLayout(new FillLayout(SWT.HORIZONTAL));
		Button insBtn = new Button(btnPanel, SWT.BORDER);
		insBtn.setText("2. show colletions");
		insBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Object o = treeViewer.getFirstSelection();
				if (o instanceof IDBTable) {
					IDBTable tbl = (IDBTable) o;
					refreshTableColumns(tbl);
				}
			}
		});

		btExecuteQuery = new Button(btnPanel, SWT.BORDER);
		btExecuteQuery.setText("Execute Query");
		btExecuteQuery.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				ConnectionProperties prop = treeViewer
						.getLatestSelectedConnectionProperties();
				executeQuery(prop);
			}

		});

		Button delSave = new Button(btnPanel, SWT.BORDER);
		delSave.setText("save");
		delSave.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CSVRecordDataHolder rdh = v.getCDH();
				rdh.saveCSV(new File("hoge.csv"), "Utf-8",
						CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB, false);
			}
		});
		Button adjustDatum = new Button(btnPanel, SWT.BORDER);
		adjustDatum.setText("adjustDatum");
		adjustDatum.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CSVRecordDataHolder rdh = v.getCDH();
				v.setInputAdjustDatum(rdh);
			}
		});

		Button adjustArea = new Button(btnPanel, SWT.BORDER);
		adjustArea.setText("adjustArea");
		adjustArea.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CSVRecordDataHolder rdh = v.getCDH();
				v.setInputAdjustArea(rdh);
			}
		});
		adjustDatum.setImage(ImageUtil.getImage(ImageUtil.ACTION_82_ERROR));
		adjustArea.setImage(ImageUtil.getImage(ImageUtil.ACTION_43_GO));

		parent.setSize(800, 480);

		return parent;

	}

	private IDBTable refreshTableColumns(IDBTable tbl) {
		ConnectionProperties prop = treeViewer
				.getLatestSelectedConnectionProperties();
		ResourceCaptionRequest req = new ResourceCaptionRequest(prop);
		req.grabOnlyTableResource = true;
		req.selectionResource = tbl;
		try {
			ITransactionSQL sql = SQLServerThread.getSQLServer()
					.getTransactionSQL(prop);

			sql.doOperation(SQLOperationType.RESOURCE_CAPTION, req);
			SQLServerThread.getSQLServer().saveConnectionProperties();
			tbl = sql.getRoot().getTable(tbl.getParent().getName(),
					tbl.getName());
			treeViewer.refreshResourceLazy(tbl);

		} catch (Exception ee) {
			ee.printStackTrace();
		}
		return tbl;

	}

	private IProposalableParserUtil getParserUtil(
			ConnectionProperties connectionProperties, String sql_statement) {
		ProposalParserFactory factory = ProposalParserFactory
				.createFactory(connectionProperties.getDriverName());
		return factory.createParserUtil(sql_statement,
				connectionProperties.getDBRoot());
	}

	private void executeQuery(ConnectionProperties connectionProperties) {
		IProposalableParserUtil util = getParserUtil(connectionProperties,
				sqlText.getText());
		util.parse();

		if (!util.doQuery()) {
			MessageDialog
					.openWarning(Display.getCurrent().getActiveShell(), null,
							"Chihuahua can't accept Transactional Request..., only DML.");
			return;
		}
		TransactionRequest tran_request = null;
		BindInfo[] binds = util.binds();
		if (binds.length > 0) {

		} else {
			switch (connectionProperties.getDatabaseType()) {
			case MONGO:
				WolfMongoProposalParserUtil mUtil = (WolfMongoProposalParserUtil) util;
				tran_request = mUtil
						.createTransactionRequest(connectionProperties);

				// req.setMaxRownum(fMaxRowsFromDB.getSelection());
				tran_request.setPartName(util.getFirstTable().getName());
				break;
			default:
				tran_request = new TransactionRequest(
						SQLOperationType.PREPARED_EXECUTE_QUERY,
						connectionProperties, util.getSQLStatement());
				break;
			}

			server.putRequest(tran_request);
		}
		tran_request.addListener(treeViewer);
		tran_request.addListener(new RequestAdaptor() {
			@Override
			public void called_done(final Request request,
					SQLOperationType operation,
					final ConnectionProperties properteis, final Object o) {
				System.out.println("done caleed executeQuery");
				display.asyncExec(new Runnable() {
					@Override
					public void run() {
						ResultSetDataHolder rdh = null;
						if (request.hasException()) {
							rdh = new ResultSetDataHolder(
									new String[] { "exceptins" });
							Throwable ex = request.getException();
							rdh.addRow(new String[] {

							ex.getMessage() });
							for (StackTraceElement line : ex.getStackTrace()) {
								rdh.addRow(new String[] { line.toString() });
							}
							Throwable ex2 = ex.getCause();
							if (ex2 != null) {
								Throwable ex3 = ex2.getCause();
								if (ex3 != null) {
									rdh.addRow(new String[] {
											StringUtil.EMPTY_STRING,
											"    " + ex3.getMessage() });
									for (StackTraceElement line : ex3
											.getStackTrace()) {
										rdh.addRow(new String[] {
												StringUtil.EMPTY_STRING,
												"    " + line.toString() });
									}
								}
							}

						} else {
							rdh = (ResultSetDataHolder) o;
						}
						v.setInputAdjustDatum(rdh);

						setStatus("done...");
					}
				});
			}
		});
	}

	private void connect(ConnectionProperties connectionProperties) {
		final Request request = new Request(SQLOperationType.CONNECT,
				connectionProperties);
		request.addListener(treeViewer);
		server.putRequest(request);
		request.addListener(new RequestAdaptor() {
			@Override
			public void called_done(Request request,
					SQLOperationType operation,
					final ConnectionProperties properteis, Object o) {
				final ResultSetDataHolder rdh = new ResultSetDataHolder(
						new String[] { "result", "exceptins" });
				Throwable ex = request.getException();
				if (ex == null) {
					rdh.addRow(new String[] { String.valueOf(request.result),
							StringUtil.EMPTY_STRING });
				} else {
					rdh.addRow(new String[] { String.valueOf(request.result),
							ex.getMessage() });
					for (StackTraceElement line : ex.getStackTrace()) {
						rdh.addRow(new String[] { StringUtil.EMPTY_STRING,
								line.toString() });

					}
					Throwable ex2 = ex.getCause();
					if (ex2 != null) {
						Throwable ex3 = ex2.getCause();
						if (ex3 != null) {
							rdh.addRow(new String[] { StringUtil.EMPTY_STRING,
									"    " + ex3.getMessage() });
							for (StackTraceElement line : ex3.getStackTrace()) {
								rdh.addRow(new String[] {
										StringUtil.EMPTY_STRING,
										"    " + line.toString() });
							}
						}
					}
				}
				display.asyncExec(new Runnable() {
					@Override
					public void run() {
						v.setInputAdjustDatum(rdh);
						if (properteis.isConnected()
								&& properteis
										.isCaptureResourceAfterTheConnectProcess()) {
							captureResource(properteis);
						}
						btConnect.setEnabled(!properteis.isConnected());
						btDisConnect.setEnabled(properteis.isConnected());
						setStatus("Connected...");
					}
				});
			}
		});
	}

	private void disConnect(ConnectionProperties connectionProperties) {
		final Request request = new Request(SQLOperationType.CLOSE,
				connectionProperties);
		request.addListener(treeViewer);
		server.putRequest(request);
		request.addListener(new RequestAdaptor() {
			@Override
			public void called_done(Request request,
					SQLOperationType operation,
					final ConnectionProperties properteis, Object o) {
				final ResultSetDataHolder rdh = new ResultSetDataHolder(
						new String[] { "result", "exceptins" });
				Throwable ex = request.getException();
				if (ex == null) {
					rdh.addRow(new String[] { String.valueOf(request.result),
							StringUtil.EMPTY_STRING });
				} else {
					rdh.addRow(new String[] { String.valueOf(request.result),
							ex.getMessage() });
					for (StackTraceElement line : ex.getStackTrace()) {
						rdh.addRow(new String[] { StringUtil.EMPTY_STRING,
								line.toString() });

					}
					Throwable ex2 = ex.getCause();
					if (ex2 != null) {
						Throwable ex3 = ex2.getCause();
						if (ex3 != null) {
							rdh.addRow(new String[] { StringUtil.EMPTY_STRING,
									"    " + ex3.getMessage() });
							for (StackTraceElement line : ex3.getStackTrace()) {
								rdh.addRow(new String[] {
										StringUtil.EMPTY_STRING,
										"    " + line.toString() });
							}
						}
					}
				}
				display.asyncExec(new Runnable() {
					@Override
					public void run() {
						v.setInputAdjustDatum(rdh);
						treeViewer.refresh();
						btConnect.setEnabled(!properteis.isConnected());
						btDisConnect.setEnabled(properteis.isConnected());
						setStatus("DisConnected...");
					}
				});
			}
		});
	}

	private void captureResource(ConnectionProperties connectionProperties) {
		ResourceCaptionRequest request = new ResourceCaptionRequest(
				connectionProperties);
		setStatus("CaptureResoruce...");

		request.grabOnlyTableResource = false;
		SQLServerThread.putRequest(request);
		request.addListener(treeViewer);
		request.addListener(new RequestAdaptor() {
			@Override
			public void begtinTask(String taskName, int row) {
				System.out.println("begin[" + taskName + "] row=" + row);
			}

			@Override
			public void subTask(final String subTaskName) {
				display.asyncExec(new Runnable() {
					@Override
					public void run() {
						setStatus("CaptureResoruce... [" + subTaskName + "]");
					}
				});
			}

			@Override
			public void called_done(Request request,
					SQLOperationType operation,
					ConnectionProperties properteis, Object o) {
				System.out.println("done");
				DBRoot root = SQLServerThread
						.getSQLServer()
						.getTransactionSQL(
								treeViewer
										.getLatestSelectedConnectionProperties())
						.getRoot();
				System.out.println("root=" + root);
				final ResultSetDataHolder rdh = new ResultSetDataHolder(
						new String[] { "DB", "Collection" });
				for (IDBSchema schema : root.getSchemas()) {
					if (root.hasChildren()) {
						rdh.addRow(new String[] { schema.getName(),
								StringUtil.EMPTY_STRING });
					} else {
						for (IDBTable table : schema.getTables()) {
							rdh.addRow(new String[] { schema.getName(),
									table.getName() });
						}
					}
				}
				display.asyncExec(new Runnable() {
					@Override
					public void run() {
						setStatus("CaptureResoruce... [DONE]");
						v.setInputAdjustDatum(rdh);
					}
				});
			}
		});
	}
}
