import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;

import java.sql.DatabaseMetaData;
import java.sql.Types;

public class MockGenerator {
	public static DBRoot generateDBRoot() {
		DBRoot root = new DBRoot();
		IDBSchema mschema = null;
		DBTable table = null;
		IDBColumn column = null;
		String[] columns = null;
		mschema = new DBSchema(root);
		mschema.setName("FP");
		root.putResource(mschema.getName(), mschema);
		table = new DBTable(mschema);
		table.setName("M_CODE");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"CAT","CODE","VALUE","FLG"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_CIF_LIFE_EVENT");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"EVENT_ID","CIF","ANOTHER_CIF","EVENT_KIND","EVENT_DT"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_CUSTOMER");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"CIF","FAMILY_CIF","HOUSE_HOLDER","SEX","USER_KANA","USER_KANJI","BIRTH_DT","CRT_DT","UPD_DT"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_PROJECT");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"PROJECT_ID","PROJECT_NAME","USER_ID","CRT_DT","UPD_DT"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_PROJECT_CUSTOMER");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"PROJECT_ID","CIF","NUM"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_RELATION_SHIP");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"CIF","ANOTHER_CIF","RELATION"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_SALES_PERSON");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"CIF","USER_ID"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_USER");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"USER_ID","USER_NAME"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("V_CUSTOMER");
		mschema.putTable(table);
		columns = new String[]{"CIF","FAMILY_CIF","HOUSE_HOLDER","SEX","USER_KANA","USER_KANJI","BIRTH_DT","CRT_DT","UPD_DT","SPOUSE"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		mschema = new DBSchema(root);
		mschema.setName("HR");
		root.putResource(mschema.getName(), mschema);
		table = new DBTable(mschema);
		table.setName("HOGE_ADD");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"COL","TM","NUM","DT","NUM2","CUST_SEX","CUST_CREDIT_RATING"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		mschema = new DBSchema(root);
		mschema.setName("PUBLIC");
		root.putResource(mschema.getName(), mschema);
		root.setDefaultSchema(mschema);
		table = new DBTable(mschema);
		table.setName("M_CODE");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"CAT","CODE","VALUE","E_FLG"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_CUSTOMER");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"CIF","FAMILY_CIF","HOUSE_HOLDER","SEX","USER_KANA","USER_KANJI","BIRTH_DT","CRT_DT","UPD_DT"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_PROJECT");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"PROJECT_ID","PROJECT_NAME","USER_ID"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_SALES_PERSON");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"CIF","USER_ID"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		table = new DBTable(mschema);
		table.setName("T_USER");
		table.setTableType("TABLE");
		mschema.putTable(table);
		columns = new String[]{"USER_ID","USER_NAME"};
		  for (int i = 0; i < columns.length; i++) {
		  DBColumn col = new DBColumn(table);
		  col.setName(columns[i]);
		  col.setComment("comment_" + i);
		  col.setDataType(Types.VARCHAR);
		  col.setDataTypeString("VARCHAR2");
		  col.setSize(10);
		  col.setDecimalDigits(0);
		  col.setNullable(DatabaseMetaData.attributeNullable);
		  col.setPKey(true);
		  table.putResource(col.getUName(), col);
		}
		mschema = new DBSchema(root);
		mschema.setName("INFORMATION_SCHEMA");
		root.putResource(mschema.getName(), mschema);
		return root;
	}
}
