/* Generated By:JavaCC: Do not edit this line. Token.java Version 3.0 */
package hiro.yoshioka.ast.sql.oracle;

import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.util.StringUtil;

import java.util.ArrayList;
import java.util.Collections;

/**
 * Describes the input token stream.
 */

public class Token implements IToken {

	/**
	 * An integer that describes the kind of this token. This numbering system
	 * is determined by JavaCCParser, and a table of these numbers is stored in
	 * the file ...Constants.java.
	 */
	public int kind;

	/**
	 * beginLine and beginColumn describe the position of the first character of
	 * this token; endLine and endColumn describe the position of the last
	 * character of this token.
	 */
	public int beginLine, beginColumn, endLine, endColumn;

	/**
	 * The string image of the token.
	 */
	public String image;

	/**
	 * A reference to the next regular (non-special) token from the input
	 * stream. If this is the last token from the input stream, or if the token
	 * manager has not read tokens beyond this one, this field is set to null.
	 * This is true only if this token is also a regular token. Otherwise, see
	 * below for a description of the contents of this field.
	 */
	public Token next;

	/**
	 * This field is used to access special tokens that occur prior to this
	 * token, but after the immediately preceding regular (non-special) token.
	 * If there are no such special tokens, this field is set to null. When
	 * there are more than one such special token, this field refers to the last
	 * of these special tokens, which in turn refers to the next previous
	 * special token through its specialToken field, and so on until the first
	 * special token (whose specialToken field is null). The next fields of
	 * special tokens refer to other special tokens that immediately follow it
	 * (without an intervening regular token). If there is no such token, this
	 * field is null.
	 */
	public IToken specialToken;

	/**
	 * Returns the image.
	 */
	public String toString() {
		return image;
	}

	/**
	 * Returns a new Token object, by default. However, if you want, you can
	 * create and return subclass objects based on the value of ofKind. Simply
	 * add the cases to the switch for all those special cases. For example, if
	 * you have a subclass of Token called IDToken that you want to create if
	 * ofKind is ID, simlpy add something like : case MyParserConstants.ID :
	 * return new IDToken(); to the following switch statement. Then you can
	 * cast matchedToken variable to the appropriate type and use it in your
	 * lexical actions.
	 */
	public static final Token newToken(int ofKind) {
		switch (ofKind) {
		default:
			return new Token();
		}
	}

	public int getKind() {
		return kind;
	}

	public int getBeginLine() {
		return beginLine;
	}

	public int getBeginColumn() {
		return beginColumn;
	}

	public int getEndLine() {
		return endLine;
	}

	public int getEndColumn() {
		return endColumn;
	}

	public IToken getNext() {
		return next;
	}

	public void setSpecialToken(IToken sp) {
		// System.out.println("Me[" + toString() + "] setted[" + sp + "]");
		specialToken = sp;
	}

	public IToken getSpecialToken() {
		return specialToken;
	}

	public String getSpecialTokensImage() {
		if (specialToken == null) {
			return "";
		}
		ArrayList<IToken> list = new ArrayList<IToken>();
		((Token) specialToken).reListSpecialToken(list);
		Collections.reverse(list);
		// for(int i=0;i<list.size();i++){
		// IToken tk = list.get(i);
		// String tokenImage =
		// OracleSQLParserConstants.tokenImage[tk.getKind()];
		// }
		StringBuilder buf = new StringBuilder();
		for (int i = 0; i < list.size(); i++) {
			String image = list.get(i).getImage();
			if (i > 0 && !image.endsWith(StringUtil.LINE_SEPARATOR)) {
				buf.append(StringUtil.LINE_SEPARATOR);
			}
			buf.append(image);
		}
		return buf.toString();
	}

	private void reListSpecialToken(ArrayList<IToken> list) {
		list.add(this);
		if (specialToken != null) {
			((Token) specialToken).reListSpecialToken(list);
		}
	}

	public String getImage() {
		return image;
	}

}
