package hiro.yoshioka.ast.sql.oracle;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.IDDL;
import hiro.yoshioka.ast.sql.util.ASTEditorTableListHolder;
import hiro.yoshioka.sql.resource.IDBTable;

import java.util.List;

public abstract class ASTDefaultDDL extends SimpleNode implements IDDL {
	public ASTEditorTableListHolder fTableHolder = new ASTEditorTableListHolder();

	public ASTDefaultDDL(int id) {
		super(id);
	}

	public ASTDefaultDDL(AbsSQLParser p, int id) {
		super(p, id);
	}

	public boolean emptyTableList() {
		return fTableHolder.size() == 0;
	}

	public boolean beginTransaction() {

		return false;
	}

	public boolean isDML() {
		return false;
	}

	/**
	 * @return
	 */
	public String infomatin() {
		return null;
	}

	public void addTable(IDBTable table) {
		fTableHolder.addTable(table);
	}

	public void addTableList(List list) {
		fTableHolder.addTableList(list);
	}

	public boolean isDDL() {
		return true;
	}

	public boolean isDOL() {
		return false;
	}

}
