package hiro.yoshioka.sql.resource;

import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.eclipse.swt.graphics.Image;

public interface IDBResource {
    /**  */
    public int IDB_COLUMN = 0;

    /** e[u */
    public int IDB_TABLE = 1;

    /** r[ */
    public int IDB_VIEW = 2;

    /** Vmj */
    public int IDB_SYNONYM = 3;

    /** pbP[W&vVW */
    public int IDB_PROCEDURE = 4;

    /** XL[} */
    public int IDB_SCHEMA = 5;

    // ----------------------------------------------------------------------------
    // PUBLIC METHODS
    // ----------------------------------------------------------------------------
    void setName(String name);

    DBRoot getRoot();

    void slimUp();

    public String getName();

    public String getNameWithComment();

    String getNameWithAsComment();

    public String getUName();

    public boolean startsNameWith(String string);

    public List<IDBResource> startsWithResourceLists(String pattern);

    public boolean startsCommentWith(String string);

    Properties getProperties();

    void setProperties(Properties p);

    public boolean isValid();

    public void setValid(boolean valid);

    public Image getImage();

    /**
     * Rg擾
     * 
     * @return Rg
     */
    public String getComment();

    public String getUComment();

    public String getImageString();

    /**
     * Rgݒ
     * 
     * @param comment Rg
     */
    public void setComment(String comment);

    /**
     * ێ\[X̔zł̎擾
     * 
     * @return ێ\[X
     */
    public IDBResource[] listArrayResources();

    /**
     * \[X̐ݒ
     * 
     * @param map \[X
     */
    public void setResources(Map<String, IDBResource> map);

    /**
     * \[X̎擾
     * 
     * @param key L[
     * @return \[X
     */
    public IDBResource getResource(String key);

    /**
     * \[X̐ݒ
     * 
     * @param key L[
     * @param child q\[X
     */
    public void putResource(String key, IDBResource child);

    /**
     * e\[X̎擾
     * 
     * @return \[X
     */
    public IDBResource getParent();

    int childrenNum();

    /**
     * @param pattern
     * @return true ܂
     */
    public boolean contain(String pattern);

}