package hiro.yoshioka.sql.resource.xml;

import hiro.yoshioka.sql.resource.IDBColumn;

public class DBColumnValue extends DBResouceValue {
	int maxColumnNameLength;

	private int type;

	private int size;

	private int decimalDigits;

	private boolean notnull;

	private boolean pkey;

	private boolean indexColumn;

	private String dataTypeString;

	public DBColumnValue() {
	}

	public DBColumnValue(DBTableValue parent, IDBColumn column) {
		this(column);
		this.parent = parent;
	}

	public DBColumnValue(IDBColumn column) {
		super(column);
		setType(column.getDataType());
		setSize(column.getSize());
		setDecimalDigits(column.getDecimalDigits());
		setNotnull(column.isNotNull());
		setPkey(column.isPkey());
		setIndexColumn(column.isIndexColumn());
		setMaxColumnNameLength(column.getMaxColumnNameLength());
		setDataTypeString(column.getDataTypeString());
	}

	private String limitBytes(String target, int len) {
		byte[] b = target.getBytes();
		if (len <= 0 || b.length <= len) {
			return target;
		}
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < target.length()
				&& buf.toString().getBytes().length < len; i++) {
			buf.append(target.charAt(i));
		}
		return buf.toString();
	}

	public String getNameWithCommentLimLen() {
		if (getComment().length() > 0) {
			return getName() + " \""
					+ limitBytes(getComment(), maxColumnNameLength) + "\"";
		}
		return getName();
	}

	public String getNameWithAsCommentLimLen() {
		if (getComment().length() > 0) {
			return getName() + " As \""
					+ limitBytes(getComment(), maxColumnNameLength) + "\"";
		}
		return getName();
	}

	public boolean isDate() {
		return type == 91 || type == 92 || type == 93;
	}

	public boolean isNumeric() {
		return type == 4 || type == 6 || type == 8 || type == -5 || type == 3
				|| type == 2 || type == 5 || type == -6;
	}

	public boolean isBigDecimal() {
		return type == 3;
	}

	public boolean isString() {
		return type == 1 || type == -1 || type == 12;
	}

	public int getDecimalDigits() {
		return decimalDigits;
	}

	public void setDecimalDigits(int decimalDigits) {
		this.decimalDigits = decimalDigits;
	}

	public boolean isIndexColumn() {
		return indexColumn;
	}

	public void setIndexColumn(boolean indexColumn) {
		this.indexColumn = indexColumn;
	}

	public boolean isNotnull() {
		return notnull;
	}

	public void setNotnull(boolean notnull) {
		this.notnull = notnull;
	}

	public boolean isPkey() {
		return pkey;
	}

	public void setPkey(boolean pkey) {
		this.pkey = pkey;
	}

	public int getSize() {
		return size;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public int getMaxColumnNameLength() {
		return maxColumnNameLength;
	}

	public void setMaxColumnNameLength(int maxColumnNameLength) {
		this.maxColumnNameLength = maxColumnNameLength;
	}

	public String getDataTypeString() {
		return dataTypeString;
	}

	public void setDataTypeString(String dataTypeString) {
		this.dataTypeString = dataTypeString;
	}
}
