package hiro.yoshioka.ast.sql.util;

import hiro.yoshioka.ast.sql.IQueryTableExpression;
import hiro.yoshioka.ast.sql.ISchemaTableColumn;
import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.swt.graphics.Image;

public abstract class ProposalableParserUtil extends ParserUtil {
	protected String ASSIST_TABLE_COMPLETION_UPDATE = ".*UpdateStatement.*ASTQueryTableExpressionClause ASTIdentifier.*";

	protected String ASSIST_TABLE_COMPLETION_SELECT = ".*ASTSelectBase.*ASTFrom.*ASTQueryTableExpressionClause.*ASTtableIdentifier.*";

	protected String ASSIST_TABLE_COMPLETION_DELETE = ".*DeleteStatement.*ASTQueryTableExpressionClause.*ASTtableIdentifier.*";

	protected String ASSIST_TABLE_COMPLETION = "("
			+ ASSIST_TABLE_COMPLETION_UPDATE + "|"
			+ ASSIST_TABLE_COMPLETION_SELECT + ")";

	protected String ASSIST_COLUMN_PATTERN_SELECT = ".*ASTSelectColumnsElement ASTExpr ASTExprComp ASTSimpleExpression ASTSchemaTableColumn ASTIdentifier";

	protected String ASSIST_COLUMN_PATTERN_ORDER = ".*ASTOrderByElement.*ASTIdentifier";

	protected String ASSIST_COLUMN_PATTERN_GROUP = ".*ASTGroupByClause.*ASTIdentifier";

	protected String[] tableCompletion = { "WHERE", "GROUP BY", "ORDER BY",
			"AND", "OR" };

	protected Pattern PATTERN_WHERE_SPACE = Pattern
			.compile(".*WHERE\\s+\\w*\\s*", Pattern.CASE_INSENSITIVE
					| Pattern.MULTILINE);

	DBRoot fDBRoot;

	public abstract String getFormattedString(ASTFormatingInfo info);

	public ASTAssist getASTAssist1() {
		try {
			ASTAssist assist = createAssistWithBetween();
			if (assist == null) { // 悻n
				assist = new ASTAssist(ASTAssist.ASSIST_NOTHING);
				assist = createAssist(assist);
			}
			if (fParser.hasException()) {
				if (assist.isKey()) {
					assist.setExpedtedTokens(getExpectedTokens());
				}
				if (assist.isNothing()) {
					assist = new ASTAssist(ASTAssist.ASSIST_KEY_WORD);
					assist.setExpedtedTokens(getExpectedTokens());
				}
			}
			assist.setBackWord(fBackWord);
			return assist;
		} catch (Throwable e) {
			if (fLogger.isInfoEnabled()) {
				fLogger.info(StringUtil.EMPTY_STRING, e);
			}
			ASTAssist assist = new ASTAssist(ASTAssist.ASSIST_NOTHING);
			if (fParser.hasException()) {
				assist = new ASTAssist(ASTAssist.ASSIST_KEY_WORD);
				assist.setExpedtedTokens(getExpectedTokens());
			}
			return assist;

		}
	}

	protected abstract ASTAssist createAssistWithBetween();

	protected abstract ASTAssist createAssist(ASTAssist assist);

	public ProposalableParserUtil(File file, DBRoot root)
			throws FileNotFoundException {
		super(file);
		fDBRoot = root;
	}

	public ProposalableParserUtil(String string, DBRoot root) {
		super(string);
		fDBRoot = root;
	}

	/**
	 * @param stream
	 */
	public ProposalableParserUtil(FileInputStream stream, DBRoot root) {
		super(stream);
		fDBRoot = root;
	}

	public void clearAlias() {
		if (fDBRoot != null) {
			fDBRoot.clearAlias();
		}
	}

	public boolean parse() {
		if (!doneParse) {
			doneParse = true;
			try {
				if (fDBRoot != null) {
					fDBRoot.clearAlias();
				}
				if (fLogger.isInfoEnabled()) {
					fLogger.info("froot=" + fDBRoot);
				}
				flg = fParser.parse(fDBRoot);
				flg = flg && fParser.nodeCreated();
			} catch (Throwable e) {
				if (fLogger.isDebugEnabled()) {
					fLogger.debug(StringUtil.EMPTY_STRING, e);
				}
				flg = false;
			}
		}
		if (fLogger.isInfoEnabled()) {
			fLogger.info("Parsing result[" + flg + "]");
		}

		return flg;
	}

	public ASTAssist getASTAssist() {
		ASTProposalableAssist assist = new ASTProposalableAssist(
				getASTAssist1());
		if (fParser.nodeCreated()) {
			setProposalResource(assist);
		}
		String[] keys = assist.getKeyWords(fBackWord);
		for (int i = 0; i < keys.length; i++) {
			String keyword = keys[i] + " ";
			CompletionProposal comp = new CompletionProposal(keyword, fBackWord
					.getReplacementOffset(true), fBackWord
					.getReplacementLength(true), keyword.length());
			assist.addProposal(comp);
		}
		if (fLogger.isInfoEnabled()) {
			fLogger.info("assist last::" + assist);
		}
		return assist;

	}

	protected abstract ASTEditorTableListHolder getASTEditorTableListHolder();

	/**
	 * @param assist
	 */
	private void setProposalResource(ASTProposalableAssist assist) {
		if (fLogger.isInfoEnabled()) {
			fLogger.info("assist=" + assist);
		}
		if (fDBRoot == null) {
			return;
		}
		if (assist.isColumn()) { // 񖼃AVXg
			ASTEditorTableListHolder holder = getASTEditorTableListHolder();
			ISchemaTableColumn columnInfo = assist.fASTSchemaTableColumn;
			if (columnInfo != null) {
				if (fLogger.isInfoEnabled()) {
					fLogger.info("񖼃AVXg Info=" + columnInfo.infomation());
				}
				for (Iterator<IDBTable> ite = holder.iterator(); ite.hasNext();) {
					IDBTable table = ite.next();
					if (table.hasAlias()) {
						if (table.getAlias().startsWith(
								columnInfo.getColumnString())) {
							// SELECT cXXXXX FROM FP.M_CODE co
							createAliasProposal(assist, table);
						}
					}

					IDBSchema schema = fDBRoot.getCurrentSchema();
					List list = table.getProposal(schema, columnInfo
							.getSchemaString(), columnInfo.getTableString(),
							columnInfo.getColumnString());
					if (fLogger.isInfoEnabled()) {
						fLogger.info("list=" + list);
					}
					createColumnProposal(assist, list, " ", holder
							.hasMultiTable(), columnInfo.containDot());
				}
				// if (holder.hasMultiTable() &&
				// columnInfo.containOnlyColumnString()) {
				// fLogger.warning("e[uwL肩yGCAXAe[uAXL[}z̃AVXgKv");
				// for (Iterator ite = holder.iterator(); ite.hasNext();) {
				// IDBTable table = (IDBTable) ite.next();
				// String target = table.getName();
				// if (table.getAlias().length() > 0) {
				// target = table.getAlias();
				// }
				// if
				// (target.toUpperCase().startsWith(columnInfo.getColumnString().toUpperCase()))
				// {
				// createTableProposal(assist, table, ".");
				// }
				// }
				// }
			} else {
				if (holder == null) {
					return;
				}
				for (Iterator ite = holder.iterator(); ite.hasNext();) {
					IDBTable table = (IDBTable) ite.next();
					fLogger.debug("table=" + table);
					IDBSchema schema = fDBRoot.getCurrentSchema();

					String[] parts = fBackWord.getWords(BackWord.LEVEL_COLUMN);

					fLogger.info("schema[" + schema + "] parts:0[" + parts[0]
							+ "] parts1:[" + parts[1] + "] parts2:[" + parts[2]
							+ "]");

					if (fBackWord.endOfDot
							&& table.getAlias().equalsIgnoreCase(parts[2])) {
						// SELECT co.XXXXX FROM FP.M_CODE co
						parts[2] = StringUtil.EMPTY_STRING;
					}
					List list = table.getProposal(schema, parts[0], parts[1],
							parts[2]);
					createColumnProposal(assist, list, " ", holder
							.hasMultiTable(), fBackWord.hasDot);
				}
			}
		} else if (assist.isTable()) {
			fLogger.debug("assist.fASTQueryTableExpressionClause=["
					+ assist.fASTQueryTableExpressionClause + "]");

			IQueryTableExpression tableInfo = assist.fASTQueryTableExpressionClause;

			if (tableInfo == null) {
				String[] words = fBackWord.getWords(BackWord.LEVEL_TABLE);
				System.out.println("words[0]=" + words[0]);
				System.out.println("words[1]=" + words[1]);
				System.out.println("fBackWord.endOfDot:" + fBackWord.endOfDot);
				System.out.println("fBackWord.lastWord:["
						+ fBackWord.getLastWord() + "]");
				if (fBackWord.endOfDot) { // Ōオhbg
					if (StringUtil.isEmpty(words[0])) {// XL[}w薳
						createTableProposal(assist, fDBRoot.getCurrentSchema()
								.startsWithResourceLists(
										StringUtil.EMPTY_STRING), " ");
					} else {
						IDBResource res = fDBRoot.getResource(words[0]);
						if (res != null && res instanceof IDBSchema) {
							createTableProposal(
									assist,
									res
											.startsWithResourceLists(StringUtil.EMPTY_STRING),
									" ");
						}
					}
				} else {
					if (StringUtil.isEmpty(words[0])) {// XL[}w薳
						IDBSchema schema = fDBRoot.getCurrentSchema();
						createTableProposal(assist, schema
								.startsWithResourceLists(words[1]), " ");

						createSchemaProposal(assist, fDBRoot
								.startsWithResourceLists(words[1]), ".");
					} else {
						IDBResource res = fDBRoot.getResource(words[0]);
						if (res != null && res instanceof IDBSchema) {
							createTableProposal(assist, res
									.startsWithResourceLists(words[1]), " ");
						}
					}
				}
				return;
			}
			fLogger.debug("ASTQueryTableExpressionClause Info="
					+ tableInfo.infomation());
			if (tableInfo.getSchemaString().length() > 0) {
				IDBSchema schema = (IDBSchema) fDBRoot.getResource(tableInfo
						.getSchemaString());
				if (schema != null) {
					createTableProposal(assist, schema
							.getResourceListStartsWith(tableInfo
									.getTableNameString()), " ");
				}
			} else {
				createTableProposal(assist, fDBRoot.getCurrentSchema()
						.getResourceListStartsWith(
								tableInfo.getTableNameString()), " ");
				assist.fResourceList
						.addAll(fDBRoot.getSchemaListStartsWith(tableInfo
								.getTableNameString()));
			}
			fLogger.debug("assist.fProposalList=" + assist.fResourceList);
		}

	}

	/**
	 * @return
	 */
	public ASTProposalableAssist getASTProposalableAssist() {
		return (ASTProposalableAssist) getASTAssist();
	}

	private void createAliasProposal(ASTProposalableAssist assist,
			IDBTable table) {
		assist.fResourceList.add(table);

		String replacementString = table.getAlias() + ".";

		assist.addProposal(fBackWord, replacementString, table.getImage(),
				table.toString());
		if (fLogger.isInfoEnabled()) {
			assist.dumpCnvText(fSQL_Statement, fBackWord, replacementString);
		}
	}

	private void createColumnProposal(ASTProposalableAssist assist, List list,
			String sufix, boolean multi, boolean containDot) {
		assist.fResourceList.addAll(list);

		IDBResource column = null;
		Image image = null;
		for (int i = 0; i < list.size(); i++) {
			column = (IDBResource) list.get(i);
			String info = column.toString();
			String replacementString = column.getName() + sufix;
			if (column instanceof IDBColumn) {
				IDBColumn dColumn = (IDBColumn) column;
				image = dColumn.getImage();
				replacementString = dColumn.getProposalString() + sufix;
				if (multi) {
					IDBTable table = (IDBTable) column.getParent();
					info = column + "-" + table;
					if (!containDot) {
						if (table.getAlias().length() > 0) {
							replacementString = table.getAlias() + "."
									+ replacementString;
						}
					}
				}
			} else if (column instanceof IDBTable) {
			} else if (column instanceof IDBSchema) {
			} else {
				fLogger.error("zǑ^" + column);
				continue;
			}
			System.out.println("rep[" + replacementString + "]");
			assist.addProposal(fBackWord, replacementString, image, info);
			if (fLogger.isInfoEnabled()) {
				assist
						.dumpCnvText(fSQL_Statement, fBackWord,
								replacementString);
			}
		}
	}

	private void createTableProposal(ASTProposalableAssist assist,
			IDBTable table, String prefix) {
		assist.fResourceList.add(table);

		String replacementString = table.getName() + prefix;
		if (table.hasAlias()) {
			replacementString = table.getAlias() + prefix;
		}
		assist.addProposal(fBackWord, replacementString, table.getImage(),
				table.toString());
		if (fLogger.isInfoEnabled()) {
			assist.dumpCnvText(fSQL_Statement, fBackWord, replacementString);
		}
	}

	private void createSchemaProposal(ASTProposalableAssist assist,
			List<IDBResource> list, String prefix) {
		assist.fResourceList.addAll(list);

		IDBSchema schema = null;
		for (int i = 0; i < list.size(); i++) {
			IDBResource res = list.get(i);
			if (!(res instanceof IDBSchema)) {
				continue;
			}
			schema = (IDBSchema) res;
			// XL[}⊮
			String replacementString = schema.getName() + prefix;

			assist.addProposal(fBackWord, replacementString, schema.getImage(),
					schema.toString());
			if (fLogger.isInfoEnabled()) {
				assist
						.dumpCnvText(fSQL_Statement, fBackWord,
								replacementString);
			}
		}
	}

	private void createTableProposal(ASTProposalableAssist assist,
			List<IDBResource> list, String prefix) {
		assist.fResourceList.addAll(list);

		IDBTable table = null;
		for (int i = 0; i < list.size(); i++) {
			IDBResource res = list.get(i);
			if (!(res instanceof IDBTable)) {
				continue;
			}
			table = (IDBTable) res;
			fLogger.debug("table[" + i + "][" + table + "]");
			if (table.isProcudeure() || table.isDictionary()) {
				continue;
			}
			// XL[}⊮
			String replacementString = table.getName() + prefix;
			if (table.hasAlias()) {
				replacementString = table.getAlias() + prefix;
			}
			// fLogger.warning("replacementString[" + i + "][" +
			// replacementString + "]");
			try {
				// System.out.println("replacementString[" + replacementString +
				// "]");
				// System.out.println("replacementString.length[" +
				// replacementString.length() + "]");
				// System.out.println("fBackWord.getReplacementOffset[" +
				// fBackWord.getReplacementOffset() + "]");
				// System.out.println("fBackWord.getReplacementLength()[" +
				// fBackWord.getReplacementLength() + "]");

				assist.addProposal(fBackWord, replacementString, table
						.getImage(), table.toString());
				if (fLogger.isInfoEnabled()) {
					assist.dumpCnvText(fSQL_Statement, fBackWord,
							replacementString);
				}
			} catch (Throwable e) {
				e.printStackTrace();
				dump();
			}
		}
	}

	public abstract IToken[] getAllErrorTokens();

}