package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.IToken;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.oracle.WolfSQLParser;
import hiro.yoshioka.ast.sql.oracle.WolfSQLParserTreeConstants;
import hiro.yoshioka.ast.sql.util.ASTAssist;
import hiro.yoshioka.ast.sql.util.ASTEditorTableListHolder;
import hiro.yoshioka.ast.sql.util.ASTFormatingInfo;
import hiro.yoshioka.ast.sql.util.BindInfo;
import hiro.yoshioka.ast.sql.util.ProposalableParserUtil;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WolfProposalParserUtil extends ProposalableParserUtil {

	public WolfProposalParserUtil(File file, DBRoot root)
			throws FileNotFoundException {
		super(file, root);
	}

	public WolfProposalParserUtil(String string, DBRoot root) {
		super(string, root);
	}

	public WolfProposalParserUtil(FileInputStream stream, DBRoot root) {
		super(stream, root);
	}

	public String getFormattedString(ASTFormatingInfo info) {
		try {
			if (!this.fParser.nodeCreated()) {
				return this.fSQL_Statement;
			}
			if (doneParse && flg) {
				CodeFormatingVisitor visitor = new CodeFormatingVisitor();
				return (String) getMySimpleNode().jjtAccept(visitor, info);
			}
			return breakKeyWord(this.fSQL_Statement);
		} catch (RuntimeException e) {
			e.printStackTrace();
			return this.fSQL_Statement;
		}
	}

	private String breakKeyWord(String statement) {
		Pattern P = Pattern
				.compile(
						"(SELECT|FROM|UPDATE|INSERT|WHERE|ORDER BY|GROUP BY|AND|OR)([ ,\n]+)",
						Pattern.CASE_INSENSITIVE);
		statement = statement.replaceAll("\r\n", "\n");
		statement = statement.replaceAll("\r", "\n");
		Matcher m = P.matcher(statement);
		StringBuffer buf = new StringBuffer();
		while (m.find()) {
			m.appendReplacement(buf, "$1$2\n  ");
		}
		m.appendTail(buf);
		statement = buf.toString().replaceAll(" +\n", "\n");
		statement = statement.replaceAll("[\n]+", StringUtil.LINE_SEPARATOR);

		return statement;
	}

	private SimpleNode getMySimpleNode() {
		return (SimpleNode) getSimpleNode();
	}

	/**
	 * @param assist
	 * @return
	 */
	protected ASTAssist createAssistWithBetween() {
		ASTAssist ret = null;
		SimpleNode node = getMySimpleNode();
		if (node == null) {
			return null;
		}

		BetweenSQLNodeVisitor betweenVisitor = new BetweenSQLNodeVisitor();
		Vector v = (Vector) node.jjtAccept(betweenVisitor, fRowColumn
				.backWord());
		if (fLogger.isInfoEnabled()) {
			fLogger.info("Between::" + v);
		}

		ret = betweenVisitor.fLastAssist;
		if (betweenVisitor.fLastAssist == null && v.size() > 0) {
			SimpleNode last = (SimpleNode) v.lastElement();
			ret = last.fASTAssist;
			if (ret == null) {
				if (betweenVisitor.fASTSchemaTableColumn != null) {
					if (fLogger.isInfoEnabled()) {
						fLogger.info("fASTSchemaTableColumn::"
								+ betweenVisitor.fASTSchemaTableColumn
										.infomation());
					}
					ret = new ASTAssist(ASTAssist.ASSIST_COLUMN,
							betweenVisitor.fASTSchemaTableColumn);
				} else if (betweenVisitor.fASTQueryTableExpressionClause != null) {
					if (fLogger.isInfoEnabled()) {
						fLogger.info("t:"
								+ betweenVisitor.fASTQueryTableExpressionClause
										.infomation());
					}
					ret = new ASTAssist(ASTAssist.ASSIST_TABLE,
							betweenVisitor.fASTQueryTableExpressionClause);
				}
				if (WolfSQLParserTreeConstants.JJTFROM == last.getID()) {
					if (fLogger.isInfoEnabled()) {
						fLogger.info("FROM̒ŃAVXgׂ̓e[uH::");
					}
					ret = new ASTAssist(ASTAssist.ASSIST_TABLE);
				}
			}
		}
		if (fLogger.isInfoEnabled()) {
			fLogger.info("ret::" + ret);
		}

		return ret;
	}

	boolean forceClip;

	/**
	 * @param assist
	 * @return
	 */
	protected ASTAssist createAssist(ASTAssist assist) {
		SimpleNode node = getMySimpleNode();
		if (node == null) {
			return assist;
		}
		boolean fFlg = fBackWord.isFollow();
		forceClip = false;

		PastCheckSQLNodeVisitor visit2 = new PastCheckSQLNodeVisitor();
		Vector v2 = (Vector) getMySimpleNode().jjtAccept(visit2, fRowColumn);
		fLogger.info("yPASTz" + v2);

		if (v2.isEmpty()) {
			return assist;
		}
		SimpleNode lastElement = (SimpleNode) v2.lastElement();
		if (visit2.fAssist != null) {
			return visit2.fAssist;
		}

		boolean follow = fBackWord.startsWithOrFollow(tableCompletion);
		if (matcheClassPattern(v2, ASSIST_COLUMN_PATTERN_ORDER)) {
			fLogger.info("Match:ASSIST_COLUMN_PATTERN_ORDER:" + v2);
			assist = new ASTAssist(ASTAssist.ASSIST_COLUMN);

		} else if (matcheClassPattern(v2, ASSIST_COLUMN_PATTERN_GROUP) && fFlg) {
			fLogger.info("Match:ASSIST_COLUMN_PATTERN_GROUP:" + v2);
			assist = new ASTAssist(ASTAssist.ASSIST_COLUMN);

		} else if (matcheClassPattern(v2, ASSIST_TABLE_COMPLETION_DELETE)) {
			if (fLogger.isInfoEnabled()) {
				fLogger.info("Match:ASSIST_TABLE_COMPLETION_DELETE:" + v2);
			}
			assist = new ASTAssist(ASTAssist.ASSIST_TABLE);
		} else if (matcheClassPattern(v2, ASSIST_TABLE_COMPLETION)) {
			if (fLogger.isInfoEnabled()) {
				fLogger.info("Match:ASSIST_TABLE_COMPLETION follow[" + follow
						+ "]:" + v2);
			}
			if (PATTERN_WHERE_SPACE.matcher(
					getSQLStatement().replaceAll("\r|\n", " ")).matches()) {
				assist = new ASTAssist(ASTAssist.ASSIST_COLUMN);
				forceClip = true;
			} else if (follow) {
				assist = new ASTAssist(ASTAssist.ASSIST_TABLE);
			}
			String[] keys = tableCompletion;
			if (matcheClassPattern(v2, ".*GroupByClause.*")) {
				keys = new String[] { "HAVING ", "ORDER BY " };
			}
			assist.addKeyWords(keys);
		} else {
			fLogger.info("No Match:" + v2);
		}

		return assist;
	}

	public AbsSQLParser createParser(StringReader reader) {
		return new WolfSQLParser(reader);
	}

	public AbsSQLParser createParser(FileInputStream stream) {
		return new WolfSQLParser(stream);
	}

	protected ASTEditorTableListHolder getASTEditorTableListHolder() {
		TableListFindSQLNodeVisitor visit = new TableListFindSQLNodeVisitor();
		visit.forceClipDML = forceClip;
		visit.visit((SimpleNode) fParser.getRoot(), fRowColumn.backWord());
		System.out.println("getASTEditorTableListHolder[" + visit.v + "]");
		return visit.fASTEditorTableListHolder;
	}

	public IToken[] getAllErrorTokens() {
		if (fParser.nodeCreated()) {
			WolfParserExceptionCollatorSQLNodeVisitor visitor = new WolfParserExceptionCollatorSQLNodeVisitor();
			Vector v = (Vector) visitor.visit((SimpleNode) fParser.getRoot(),
					null);
			return (IToken[]) v.toArray(new IToken[v.size()]);
		}
		return new IToken[0];
	}

	@Override
	public BindInfo[] binds() {
		if (!fParser.nodeCreated()) {
			return null;
		}
		BindCheckSQLNodeVisitor visitor = new BindCheckSQLNodeVisitor(
				getFirstTable());
		visitor.visit((SimpleNode) getSimpleNode(), null);
		return (BindInfo[]) visitor.v.toArray(new BindInfo[0]);
	}

	@Override
	public AbsSimpleNode[] getFoldingNodes() {
		if (!fParser.nodeCreated()) {
			return null;
		}
		FoldingSQLNodeVisitor visitor = new FoldingSQLNodeVisitor();
		visitor.visit((SimpleNode) getSimpleNode(), null);
		return (AbsSimpleNode[]) visitor.v.toArray(new AbsSimpleNode[0]);
	}
}
