package hiro.yoshioka.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileList {
	private String _regex;
	private int depth;

	/**
	 * svFile[]̗vf0ԋpANull͕ԋpȂ
	 * 
	 * @param root
	 * @param depth
	 * @return Matchet@C
	 */
	public File[] getMatches(File root, int depth) {
		this.depth = depth;
		File[] ret = new File[0];

		if (root != null && root.exists()) {
			if (root.isFile()) {
				if (root.getName().matches(_regex)) {
					return new File[] { root };
				} else {
					return ret;
				}
			} else {
				List<File> flist = new ArrayList<File>();
				recurcse(root, flist, 1);
				return flist.toArray(new File[0]);
			}
		}
		return ret;
	}

	/**
	 * @param regex
	 */
	public FileList(String regex) {
		_regex = regex;
	}

	public void recurcse(File lib_dir, List<File> flist, int currentDepth) {
		File[] files = lib_dir.listFiles();
		if (files != null) {
			for (int j = 0; j < files.length; j++) {
				if (files[j].exists()) {
					if (files[j].isDirectory()) {
						if (depth > currentDepth || depth == -1) {
							recurcse(files[j], flist, currentDepth++);
						}
					} else if (files[j].getName().matches(_regex)) {
						flist.add(files[j]);
					}
				}
			}
		}
	}
}
