package hiro.yoshioka.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CSVUtil {
	private static Log log = LogFactory.getLog(CSVUtil.class);
	public static final char SEPARETOR_COMMA = ',';
	public static final char SEPARETOR_TAB = '\t';
	public static final char QUOTE_STRING_DOUBLE_QUOTE = '"';
	public static final char QUOTE_STRING_SINGLE_QUOTE = '\'';

	public static void main(String[] args) {
		String[][] o = splitCSV(new File(
				"D:/eclipse/csv/20090706_1750/HOGEP.csv"), SEPARETOR_COMMA,
				QUOTE_STRING_DOUBLE_QUOTE);

		// String ta = "0030030001, o^, 003, YS1013, 2006/10/05
		// 11:37:41\r\n"
		// + "0170170140, \"\r\n" + "2s\r\n"
		// + "₳\", 017, YS2008, 2006/10/05 13:14:21";
		// String[][] o = splitCSV(ta, ",");
		System.out.println("---- dump -----" + o.length);

		for (int i = 0; i < o.length; i++) {
			for (int j = 0; j < o[i].length; j++) {
				System.out.print(o[i][j] + ", ");
			}
			System.out.println();
		}
	}

	public static String[][] splitCSV(File target, char separator,
			char quotechar) {
		try {
			return splitCSV(new FileReader(target), separator, quotechar);
		} catch (FileNotFoundException e) {
			log.fatal(StringUtil.EMPTY_STRING, e);
		}
		return null;
	}

	public static String[][] splitByTAB_quoteDouble(String target) {
		return splitCSV(target, SEPARETOR_TAB, QUOTE_STRING_DOUBLE_QUOTE);
	}

	public static String[][] splitCSV(String target, char separator,
			char quotechar) {
		return splitCSV(new StringReader(target), separator, quotechar);
	}

	private static String[][] splitCSV(Reader reader, char separator,
			char quotechar) {
		ArrayList<String[]> retList = new ArrayList<String[]>();

		try {
			CSVReader csv_reader = new CSVReader(reader, separator, quotechar);
			String[] line = null;
			for (int i = 0; (line = csv_reader.readNext()) != null; i++) {
				if (log.isDebugEnabled()) {
					log.debug(String.format("[%03d]%s", i, line));
				}
				retList.add(line);
			}
		} catch (Exception e) {
			log.fatal(StringUtil.EMPTY_STRING, e);
		}

		return retList.toArray(new String[retList.size()][]);
	}

}
