package hiro.yoshioka.sdh;

import hiro.yoshioka.util.StringUtil;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringRecordDataHolder implements Serializable {
	private static final long serialVersionUID = 2584643902488450916L;

	protected transient Log log = LogFactory.getLog(this.getClass());

	/** L[ێpz */
	protected String[] key;

	protected List<StringRecordData[]> list = new ArrayList<StringRecordData[]>();

	/**
	 * @param argNames
	 * @throws NullPointerException
	 */
	public StringRecordDataHolder(String[] argNames)
			throws NullPointerException {
		key = argNames;
	}

	public StringRecordDataHolder() {
	}

	public int getRowCount() {
		return list.size();
	}

	int getIndexByName(String name) {
		for (int i = 0; i < key.length; i++) {
			if (key[i].equalsIgnoreCase(name)) {
				return i;
			}
		}
		return -1;
	}

	protected StringRecordData[] createEmptyRow() {
		StringRecordData[] ret = new StringRecordData[key.length];
		for (int i = 0; i < ret.length; i++) {
			ret[i] = new StringRecordData(StringUtil.EMPTY_STRING);
		}
		return ret;
	}

	public synchronized void addColumn(String headerTitle, String[] columnDatum) {
		key = Arrays.copyOf(key, key.length + 1);
		key[key.length - 1] = headerTitle;

		int loopSize = list.size();
		for (int i = 0; i < loopSize; i++) {
			StringRecordData[] line = list.get(i);
			line = Arrays.copyOf(line, line.length + 1);
			if (columnDatum.length > i) {
				line[line.length - 1] = new StringRecordData(columnDatum[i]);
			} else {
				line[line.length - 1] = new StringRecordData(
						StringUtil.EMPTY_STRING);
			}
			list.remove(i);
			list.add(i, line);
		}
	}

	public void addRow(StringRecordData[] datas) {
		list.add(datas);
	}

	protected StringRecordData[] createNewIndexOf(String[] datas, int f, int l) {
		String[] newdata = new String[l - f + 1];

		for (int i = 0, j = f; i < newdata.length; i++, j++) {
			newdata[i] = datas[j];
		}
		return StringRecordData.createStringRecordData(newdata);
	}

	public void addEmptyRow() {
		list.add(createEmptyRow());
	}

	public void addRow(String[] datas) {
		addRow(StringRecordData.createStringRecordData(datas));
	}

	public String[] getRow(int row) {
		StringRecordData[] data = (StringRecordData[]) list.get(row);
		String[] ret = new String[data.length];
		for (int i = 0; i < data.length; i++) {
			ret[i] = data[i].getString();
		}
		return ret;
	}

	public StringRecordData[] getStringRecordRow(int row) {
		return (StringRecordData[]) list.get(row);
	}

	public String getStringData(int row, String key) {
		String[] rowData = getRow(row);
		return rowData[getIndexByName(key)];
	}

	public void replaceStringData(int row, String key, String value) {
		StringRecordData[] rowData = getStringRecordRow(row);
		rowData[getIndexByName(key)].setString(value);
	}

	public int getIntData(int row, int index) {
		String[] rowData = getRow(row);
		try {
			return Integer.parseInt(rowData[index]);
		} catch (NumberFormatException e) {
			log.debug("f[^ls\ " + row + "s [" + rowData[index] + "]");
		}
		return 0;
	}

	public int getIntData(int row, String key) {
		return getIntData(row, getIndexByName(key));
	}

	public String[][] getStringData() {
		int cnt = getRowCount();
		String[][] ret = new String[cnt][key.length];
		for (int i = 0; i < cnt; i++) {
			ret[i] = getRow(i);
		}
		return ret;
	}

	public StringRecordData[][] getStringRecordData() {
		int cnt = getRowCount();
		StringRecordData[][] ret = new StringRecordData[cnt][key.length];
		for (int i = 0; i < cnt; i++) {
			ret[i] = getStringRecordRow(i);
		}
		return ret;
	}

	public StringRecordPairData getPair(int row, int col) {
		return getStringRecordRow(row)[col].getPair();
	}

	public void setPair(int row, int col, StringRecordPairData pair) {
		StringRecordData data = ((StringRecordData[]) list.get(row))[col];
		data.setPair(pair);
	}

	public void setPairAll(StringRecordPairData pair) {
		for (int row = 0; row < list.size(); row++) {
			for (int col = 0; col < key.length; col++) {
				setPair(row, col, pair.createCopy());
			}
		}
	}

	// **************************************************************************
	// **
	/**
	 * L[̒g͂ȂƁBI ̂jłȂ悤ɏCBBB
	 * 
	 * @return L[
	 */
	// **************************************************************************
	// **
	public String[] getKey() {
		return key;
	}

	public void dumpPair() {
		for (int i = 0; i < getRowCount(); i++) {
			StringRecordData[] datas = getStringRecordRow(i);
			for (int j = 0; j < datas.length; j++) {
				System.out.print(datas[j].getPair());
			}
			System.out.println();
		}
	}

	/**
	 * @param index
	 * @param i
	 * @param text
	 */
	public void changeString(int index, int i, String text) {
		StringRecordData[] data = (StringRecordData[]) list.get(index);
		data[i].setString(text);
	}

	/**
	 * height:200px, width:420px
	 * 
	 * @param maxRow
	 * @return
	 */
	public String toHtmlString(int maxRow) {
		return toHtmlString(maxRow, 200, 420);
	}

	public String toHtmlString(int maxRow, int height, int width) {
		StringBuilder buf = new StringBuilder();
		buf.append("<div style=\"");
		if (getRowCount() > 1) {
			buf.append("height:");
			buf.append(height);
			buf.append("px; ");
		}
		buf.append("width:");
		buf.append(width);
		buf.append("px; overflow:auto;\">");
		buf.append(StringUtil.LINE_SEPARATOR);
		buf.append("<table border=1><thead>");
		buf.append(StringUtil.LINE_SEPARATOR);
		buf.append("<tr>");
		for (int i = 0; i < getKey().length; i++) {
			buf.append("<th>").append(StringUtil.esc(getKey()[i])).append(
					"</th>");
		}
		buf.append("</tr>");
		buf.append(StringUtil.LINE_SEPARATOR);
		buf.append("</thead>");
		buf.append(StringUtil.LINE_SEPARATOR);

		if (getRowCount() > 0) {
			buf.append("<tbody>");
			for (int j = 0; j < getRowCount(); j++) {
				if (j % 2 == 1) {
					buf.append("<tr class=\"odd\">");
				} else {
					buf.append("<tr>");
				}
				String[] data = getRow(j);
				for (int i = 0; i < data.length; i++) {
					buf.append("<td>").append(StringUtil.esc(data[i])).append(
							"</td>");
				}

				if (j >= maxRow) {
					buf.append("</tr>");
					buf.append(StringUtil.LINE_SEPARATOR);
					buf.append("<tr>");
					buf.append("<td colspan=\"").append(data.length).append(
							"\">   --- and more ---   </td>");
					buf.append("</tr>");
					buf.append(StringUtil.LINE_SEPARATOR);
					break;
				}
				buf.append("</tr>");
				buf.append(StringUtil.LINE_SEPARATOR);
			}
			buf.append("</tbody>");
		}
		buf.append("</table>");
		buf.append("</div>");
		return buf.toString();
	}

	public String toString(int maxRow) {
		StringBuilder buf = new StringBuilder();
		for (int i = 0; i < getKey().length; i++) {
			buf.append(getKey()[i]).append("\t");
		}
		if (buf.length() > 0) {
			buf.setLength(buf.length() - 1);
		}
		if (getRowCount() > 0) {
			for (int j = 0; j < getRowCount(); j++) {
				buf.append(StringUtil.LINE_SEPARATOR);
				String[] data = getRow(j);
				for (int i = 0; i < data.length; i++) {
					buf.append(data[i]).append("\t");
				}
				if (buf.length() > 0) {
					buf.setLength(buf.length() - 1);
				}
				if (j >= maxRow) {
					buf.append(StringUtil.LINE_SEPARATOR);
					buf.append("   --- and more ---   ");
					break;
				}
			}
		}
		buf.append(StringUtil.LINE_SEPARATOR);
		buf.append("row count=").append(getRowCount());
		return buf.toString();
	}

	public String toString() {
		return toString(Integer.MAX_VALUE);
	}

	/**
	 * @param same
	 */
	public void moveTail(int index) {
		list.add(list.remove(index));
	}

	private void readObject(ObjectInputStream in) throws IOException,
			ClassNotFoundException {
		in.defaultReadObject(); // Figure͈ȂRXgN^ŏ
		log = LogFactory.getLog(this.getClass());
	}

}