package hiro.yoshioka.sdh;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringDataHolder {
	// ****************************************************************************
	// publictB[h
	// ****************************************************************************
	/** NG */
	public static final int NG_VALUE = -1;

	// ****************************************************************************
	// privatetB[h
	// ****************************************************************************
	/** f[^ێpnbV}bv */
	private Map<String, List<String>> hash = new HashMap<String, List<String>>();

	/** L[ێpz */
	String[] key;

	// ****************************************************************************
	// RXgN^
	// ****************************************************************************
	// ****************************************************************************
	/**
	 * nbVe[ũL[ݒpRXgN^
	 * 
	 * @param argNames
	 *            L[
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public StringDataHolder(String[] argNames) throws NullPointerException {
		if (argNames == null) {
			throw new NullPointerException("L[NULLł");
		}
		key = argNames;
		for (int iName = 0; iName < argNames.length; iName++) {
			if (argNames[iName] == null) {
				throw new NullPointerException("L[NULLł " + argNames);
			}
			hash.put(argNames[iName], new ArrayList<String>());
		}
	}

	// ****************************************************************************
	// public\bh
	// ****************************************************************************
	// ****************************************************************************
	/**
	 * Xg̎w肳ꂽʒuɁAw肳ꂽvf}܂B <BR>
	 * ݂̈ʒuɂvfƌ㑱̗vf͉EɈړ܂ <BR>
	 * (CfbNXl 1 Z)B
	 * 
	 * @param argName
	 *            L[
	 * @param argIndex
	 *            CfbNX
	 * @param argValue
	 *            l
	 * @throws IndexOutOfBoundsException
	 *             CfbNX͈͊Ȍꍇ (argIndex < 0 || argIndex > size())
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public void addData(String argName, int argIndex, String argValue)
			throws IndexOutOfBoundsException, NullPointerException {
		if (argName == null) {
			throw new NullPointerException("L[NULLł");
		}
		List<String> list = hash.get(argName);
		try {
			list.add(argIndex, argValue);
		} catch (IndexOutOfBoundsException e) {
			throw new IndexOutOfBoundsException("CfbNX͈͊O " + argIndex);
		}
	}

	// ****************************************************************************
	/**
	 * Ōɕf[^ǉ܂B
	 * 
	 * @param argName
	 *            L[
	 * @param argValue
	 *            l
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public void setData(String argName, String argValue)
			throws NullPointerException {
		if (argName == null) {
			throw new NullPointerException("L[NULLł");
		}
		(hash.get(argName)).add(argValue);
	}

	// ****************************************************************************
	/**
	 * wʒuɕf[^ݒ肵܂B
	 * 
	 * @param argName
	 *            L[
	 * @param argIndex
	 *            CfbNX
	 * @param argValue
	 *            l
	 * @throws IndexOutOfBoundsException
	 *             sȃCfbNXw̏ꍇ
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public void setData(String argName, int argIndex, String argValue)
			throws IndexOutOfBoundsException, NullPointerException {
		if (argName == null) {
			throw new NullPointerException("L[NULLł");
		}
		List<String> list = hash.get(argName);
		if (argIndex < 0 || list.size() < argIndex) {
			throw new IndexOutOfBoundsException("CfbNX͈͊O " + argIndex);
		} else if (list.size() == argIndex) {
			list.add(argValue);
		} else {
			list.set(argIndex, argValue);
		}
	}

	// ****************************************************************************
	/**
	 * ŏ̕f[^擾܂B
	 * 
	 * @param argName
	 *            L[
	 * @return l
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public String getData(String argName) throws NullPointerException {
		if (argName == null) {
			throw new NullPointerException("L[NULLł");
		}
		List<String> list = hash.get(argName);
		return list.get(0);
	}

	public String[][] getAllData() {
		int cnt = getDataCount(key[0]);
		String[][] ret = new String[cnt][key.length];
		for (int irow = 0; irow < cnt; irow++) {
			for (int i = 0; i < key.length; i++) {
				ret[irow][i] = getData(key[i], irow);
			}
		}
		return ret;
	}

	// ****************************************************************************
	/**
	 * w肵ʒu̕f[^擾܂B
	 * 
	 * @param argName
	 *            L[
	 * @param argIndex
	 *            CfbNX
	 * @return l
	 * @throws IndexOutOfBoundsException
	 *             sȃCfbNXw̏ꍇ
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public String getData(String argName, int argIndex)
			throws IndexOutOfBoundsException, NullPointerException {
		if (argName == null) {
			throw new NullPointerException("L[NULLł");
		}
		List<String> list = hash.get(argName);
		try {
			return list.get(argIndex);
		} catch (IndexOutOfBoundsException e) {
			throw new IndexOutOfBoundsException("CfbNX͈͊O " + argIndex);
		}
	}

	public int getMaximumLength(String argName) {
		List<String> list = hash.get(argName);
		int max = 0;
		for (int i = 0; i < list.size(); i++) {
			String value = list.get(i);
			if (max < value.length()) {
				max = value.length();
			}
		}
		return max;
	}

	// ****************************************************************************
	/**
	 * wL[̗vf擾܂B
	 * 
	 * @param argName
	 *            L[
	 * @return vf
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public int getDataCount(String argName) throws NullPointerException {
		if (argName == null) {
			throw new NullPointerException("L[NULLł");
		}
		List list = hash.get(argName);
		return list.size();
	}

	// ****************************************************************************
	/**
	 * ̎wL[̗vfrɕԋp܂B  <BR>
	 * @KEY {"K1","K2"} VALUE {{"1","2"},{"3","4"}} <BR>
	 * ̏Ԃ{"K1","K2"}w肵ꍇ2ԂB <BR>
	 * AKEY {"K1","K2","K3"} VALUE {{"1","2"},{"4"},{"5","5","3"}} <BR>
	 * ̏Ԃ{"K1","K2"}w肵ꍇ-1ԂB <BR>
	 * BKEY {"K1","K4","K7"} VALUE {{"1","2"},{"4"},{"5","5","3"}} <BR>
	 * ̏Ԃ{"K1","K2"}w肵ꍇNullPointerExceptionԂB
	 * 
	 * @param argName
	 *            L[
	 * @return -1  wL[vf
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public int getDataCount(String[] argName) throws NullPointerException {
		if (argName == null || argName.length <= 0) {
			return NG_VALUE;
		}
		int lastCnt = getDataCount(argName[0]);
		for (int i0 = 1; i0 < argName.length; i0++) {
			if (lastCnt != getDataCount(argName[i0])) {
				return NG_VALUE;
			}
		}
		return lastCnt;
	}

	// ****************************************************************************
	/**
	 * wL[̗vfSč폜܂B
	 * 
	 * @param argName
	 *            L[
	 */
	// ****************************************************************************
	public void initData(String argName) {
		List list = hash.get(argName);
		if (list == null) {
			return;
		}
		list.clear();
	}

	// ****************************************************************************
	/**
	 * SẴL[̗vfSč폜܂B
	 */
	// ****************************************************************************
	public void initData() {
		// nbVe[ũL[ɑΉlSĎ擾B
		Iterator<String> ite = hash.keySet().iterator();
		while (ite.hasNext()) {
			initData(ite.next()); // L[l擾đSvf폜
		}
	}

	// ****************************************************************************
	/**
	 * ŕێĂHashMap IuWFNg̕\Ԃ܂B
	 * 
	 * @return \
	 */
	// ****************************************************************************
	public String toString() {
		return hash.toString();
	}

	// ****************************************************************************
	/**
	 * wL[Ɏw肳ꂽlꍇ true Ԃ܂
	 * 
	 * @param argName
	 *            L[
	 * @param argValue
	 *            l
	 * @return true/false
	 */
	// ****************************************************************************
	public boolean contains(String argName, String argValue) {
		List list = hash.get(argName);
		if (list == null) {
			return false;
		}
		return list.contains(argValue);
	}

	// ****************************************************************************
	/**
	 * equals \bhgēǂ𔻒肵ȂAwL[ɑ΂ <BR>
	 * w肳ꂽlƓe̗vf擪猟܂B
	 * 
	 * @param argName
	 *            L[
	 * @param argValue
	 *            l
	 * @return XgňŏɌCfbNXB <BR>
	 *         IuWFNgȂꍇ -1
	 */
	// ****************************************************************************
	public int indexOf(String argName, String argValue) {
		List list = hash.get(argName);
		if (list == null) {
			return NG_VALUE;
		}
		return list.indexOf(argValue);
	}

	// ****************************************************************************
	/**
	 * wL[ɑ΂vfȂǂ𔻒肵܂
	 * 
	 * @param argName
	 *            L[
	 * @return XgɗvfȂꍇ trueAłȂꍇ false
	 */
	// ****************************************************************************
	public boolean isEmpty(String argName) {
		List list = hash.get(argName);
		if (list == null) {
			return false;
		}
		return list.isEmpty();
	}

	// ****************************************************************************
	/**
	 * wL[̃Xg̎w肳ꂽʒuvf폜܂B <BR>
	 * āA㑱̗vfɈړA <BR>
	 * ꂼ̃CfbNX 1 Z܂B
	 * 
	 * @param argName
	 *            L[
	 * @param argIndex
	 *            CfbNX
	 * @return Xg폜
	 * @throws IndexOutOfBoundsException
	 *             sȃCfbNXw̏ꍇ
	 * @throws NullPointerException
	 *             L[NULL܂܂ꍇ
	 */
	// ****************************************************************************
	public String remove(String argName, int argIndex)
			throws IndexOutOfBoundsException, NullPointerException {
		if (argName == null) {
			throw new NullPointerException("L[NULLł");
		}
		try {
			return hash.get(argName).remove(argIndex);
		} catch (IndexOutOfBoundsException e) {
			throw new IndexOutOfBoundsException("CfbNX͈͊O " + argIndex);
		}
	}

	// ****************************************************************************
	/**
	 * wL[̎w肳ꂽIuWFNgXgōŌɌCfbNXԂ܂B
	 * 
	 * @param argName
	 *            L[
	 * @param argValue
	 *            l
	 * @return wL[̃XgŎw̃IuWFNgƈvŌ ̃CfbNXB <BR>
	 *         wL[̎wIuWFNgȂꍇ -1
	 */
	// ****************************************************************************
	public int lastIndexOf(String argName, String argValue) {
		List list = hash.get(argName);
		if (list == null) {
			return NG_VALUE;
		}
		return list.lastIndexOf(argValue);
	}

	// ****************************************************************************
	/**
	 * L[̒g͂ȂƁBI ̂jłȂ悤ɏCBBB
	 * 
	 * @return L[
	 */
	// ****************************************************************************
	public String[] getKey() {
		return key;
	}
}