package hiro.yoshioka.extract;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.ZipEntry;

import javax.imageio.ImageIO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageArchiveManager extends ArchiveManager {
	private static Log log = LogFactory.getLog(ImageArchiveManager.class);
	private static final String IMG_EXTENTION;
	static {
		StringBuilder buf = new StringBuilder(".*(");
		String[] readerNames = ImageIO.getReaderFormatNames();
		for (int i = 0; i < readerNames.length; i++) {
			buf.append(readerNames[i]).append("|");
		}
		buf.setLength(buf.length() - 1);
		buf.append(")");
		IMG_EXTENTION = buf.toString();
	}

	public EntryInfo lookupEntrys(File dir) throws FileNotFoundException,
			IOException {
		if (log.isDebugEnabled()) {
			log.debug("dir[" + dir + "] START");
		}
		EntryInfo ret = super.lookupEntrys(dir, IMG_EXTENTION);
		return ret;
	}

	public static void main(String[] args) {
		try {
			ImageArchiveManager obj = new ImageArchiveManager();
			EntryInfo ei = obj.lookupEntrys(new File("C:/tmp/bb.zip"));
			ZipEntry[] zs = ei.fZipEntries;
			for (int i = 0; i < zs.length; i++) {
				System.out.println("  " + zs[i].getName() + "/"
						+ zs[i].getCompressedSize() + "/" + zs[i].getSize());
			}

			System.out.println("done...");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
