package hiro.yoshioka.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;

public class RDHTimeSeriesUtil {
	static Log log = LogFactory.getLog(RDHTimeSeriesUtil.class);

	// 1 [2006]
	// 2 [06]
	// 3 [08]
	public static final Pattern FORMAT_DATE = Pattern
			.compile("(\\d\\d\\d\\d).(\\d\\d).(\\d\\d)");
	public static final Pattern FORMAT_DATE2 = Pattern
			.compile("(\\d\\d).(\\d\\d).(\\d\\d\\d\\d)");

	private static void setRenderer(XYItemRenderer renderer) {
		if (renderer instanceof XYLineAndShapeRenderer) {
			XYLineAndShapeRenderer rr = (XYLineAndShapeRenderer) renderer;
			rr.setShapesVisible(true);
			rr.setDrawOutlines(true);
			rr.setUseFillPaint(true);
			rr.setFillPaint(Color.white);
			// rr.setSeriesStroke(0, new BasicStroke(2F));
			// rr.setSeriesOutlineStroke(0, new BasicStroke(2.0F));
			// rr.setSeriesShape(0, new java.awt.geom.Ellipse2D.Double(-4D, -4D,
			// 8D, 8D));
		}
	}

	private static JFreeChart createChart(TimeChartInfo info) {
		boolean hoge = false;

		JFreeChart chart = null;
		MyXYDataset[] dataset = null;
		if (!info.simple) {
			dataset = createDataset(info);
			chart = ChartFactory.createTimeSeriesChart(info.title, info.rdh
					.getKey()[info.dateIndex], // x-axis label
					info.rdh.getKey()[info.valueIndexes[0]], dataset[0], // data
					true, // create legend?
					true, // generate tooltips?
					false // generate URLs?
					);
		} else {
			chart = ChartFactory.createTimeSeriesChart(info.title,
					info.rdh.getKey()[info.dateIndex], // x-axis label
					info.rdh.getKey()[info.valueIndexes[0]],
					createDatasetSimple(info), // data
					true, // create legend?
					true, // generate tooltips?
					false // generate URLs?
					);
		}

		chart.setBackgroundPaint(Color.white);

		XYPlot plot = (XYPlot) chart.getPlot();
		/* J[\ʒuŉ̕⏕ */
		plot.setDomainCrosshairVisible(true);
		/* J[\ʒuŏc̕⏕ */
		plot.setRangeCrosshairVisible(true);

		plot.setOrientation(PlotOrientation.VERTICAL);
		plot.setDomainGridlinePaint(Color.lightGray);
		plot.setRangeGridlinePaint(Color.GRAY);

		// plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
		NumberAxis nAxis = (NumberAxis) plot.getRangeAxis();
		nAxis.setNumberFormatOverride(new DecimalFormat("##0.##"));
		// nAxis.setAutoRange(true);

		XYItemRenderer renderer = plot.getRenderer();
		setRenderer(renderer);

		BasicStroke stroke = new BasicStroke(2F, 1, 1);
		renderer.setSeriesStroke(0, stroke);
		if (!info.simple) {
			for (int i = 1; i < info.valueIndexes.length; i++) {
				plot.setDataset(i, dataset[i]);

				plot.mapDatasetToRangeAxis(i, i);
				XYLineAndShapeRenderer renderer3 = new XYLineAndShapeRenderer();
				// renderer3.setSeriesPaint(0, colors[i % colors.length]);
				renderer3.setSeriesStroke(0, stroke);
				renderer3.setFillPaint(Color.white);
				plot.setRenderer(i, renderer3);
				setRenderer(renderer3);
				NumberAxis axis3 = new NumberAxis(
						info.rdh.getKey()[info.valueIndexes[i]]);
				axis3.setPositiveArrowVisible(true);
				axis3.setAutoRangeIncludesZero(false);
				axis3.setNumberFormatOverride(new DecimalFormat("##0.##"));
				plot.setRangeAxis(i, axis3);

			}

		}

		XYItemRenderer r = plot.getRenderer();
		// if (r instanceof XYLineAndShapeRenderer) {
		// XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer) r;
		// renderer.setBaseShapesVisible(true);
		// renderer.setBaseShapesFilled(true);
		// }

		// DateAxis axis = (DateAxis) plot.getDomainAxis();
		// axis.setDateFormatOverride(new SimpleDateFormat("MM/dd"));

		return chart;

	}

	public static XYDataset createDatasetSimple(TimeChartInfo info) {
		if (log.isDebugEnabled()) {
			log.debug("info.valueIndexes.length[" + info.valueIndexes.length
					+ "]");
		}
		TimeSeriesCollection ret = new TimeSeriesCollection();

		switch (info.mode) {
		case TimeChartInfo.MODE_TIME:
			for (int i = 0; i < info.valueIndexes.length; i++) {
				int idx = info.valueIndexes[i];

				TimeSeries s1 = new TimeSeries(info.rdh.getKey()[idx],
						Second.class);

				for (int row = 0; row < info.rdh.getRowCount(); row++) {
					Second second = null;
					String date = info.rdh.getStringRecordRow(row)[info.dateIndex]
							.getString();
					int date_div = -1;
					if (log.isDebugEnabled()) {
						log.debug("date[" + date + "]");
					}

					String[] hms = date.trim().split(":");
					Calendar cal = GregorianCalendar.getInstance();
					if (hms.length == 3) {
						cal.set(Calendar.HOUR, Integer.parseInt(hms[0]));
						cal.set(Calendar.MINUTE, Integer.parseInt(hms[1]));
						cal.set(Calendar.SECOND, Integer.parseInt(hms[2]));
					} else {
						cal.set(Calendar.HOUR, Integer.parseInt(hms[0]));
						cal.set(Calendar.MINUTE, Integer.parseInt(hms[1]));
						cal.set(Calendar.SECOND, 0);
					}
					second = new Second(cal.getTime());
					String val = info.rdh.getStringRecordRow(row)[idx]
							.getString();
					try {
						s1.add(second, Double.parseDouble(val));
					} catch (NumberFormatException e) {
						s1.add(second, 0);
					}
				}
				ret.addSeries(s1);
			}
			break;
		case TimeChartInfo.MODE_DAY:
			for (int i = 0; i < info.valueIndexes.length; i++) {
				int idx = info.valueIndexes[i];
				MyXYDataset dataset = new MyXYDataset();
				TimeSeries s1 = new TimeSeries(info.rdh.getKey()[idx],
						Day.class);

				for (int row = 0; row < info.rdh.getRowCount(); row++) {
					Day day = null;
					String date = info.rdh.getStringRecordRow(row)[info.dateIndex]
							.getString();
					int date_div = -1;
					if (log.isDebugEnabled()) {
						log.debug("date[" + date + "]");
					}
					try {
						date_div = Integer.parseInt(date.trim());
						Calendar cal = GregorianCalendar.getInstance();
						cal.add(Calendar.DATE, date_div);
						Date dd = cal.getTime();
						day = new Day(dd);
					} catch (Exception e) {
						Matcher m = FORMAT_DATE.matcher(date);
						Matcher m2 = FORMAT_DATE2.matcher(date);
						if (m.find()) {
							day = new Day(Integer.parseInt(m.group(3)), Integer
									.parseInt(m.group(2)), Integer.parseInt(m
									.group(1)));
						} else if (m2.find()) {
							day = new Day(Integer.parseInt(m2.group(2)),
									Integer.parseInt(m2.group(1)), Integer
											.parseInt(m2.group(3)));
						}
					}

					String val = info.rdh.getStringRecordRow(row)[idx]
							.getString();
					try {
						s1.add(day, Double.parseDouble(val));
					} catch (NumberFormatException e) {
						s1.add(day, 0);
					}
				}
				ret.addSeries(s1);
			}
			break;
		case TimeChartInfo.MODE_MONTH:
			break;
		case TimeChartInfo.MODE_YEAR:
			break;
		}

		return ret;
	}

	public static MyXYDataset[] createDataset(TimeChartInfo info) {
		if (log.isDebugEnabled()) {
			log.debug("start info=" + info);
		}

		ArrayList<MyXYDataset> datasetList = new ArrayList<MyXYDataset>();
		double d = 0;
		switch (info.mode) {
		case TimeChartInfo.MODE_TIME:
			for (int i = 0; i < info.valueIndexes.length; i++) {
				int idx = info.valueIndexes[i];
				MyXYDataset dataset = new MyXYDataset();
				TimeSeries s1 = new TimeSeries(info.rdh.getKey()[idx],
						Second.class);

				for (int row = 0; row < info.rdh.getRowCount(); row++) {
					Second second = null;
					String date = info.rdh.getStringRecordRow(row)[info.dateIndex]
							.getString();
					int date_div = -1;

					String[] hms = date.trim().split(":");
					Calendar cal = GregorianCalendar.getInstance();
					if (hms.length == 3) {
						cal.set(Calendar.HOUR, Integer.parseInt(hms[0]));
						cal.set(Calendar.MINUTE, Integer.parseInt(hms[1]));
						cal.set(Calendar.SECOND, Integer.parseInt(hms[2]));
					} else {
						cal.set(Calendar.HOUR, Integer.parseInt(hms[0]));
						cal.set(Calendar.MINUTE, Integer.parseInt(hms[1]));
						cal.set(Calendar.SECOND, 0);
					}
					second = new Second(cal.getTime());
					try {
						String val = info.rdh.getStringRecordRow(row)[idx]
								.getString();
						if (val.length() == 0) {
							if (log.isDebugEnabled()) {
								log.debug("[" + row + "/" + idx
										+ "] empty String continue;");
							}

							continue;
						}
						if (log.isDebugEnabled()) {
							log.debug("day[" + second + "] d[" + d + "]");
						}
						d = Double.parseDouble(val);
						s1.add(second, d);
					} catch (NumberFormatException e) {
						e.printStackTrace();
					}
					if (d > dataset.max || row == 0) {
						dataset.max = d;
					}
					if (d < dataset.min || row == 0) {
						dataset.min = d;
					}
				}
				datasetList.add(dataset);
				dataset.addSeries(s1);
			}
			break;
		case TimeChartInfo.MODE_DAY:
			for (int i = 0; i < info.valueIndexes.length; i++) {
				int idx = info.valueIndexes[i];
				MyXYDataset dataset = new MyXYDataset();
				TimeSeries s1 = new TimeSeries(info.rdh.getKey()[idx],
						Day.class);

				for (int row = 0; row < info.rdh.getRowCount(); row++) {
					Day day = null;
					String date = info.rdh.getStringRecordRow(row)[info.dateIndex]
							.getString();
					int date_div = -1;

					try {
						date_div = Integer.parseInt(date.trim());
						Calendar cal = GregorianCalendar.getInstance();
						cal.add(Calendar.DATE, date_div);
						Date dd = cal.getTime();
						day = new Day(dd);
					} catch (Exception e) {
						Matcher m = FORMAT_DATE.matcher(date);
						Matcher m2 = FORMAT_DATE2.matcher(date);
						if (m.find()) {
							day = new Day(Integer.parseInt(m.group(3)), Integer
									.parseInt(m.group(2)), Integer.parseInt(m
									.group(1)));
						} else if (m2.find()) {
							day = new Day(Integer.parseInt(m2.group(2)),
									Integer.parseInt(m2.group(1)), Integer
											.parseInt(m2.group(3)));
						}
					}

					try {
						String val = info.rdh.getStringRecordRow(row)[idx]
								.getString();
						if (val.length() == 0) {
							if (log.isDebugEnabled()) {
								log.debug("[" + row + "/" + idx
										+ "] empty String continue;");
							}

							continue;
						}
						if (log.isDebugEnabled()) {
							log.debug("day[" + day + "] d[" + d + "]");
						}
						d = Double.parseDouble(val);
						s1.add(day, d);
					} catch (NumberFormatException e) {
						e.printStackTrace();
					}
					if (d > dataset.max || row == 0) {
						dataset.max = d;
					}
					if (d < dataset.min || row == 0) {
						dataset.min = d;
					}
				}
				datasetList.add(dataset);
				dataset.addSeries(s1);
			}
			break;
		case TimeChartInfo.MODE_MONTH:
			break;
		case TimeChartInfo.MODE_YEAR:
			break;
		}

		if (log.isDebugEnabled()) {
			log.debug("end datasetList=" + datasetList);
		}
		return datasetList.toArray(new MyXYDataset[datasetList.size()]);
	}

	public static ChartComposite createChartComposite(Composite parent,
			ChartInfo info) {
		JFreeChart chart = createChart((TimeChartInfo) info);
		// chart.setDisplayToolTips(true);
		// chart.setHorizontalAxisTrace(false);
		// chart.setVerticalAxisTrace(false);

		return new ChartComposite(parent, SWT.NONE, chart, true);
	}

}
