package hiro.yoshioka.chart;

import hiro.yoshioka.sdh.ResultSetDataHolder;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.util.Rotation;

public class RDHPieChartUtil {

	private static JFreeChart createChart(PieChartInfo info) {
		DefaultPieDataset dataset = new DefaultPieDataset();
		ResultSetDataHolder rdh = info.rdh;
		if (info.topCout > 0) {
			TreeMap<Double, HashSet<String>> topMap = new TreeMap<Double, HashSet<String>>();

			double total = 0;
			for (int i = 0; i < rdh.getRowCount(); i++) {
				String[] row = rdh.getRow(i);

				try {
					Double d = new Double(row[info.valueIndex]);
					HashSet<String> set = topMap.get(d);
					if (set == null) {
						set = new HashSet<String>();
						topMap.put(d, set);
					}
					set.add(row[info.titleIndex]);
					total += d.doubleValue();
				} catch (Exception e) {
				}
			}
			int cnt = 0;

			for (Iterator<Double> ite = topMap.descendingKeySet().iterator(); ite
					.hasNext()
					&& cnt < info.topCout; cnt++) {
				Double d = ite.next();
				StringBuffer buf = new StringBuffer();

				String[] setArray = topMap.get(d).toArray(new String[0]);
				for (int j = 0; j < setArray.length; j++) {
					if (j < 3) {
						if (j > 0) {
							buf.append(",");
						}
						buf.append(setArray[j]);
					} else if (j == 3) {
						buf.append("..");
					} else {
					}
					total -= d.doubleValue();
				}
				dataset.setValue(buf.toString() + ":" + d, d);
			}
			if (info.topCout < topMap.size()) {
				dataset.setValue("others.." + ":" + total, total);
			}

		} else {
			for (int i = 0; i < rdh.getRowCount(); i++) {
				String[] row = rdh.getRow(i);
				double d = 0;
				try {
					d = Double.parseDouble(row[info.valueIndex]);
				} catch (Exception e) {
				}
				dataset.setValue(row[info.titleIndex] + ":" + d, d);
			}
		}

		JFreeChart chart = ChartFactory.createPieChart3D(info.title, // chart
				// title
				dataset, // data
				true, // include legend
				true, false);

		chart.setBorderVisible(true);
		final PiePlot3D plot = (PiePlot3D) chart.getPlot();
		plot.setBackgroundAlpha(0.6f);
		// plot.setStartAngle(290);
		plot.setCircular(true);
		plot.setDirection(Rotation.CLOCKWISE);
		plot.setForegroundAlpha(0.5f);
		plot.setNoDataMessage("No data to display");

		return chart;
	}

	public static ChartComposite createChartComposite(Composite parent,
			ChartInfo info) {
		JFreeChart chart = createChart((PieChartInfo) info);

		return new ChartComposite(parent, SWT.NONE, chart, true);
	}

}
