package hiro.yoshioka.chart;

import hiro.yoshioka.util.logging.LogUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LogUtilTester {
	static final Log log = LogFactory.getLog(LogUtilTester.class);

	public static void main(String[] args) {
		Display display = new Display();

		Shell shell = new Shell(display);
		shell.setLayout(new org.eclipse.swt.layout.GridLayout(1, false));

		StyledText text = new StyledText(shell, SWT.NONE);
		text.setLayoutData(new GridData(GridData.FILL_BOTH));

		Button bt = new Button(shell, SWT.PUSH);
		bt.setText("message ");
		bt.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				log.trace("trace");
				log.debug("debug");
				log.info("info");
				log.warn("warn");
				log.error("error");
				log.fatal("fatal");
			}
		});

		LogUtil.connect(text);
		String[] levels = LogUtil.A_LEVELS;

		LogUtil.setColorLevel(levels[2], shell.getDisplay().getSystemColor(
				SWT.COLOR_DARK_GREEN), shell.getDisplay().getSystemColor(
				SWT.COLOR_GREEN));

		LogUtil.setColorLevel(levels[4], shell.getDisplay().getSystemColor(
				SWT.COLOR_DARK_BLUE), shell.getDisplay().getSystemColor(
				SWT.COLOR_BLUE));

		LogUtil.setLevel(levels[5]);

		shell.open();

		log.trace("trace");
		log.debug("debug");
		log.info("info");
		log.warn("warn");
		log.error("error");
		log.fatal("fatal");

		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		display.dispose();

	}

}
