package hiro.yoshioka.chart;

import hiro.yoshioka.sdh.RDHTableViewer;
import hiro.yoshioka.sdh.ResultSetDataHolder;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jfree.experimental.chart.swt.ChartComposite;

public class JFreeChartTester {

	public static void main(String[] args) {
		Display display = new Display();

		Shell shell = new Shell(display);
		shell.setLayout(new GridLayout(2, true));

		RDHTableViewer v2 = new RDHTableViewer(shell);
		v2.setSupportChart(true);
		v2.getTable().setLayoutData(new GridData(GridData.FILL_BOTH));
		v2.setInputAdjustDatum(createModel());

		String[] params = new String[]{"1", "2,3,4,5","MODE_DAY"};
		TimeChartInfo info = new TimeChartInfo("scot", createModel2(),params );
		// PieChartInfo info = new PieChartInfo("scot", createModel(), 1, 4, 0);

		// ChartComposite ch = RDHPieChartUtil.createChartComposite(shell,
		// info);
		System.out.println("infooo=" + info);
		ChartComposite ch = RDHTimeSeriesUtil.createChartComposite(shell, info);
		ch.setLayoutData(new GridData(GridData.FILL_BOTH));

		shell.open();

		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}

		display.dispose();

	}

	private static ResultSetDataHolder createModel() {
		ResultSetDataHolder rdh = new ResultSetDataHolder(new String[] {
				"name", "job", "email", "use(%)" });
		rdh.addRow(new String[] { "i  am \n a   pen", "Schi\r\nn\r\nsdl",
				"tom.schindl@bestsolution.at", "100" });
		rdh.addRow(new String[] { "scott", "Bokowski",
				"Boris_Bokowski@ca.ibm.com", "57.98" });
		rdh.addRow(new String[] { "tomas", "Creasey", "Tod_Creasey@ca.ibm.com",
				"42" });
		rdh.addRow(new String[] { "hr", "Beaton", "wayne@eclipse.org", "23" });

		return rdh;
	}

	private static ResultSetDataHolder createModel2() {
		ResultSetDataHolder rdh = new ResultSetDataHolder(new String[] {
				"date", "weight", "high", "cm", "last" });
		rdh.addRow(new String[] { "02/01/1977", "60.3", "63.2", "5", "20" });
		rdh.addRow(new String[] { "02/04/1977", null, "73.2", "9", "20" });
		rdh.addRow(new String[] { "02/05/1977", null, "73.3", "5", "20" });
		rdh.addRow(new String[] { "02/06/1977", null, "73.3", "3", "20" });
		rdh.addRow(new String[] { "02/09/1977", "60.3", "73.2", "5", "20" });
		rdh.addRow(new String[] { "02/21/1977", "58.3", "73.3", "12", "20" });
		rdh.addRow(new String[] { "03/01/1977", "55.5", "73.1", "5", "20" });

		return rdh;
	}
}
