//
//  WOTranscript.java
//  WOGroovy
//

package wogroovy;

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import java.io.*;

public class WOTranscript extends ByteArrayOutputStream {
	public static WOTranscript defaultTranscript;
	
	public static WOTranscript defaultTranscript() {
		if (defaultTranscript == null)
			defaultTranscript = new WOTranscript();
		return defaultTranscript;
	}
	
	public static void setDefaultTranscript(WOTranscript transcript) {
		defaultTranscript = transcript;
	}
	
	public void show(Object object) {
		if (object != null) {
			try {
				write(object.toString().getBytes());
			} catch (IOException e) {
				NSLog.err.appendln("Can't write to transcript: " + e.getMessage());
			}
		}
	}
	
	public NSArray lines() {
		NSMutableArray lines = new NSMutableArray();
		String[] outputs = toString().split("\n");
		for (int i = 0; i < outputs.length; i++) {
			lines.addObject(outputs[i]);
		}
		return lines;
	}
}
