//
//  WOGroovyShell.java
//  WOGroovy
//

package wogroovy;

import com.webobjects.appserver.*;
import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import groovy.lang.*;
import org.codehaus.groovy.control.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class WOGroovyShell extends GroovyShell {

	public WOGroovyShell() {
		super();
	}
	
	public WOGroovyShell(Binding binding) {
		super(binding);
	}
	
	public static WOGroovyShell shellWithDefaultBinding() {
		return new WOGroovyShell(WOGroovyBinding.defaultBinding());
	}
	
	public Binding binding() {
		return getContext();
	}
	
	public Object propertyForKey(String key) {
		return getProperty(key);
	}
	
	public void setPropertyForKey(Object value, String key) {
		setProperty(key, value);
	}
	
	public Object objectForKey(String key) {
		return getVariable(key);
	}
	
	public void setObjectForKey(Object value, String key) {
		setVariable(key ,value);
	}
	
	public Object evaluateWithResourceNamed(String aResourceName,
											String aFrameworkName,
											NSArray aLanguageList)
		throws CompilationFailedException, IOException {
		try {
			InputStream in = WOApplication.application().resourceManager().
				inputStreamForResourceNamed(aResourceName,
											aFrameworkName,
											aLanguageList);
			return evaluate(in);
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}
	
	public Object evaluateWithContentOfFile(String path)
		throws CompilationFailedException, IOException {
		try {
			return evaluate(new File(path));
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}
	
	public void executeWithResourceNamed(String aResourceName,
										 String aFrameworkName,
										 NSArray aLanguageList,
										 NSArray args)
		throws CompilationFailedException, IOException {
		try {
			URL pathURL = WOApplication.application().resourceManager().
				pathURLForResourceNamed(aResourceName,
										aFrameworkName,
										aLanguageList);
			File file = new File(pathURL.getPath());
			ArrayList list = new ArrayList(args.vector());
			run(file, list);
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}
	
	public void executeWithContentOfFile(File file, NSArray args)
		throws CompilationFailedException, IOException {
		try {
			ArrayList list = new ArrayList(args.vector());
			run(file, list);
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}
	
	public void executeWithContentOfFile(String path, NSArray args)
		throws CompilationFailedException, IOException {
		try {
			ArrayList list = new ArrayList(args.vector());
			run(new File(path), list);
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}
	
	public Object executeWithStream(InputStream in, String fileName, NSArray args)
		throws CompilationFailedException, IOException {
		try {
			return run(in, fileName, stringsFromArray(args));
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}
	
	public void executeWithScript(String scriptText, String fileName, NSArray args)
		throws CompilationFailedException, IOException {
		try {
			run(scriptText, fileName, stringsFromArray(args));
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}

	public Script scriptWithResourceNamed(String aResourceName,
										  String aFrameworkName,
										  NSArray aLanguageList)
		throws CompilationFailedException, IOException {
		try {
			URL pathURL = WOApplication.application().resourceManager().
				pathURLForResourceNamed(aResourceName,
										aFrameworkName,
										aLanguageList);
			File file = new File(pathURL.getPath());
			return parse(file);
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}
	
	public Script scriptWithContentOfFile(String path)
		throws CompilationFailedException, IOException {
		try {
			return parse(new File(path));
		} catch (CompilationFailedException cfe) {
			throw cfe;
		} catch (IOException ioe) {
			throw ioe;
		}
	}

	private String[] stringsFromArray(NSArray array) {
		String[] strings = new String[array.count()];
		Object[] objects = array.objects();
		for (int i = 0; i < objects.length; i++) {
			strings[i] = (String)objects[i];
		}
		return strings;
	}
}
