//
//  WOGroovyBinding.java
//  WOGroovy
//

package wogroovy;

import com.webobjects.appserver.*;
import com.webobjects.foundation.*;
import com.webobjects.eoaccess.*;
import com.webobjects.eocontrol.*;
import groovy.lang.*;
import java.util.*;

public class WOGroovyBinding extends Binding {
    private static WOGroovyBinding defaultBinding;
    public static String TranscriptKey             = "transcript";
    public static String ObjectStoreCoordinatorKey = "osc";
    public static String ResourceManagerKey        = "rm";
    public static String ModelGroupKey             = "mgroup";
    public static String NotificationCenterKey     = "nc";
    public static String SharedEditingContextKey   = "sec";
    public static String EditingContextKey         = "ec";
    
    public static WOGroovyBinding defaultBinding() {
        if (defaultBinding == null) {
            defaultBinding = new WOGroovyBinding();
            initializeBinding(defaultBinding);
        }
        return defaultBinding;
    }

    public static void initializeBinding(WOGroovyBinding binding) {
        binding.setObjectForKey(WOTranscript.defaultTranscript, TranscriptKey);
        binding.setObjectForKey(EOObjectStoreCoordinator.defaultCoordinator(),
                                ObjectStoreCoordinatorKey);
        binding.setObjectForKey(WOApplication.application().resourceManager(),
                                ResourceManagerKey);
        binding.setObjectForKey(EOModelGroup.defaultGroup(), ModelGroupKey);
        binding.setObjectForKey(NSNotificationCenter.defaultCenter(),
                                NotificationCenterKey);
        binding.setObjectForKey(EOSharedEditingContext.defaultSharedEditingContext(),
                                SharedEditingContextKey);
    }
    
    public static void setDefaultBinding(WOGroovyBinding binding) {
        defaultBinding = binding;
    }
    
    public WOGroovyBinding() {
        super();
    }
    
    public WOGroovyBinding(NSDictionary dictionary) {
        super();
    }
    
    public Object propertyForKey(String key) {
        return getProperty(key);
    }
    
    public void setPropertyForKey(Object value, String key) {
        setProperty(key, value);
    }
    
    public Object objectForKey(String key) {
        return getVariable(key);
    }
    
    public void setObjectForKey(Object value, String key) {
        setVariable(key ,value);
    }

}
