//
//  WOGroovy.java
//  WOGroovy
//

package wogroovy;

import com.webobjects.appserver.*;
import com.webobjects.eoaccess.*;
import com.webobjects.eocontrol.*;
import com.webobjects.foundation.*;
import er.extensions.*;
import groovy.lang.*;

public class WOGroovy {
    public static Observer observer;

    public static class Observer {
        /**
         * This method is called when the application has finished
         * launching. Here is where log4j is configured for rapid
         * turn around, the compiler proxy is initialized and the
         * validation template system is configured.
         * @param n notification posted when the app is done launching
         */
        public void finishedLaunchingApp(NSNotification n) {
            WOGroovyCompilerProxy.defaultProxy().initialize();
        }
    }
    
    static {
        observer = new Observer();
        try {
            NSNotificationCenter.defaultCenter().addObserver(observer,
                                                             new NSSelector("finishedLaunchingApp", ERXConstant.NotificationClassArray),
                                                             WOApplication.ApplicationWillFinishLaunchingNotification,
                                                             null);
        } catch (Exception e) {
            System.out.println("Caught exception: " + e.getMessage() + " stack: ");
            e.printStackTrace();
        }
    }
    
}
