//
//  StringAdditions.java
//  WOGroovy
//

package wogroovy.additions;

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import er.extensions.*;
import java.util.*;

public class StringAdditions {

    //
    // instance creation
    //

    public static NSTimestamp timestamp(String self) {
        return ERXTimestampUtilities.timestampForString(self);
    }

    public static NSSelector sortSelector(String self) {
        return ERXUtilities.sortSelectorWithKey(self);
    }

    public static Integer integer(String self) {
        return ERXStringUtilities.integerWithString(self);
    }

    public static String keyPathWithoutFirstProperty(String self) {
        return ERXStringUtilities.keyPathWithoutFirstProperty(self);
    }

    public static String keyPathWithoutLastProperty(String self) {
        return ERXStringUtilities.keyPathWithoutLastProperty(self);
    }

    public static String lastPropertyKey(String self) {
        return ERXStringUtilities.lastPropertyKeyInKeyPath(self);
    }

    public static String stringByEscapingApostrophe(String self) {
        return ERXUtilities.escapeApostrophe(self);
    }

    public static String stringByEscapingNonBasicLatinChars(char self) {
        return ERXStringUtilities.escapeNonBasicLatinChars(self);
    }

    public static String stringByEscapingNonBasicLatinChars(String self) {
        return ERXStringUtilities.escapeNonBasicLatinChars(self);
    }

    public static String stringByEscapingSpace(String self) {
        return ERXStringUtilities.escapeSpace(self);
    }

    public static String stringByRemovingExtraDots(String self) {
        return ERXStringUtilities.removeExtraDotsFromVersionString(self);
    }

    public static String stringByReplacingStringByString(String self,
                                                         String old,
                                                         String newString) {
        return ERXStringUtilities.replaceStringByStringInString(self, old, newString);
    }

    public static String stringByAppendingPathComponent(String self,
                                                        String component) {
        return NSPathUtilities.stringByAppendingPathComponent(self, component);
    }

    public static String stringByAppendingPathExtension(String self, String
                                                        extension) {
        return NSPathUtilities.stringByAppendingPathExtension(self, extension);
    }

    public static String stringByDeletingLastPathComponent(String self) {
        return NSPathUtilities.stringByDeletingLastPathComponent(self);
    }

    public static String stringByDeletingPathExtension(String self) {
        return NSPathUtilities.stringByDeletingPathExtension(self);
    }

    public static String stringByNormalizingExistingPath(String self) {
        return NSPathUtilities.stringByNormalizingExistingPath(self);
    }

    public static String stringByNormalizingPath(String self) {
        return NSPathUtilities.stringByNormalizingPath(self);
    }

    public static EOQualifier qualifier(String self) {
        return EOQualifier.qualifierWithQualifierFormat(self, null);
    }

    public static EOQualifier qualifierWithArray(String self, NSArray arguments) {
        return EOQualifier.qualifierWithQualifierFormat(self, arguments);
    }

    public static EOQualifier qualifierWithArray(String self, List arguments) {
        return
            EOQualifier.qualifierWithQualifierFormat(self,
                                                     new NSArray(arguments.toArray()));
    }


    //
    // appending
    //

    public static void appendSeparatorIfLastNot(StringBuffer self,
                                                char separator,
                                                char not) {
        ERXStringUtilities.appendSeparatorIfLastNot(separator, not, self);
    }


    //
    // accessing
    //

    public static String displayName(String self) {
        return ERXStringUtilities.displayNameForKey(self);
    }

    public static double distance(String self,  String other) {
        return ERXStringUtilities.distance(self, other);
    }

    public static String firstPropertyKey(String self) {
        return ERXStringUtilities.firstPropertyKeyInKeyPath(self);
    }

    public static int indexOfNumeric(String self) {
        return ERXStringUtilities.indexOfNumericInString(self);
    }

    public static int indexOfNumeric(String self,  int fromIndex) {
        return ERXStringUtilities.indexOfNumericInString(self, fromIndex);
    }

    public static String lastPathComponent(String self) {
        return NSPathUtilities.lastPathComponent(self);
    }

    public static String pathExtension(String self) {
        return NSPathUtilities.pathExtension(self);
    }


    //
    // converting
    //

    public static String toHexString(char self) {
        return ERXStringUtilities.toHexString(self);
    }

    public static String toHexString(String self) {
        return ERXStringUtilities.toHexString(self);
    }

    public static String toLowerCase(String self) {
        return ERXStringUtilities.toLowerCase(self);
    }


    //
    // decoding
    //

    public static String decodedEntityName(String self) {
        return ERXEOEncodingUtilities.entityNameDecode(self);
    }

}
