//
//  NSTimestampAdditions.java
//  WOGroovy
//

package wogroovy.additions;

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import java.util.*;
import er.extensions.*;

public class NSTimestampAdditions {

    //
    // instance creation
    //

    public static GregorianCalendar calendarForTimestamp(NSTimestamp self) {
        return ERXTimestampUtility.calendarForTimestamp(self);
    }

    public static NSTimestamp dateByAddingTime(NSTimestamp self, NSTimestamp other) {
        return ERXTimestampUtilities.dateByAddingTime(self, other);
    }

    public static NSTimestamp timestampByAddingTime(NSTimestamp self, 
                                                    NSTimestamp other) {
        return ERXTimestampUtilities.timestampByAddingTime(self, other);
    }

    public static Integer unixTimestamp(NSTimestamp self) {
        return ERXTimestampUtilities.unixTimestamp(self);
    }


    //
    // accessing
    //

    public static int dayOfCommonEra(NSTimestamp self) {
        return ERXTimestampUtility.dayOfCommonEra(self);
    }

    public static int dayOfWeek(NSTimestamp self) {
        return ERXTimestampUtility.dayOfWeek(self);
    }

    public static int dayOfYear(NSTimestamp self) {
        return ERXTimestampUtility.dayOfYear(self);
    }

    public static int hourOfDay(NSTimestamp self) {
        return ERXTimestampUtility.hourOfDay(self);
    }

    public static int minuteOfHour(NSTimestamp self) {
        return ERXTimestampUtility.minuteOfHour(self);
    }

    public static int monthOfYear(NSTimestamp self) {
        return ERXTimestampUtility.monthOfYear(self);
    }

    public static int yearOfCommonEra(NSTimestamp self) {
        return ERXTimestampUtility.yearOfCommonEra(self);
    }


    //
    // testing
    //

    public static boolean isEarlierThan(NSTimestamp self,  NSTimestamp other) {
        return ERXTimestampUtilities.isEarlierThan(self, other);
    }

    public static boolean isLaterThan(NSTimestamp self,  NSTimestamp other) {
        return ERXTimestampUtilities.isLaterThan(self, other);
    }


    //
    // comparing
    //

    public static int compareTo(NSTimestamp left, NSTimestamp right) {
        int result = left.compare(right);
        if (result == NSComparator.OrderedAscending)
            return -1;
        else if (result == NSComparator.OrderedDescending)
            return 1;
        else
            return 0;
    }

}
