//
//  NSMutableArrayAdditions.java
//  WOGroovy
//

package wogroovy.additions;

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import er.extensions.*;

public class NSMutableArrayAdditions {

    //
    // accessing
    //
    
    public static void putAt(NSMutableArray self, int index, Object object) {
        self.replaceObjectAtIndex(object, index);
    }


    //
    // adding
    //
    
    public static void leftShift(NSMutableArray self, Object object) {
        self.addObject(object);
    }

    public static NSMutableArray push(NSMutableArray self, Object object) {
        self.addObject(object);
        return self;
    }
    
    public static NSMutableArray unshift(NSMutableArray self, Object object) {
        self.insertObjectAtIndex(object, 0);
        return self;
    }
    
    public static void addObjectsFromArrayWithoutDuplicates(NSMutableArray self,
                                                            NSArray other) {
        ERXArrayUtilities.addObjectsFromArrayWithoutDuplicates(self, other);
    }

    public static void shiftObjectLeft(NSMutableArray self, Object object) {
        ERXArrayUtilities.shiftObjectLeft(self, object);
    }

    public static void shiftObjectRight(NSMutableArray self, Object object) {
        ERXArrayUtilities.shiftObjectRight(self, object);
    }
    
    
    //
    // removing
    //
    
    public static Object pop(NSMutableArray self) {
        if (self.count() == 0)
        	return null;
        else
        	return self.removeLastObject();
    }

    public static Object shift(NSMutableArray self) {
        if (self.count() == 0)
        	return null;
        else
        	return self.removeObjectAtIndex(0);
    }
    
    
    //
    // filtering
    //
    
    public static void filterArrayWithQualifier(NSMutableArray self,
                                                EOQualifier qualifier) {
        EOQualifier.filterArrayWithQualifier(self, qualifier);
    }
    

    //
    // sorting
    //
    
    public static void sortArrayUsingKeyOrderArray(NSMutableArray self,
                                                   NSArray sortOrderings) {
        EOSortOrdering.sortArrayUsingKeyOrderArray(self, sortOrderings);
    }
    

    public static void sortEOsUsingSingleKey(NSMutableArray self, String key) {
        ERXUtilities.sortEOsUsingSingleKey(self, key);
    }

    public static void sortEOsUsingSingleKey(NSMutableArray self,
                                             String key,
                                             NSSelector selector) {
        ERXUtilities.sortEOsUsingSingleKey(self, key, selector);
    }

}
