//
//  NSDictionaryAdditions.java
//  WOGroovy
//

package wogroovy.additions;

import com.webobjects.foundation.*;
import com.webobjects.eocontrol.*;
import er.extensions.*;
import java.util.*;
import groovy.lang.*;
import org.codehaus.groovy.runtime.InvokerHelper;


public class NSDictionaryAdditions {

    //
    // accessing
    //
    
    public static Object getAt(NSDictionary self, Object key) {
        return self.objectForKey(key);
    }
    

    //
    // enumerating
    //
    
    public static void each(NSDictionary self, Closure closure) {
        for (Enumeration e = self.keyEnumerator(); e.hasMoreElements();) {
            Object[] objects = new Object[2];
            objects[0] = e.nextElement();
            objects[1] = self.objectForKey(objects[0]);
            closure.call(objects);
        }
    }
    
    public static void eachKey(NSDictionary self, Closure closure) {
        for (Enumeration e = self.keyEnumerator(); e.hasMoreElements();) {
            closure.call(e.nextElement());
        }
    }
    
    public static void eachValue(NSDictionary self, Closure closure) {
        for (Enumeration e = self.objectEnumerator(); e.hasMoreElements();) {
            closure.call(e.nextElement());
        }
    }

    public static NSArray collect(NSDictionary self, Closure closure) {
        NSMutableArray answer = new NSMutableArray(self);
        for (Enumeration e = self.objectEnumerator(); e.hasMoreElements();) {
            answer.addObject(closure.call(e.nextElement()));
        }
        return answer;
    }

    public static Object find(NSDictionary self, Closure closure) {
        for (Enumeration e = self.objectEnumerator(); e.hasMoreElements();) {
            Object value = e.nextElement();
            if (InvokerHelper.asBool(closure.call(value))) {
                return value;
            }
        }
        return null;
    }

    public static NSArray findAll(NSDictionary self, Closure closure) {
        NSMutableArray answer = new NSMutableArray(self);
        for (Enumeration e = self.objectEnumerator(); e.hasMoreElements();) {
            Object value = e.nextElement();
            if (InvokerHelper.asBool(closure.call(value))) {
                answer.addObject(value);
            }
        }
        return answer;
    }


    //
    // instance creation
    //
    
    public static NSDictionary
        dictionaryByRemovingFromDictionaryKeysInArray(NSDictionary self, NSArray array) {
        return ERXDictionaryUtilities.
            dictionaryByRemovingFromDictionaryKeysInArray(self, array);
    }
    
    public static NSDictionary
        dictionaryWithDictionary(NSDictionary self, NSDictionary other) {
        return ERXDictionaryUtilities.
            dictionaryWithDictionaryAndDictionary(self, other);
    }
    
    public static Map map(NSDictionary self) {
        return new HashMap(self.hashtable());
    }

    public static NSArray sortOrderings(NSDictionary self) {
        NSMutableArray orderings = new NSMutableArray();
        for (Enumeration e = self.keyEnumerator(); e.hasMoreElements();) {
            String key = e.nextElement().toString();
            NSSelector selector = (NSSelector)self.objectForKey(key);
            orderings.addObject(new EOSortOrdering(key, selector));
        }
        return orderings;
    }

}
